/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.propexpr.dialog;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.properties.dialog.PropertyDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.HintsPropertiesList;
import com.jaspersoft.studio.property.infoList.ElementDescription;
import com.jaspersoft.studio.property.infoList.SelectableComposite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.SWTResourceManager;

public class JRPropertyDialog
extends Dialog {
    protected PropertyDTO value;
    protected Composite vcmp;
    protected Text tvalue;
    protected Combo cprop;
    protected List<ElementDescription> hints;
    protected boolean showPropertyName = true;
    protected Composite stackComposite;
    protected StackLayout stackLayout;
    protected SelectableComposite propertiesSuggestions;
    private String title = Messages.JRPropertyDialog_shellTitle;

    public JRPropertyDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setShowPropertyName(boolean showPropertyName) {
        this.showPropertyName = showPropertyName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected ModifyListener getModifyListener() {
        return e -> {
            String newtext = this.cprop.getText();
            this.value.setName(newtext);
            if (this.propertiesSuggestions != null) {
                this.propertiesSuggestions.showOnlyElement(newtext);
            }
        };
    }

    protected void createAdditionalControls(Composite parent) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        List<ElementDescription> h = null;
        if (this.showPropertyName) {
            Label label = new Label(composite, 0);
            label.setText(Messages.JRPropertyDialog_propName);
            h = this.getHints();
            this.cprop = new Combo(composite, 2048);
            GridData gd = new GridData(768);
            gd.widthHint = 300;
            this.cprop.setLayoutData((Object)gd);
            if (h != null) {
                ArrayList<String> comboItems = new ArrayList<String>();
                for (ElementDescription hint : h) {
                    comboItems.add(hint.getName());
                }
                this.cprop.setItems(comboItems.toArray(new String[comboItems.size()]));
            }
            this.cprop.addModifyListener(this.getModifyListener());
        }
        this.createAdditionalControls(composite);
        this.stackComposite = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.stackComposite.setLayoutData((Object)gd);
        this.vcmp = this.createValueControl(this.stackComposite);
        this.stackLayout.topControl = this.vcmp;
        this.fillValue(this.value);
        if (this.showPropertyName && !Misc.isNullOrEmpty(h)) {
            this.createSpecialProperties(composite);
        }
        return composite;
    }

    protected void initializeHints() {
        this.hints = HintsPropertiesList.getElementProperties(this.value.getJrElement(), this.value.geteContext());
        Collections.sort(this.hints);
    }

    protected List<ElementDescription> getHints() {
        if (this.hints == null) {
            this.initializeHints();
        }
        return this.hints;
    }

    protected SelectableComposite createSpecialProperties(Composite cmp) {
        Section expandableSection = new Section(cmp, 4);
        expandableSection.setText(Messages.JRPropertyDialog_spacialProperties);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        expandableSection.setLayoutData((Object)data);
        expandableSection.titleBarTextMarginWidth = 0;
        expandableSection.setFont(SWTResourceManager.getBoldFont((Font)expandableSection.getFont()));
        expandableSection.setSeparatorControl((Control)new Label((Composite)expandableSection, 258));
        this.propertiesSuggestions = new SelectableComposite((Composite)expandableSection);
        GridData compData = new GridData(1808);
        compData.heightHint = 200;
        this.propertiesSuggestions.setLayoutData(compData);
        this.propertiesSuggestions.SetDoubleClickListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedProp = ((ElementDescription)e.data).getName();
                JRPropertyDialog.this.cprop.setText(selectedProp);
            }
        });
        expandableSection.setClient((Control)this.propertiesSuggestions);
        expandableSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){
            private Point oldSize = null;

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState()) {
                    this.oldSize = JRPropertyDialog.this.getShell().getSize();
                }
            }

            public void expansionStateChanged(ExpansionEvent e) {
                if (!JRPropertyDialog.this.propertiesSuggestions.isItemSetted() && e.getState()) {
                    JRPropertyDialog.this.propertiesSuggestions.setItems(JRPropertyDialog.this.getHints());
                }
                if (e.getState()) {
                    Point actualSize = JRPropertyDialog.this.getShell().getSize();
                    JRPropertyDialog.this.getShell().setSize(actualSize.x, actualSize.y + 200);
                } else {
                    JRPropertyDialog.this.getShell().setSize(this.oldSize);
                }
            }
        });
        return this.propertiesSuggestions;
    }

    protected Composite createValueControl(Composite cmp) {
        Composite composite = new Composite(cmp, 0);
        composite.setLayout((Layout)new GridLayout());
        this.tvalue = new Text(composite, 2048);
        this.tvalue.setLayoutData((Object)new GridData(768));
        this.tvalue.setText(Messages.JRPropertyDialog_valuePlaceHolder);
        this.tvalue.addModifyListener(e -> this.value.setValue(this.tvalue.getText()));
        return composite;
    }

    public void setValue(PropertyDTO value) {
        this.value = value;
    }

    private void fillValue(PropertyDTO value) {
        if (this.cprop != null) {
            this.cprop.setText(Misc.nvl((String)value.getName()));
        }
        this.tvalue.setText(this.getValueText(value.getValue()));
    }

    protected String getValueText(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }
}

