/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.resource;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.resource.NResourceCellEditorValidator;
import com.jaspersoft.studio.property.descriptor.resource.ResourceCellEditor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPResourceType;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ResourceBundleFilterDialog;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ResourceBundlePropertyDescriptor
extends NTextPropertyDescriptor {
    public ResourceBundlePropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    @Override
    public CellEditor createPropertyEditor(Composite parent) {
        ResourceCellEditor editor = new ResourceCellEditor(parent){

            @Override
            protected String convertFile2Value(IFile f) {
                return ResourceBundlePropertyDescriptor.convertFile2Value(f);
            }
        };
        editor.setValidator(NResourceCellEditorValidator.instance());
        this.setValidator(NResourceCellEditorValidator.instance());
        HelpSystem.bindToHelp((IPropertyDescriptor)this, editor.getControl());
        return editor;
    }

    public SPBundleType createWidget(Composite parent, AbstractSection section) {
        SPBundleType textWidget = new SPBundleType(parent, section, (IPropertyDescriptor)this);
        textWidget.setReadOnly(this.readOnly);
        return textWidget;
    }

    public static String convertFile2Value(IFile f) {
        return ResourceBundlePropertyDescriptor.convertFile2Value(f.getName().trim());
    }

    public static String convertFile2Value(String filename) {
        int propertiesIndex = filename.toLowerCase().lastIndexOf(".properties");
        if (propertiesIndex != -1) {
            filename = filename.substring(0, propertiesIndex);
        }
        return ResourceBundlePropertyDescriptor.removeLocale(filename);
    }

    private static String removeLocale(String fileName) {
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale loc = localeArray[n2];
            if (fileName.endsWith("_" + loc.toString())) {
                return fileName.substring(0, fileName.length() - loc.toString().length() - 1);
            }
            ++n2;
        }
        return fileName;
    }

    private class SPBundleType
    extends SPResourceType<IPropertyDescriptor> {
        public SPBundleType(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
            super(parent, section, pDescriptor);
        }

        @Override
        protected String convertFile2Value(IFile f) {
            IFile file;
            String fname = ResourceBundlePropertyDescriptor.convertFile2Value(f);
            JasperReportsConfiguration jConf = this.pnode.getJasperConfiguration();
            if (jConf != null && (file = (IFile)jConf.get("ifile")) != null && file.getParent().equals((Object)f.getParent())) {
                return fname;
            }
            String pname = f.getParent().getProjectRelativePath().toOSString();
            if (pname.startsWith("/")) {
                pname = pname.substring(1);
            }
            if (!pname.isEmpty()) {
                pname = String.valueOf(pname) + "/";
            }
            return FilenameUtils.normalize((String)(String.valueOf(pname) + fname), (boolean)true);
        }

        @Override
        protected SelectionAdapter buttonPressed() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IJavaProject openProject = SelectionHelper.getJavaProjectFromCurrentJRXMLEditor();
                    if (openProject != null) {
                        IFile file;
                        ResourceBundleFilterDialog dialog = new ResourceBundleFilterDialog(SPBundleType.this.ftext.getShell(), false, openProject);
                        dialog.setTitle(Messages.ResourceCellEditor_open_resource);
                        if (dialog.open() == 0 && (file = (IFile)dialog.getFirstResult()) != null) {
                            SPBundleType.this.handleTextChanged(SPBundleType.this.section, SPBundleType.this.pDescriptor.getId(), SPBundleType.this.convertFile2Value(file));
                        }
                    }
                }
            };
        }
    }
}

