/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.returnvalue;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.returnvalue.InputReturnValueDialog;
import com.jaspersoft.studio.property.descriptor.returnvalue.ReturnValueContainer;
import com.jaspersoft.studio.swt.events.ChangeEvent;
import com.jaspersoft.studio.swt.events.ChangeListener;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class RVPropertyPage
extends JSSHelpWizardPage {
    public static final int WIDTH_HINT = 730;
    protected List<ReturnValueContainer> values;
    protected Table table;
    protected TableViewer tableViewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    protected String[] toVariables;
    private String[] fromVariables;
    protected JasperDesign design;
    private List<ModifyListener> returnValuesModified = new ArrayList<ModifyListener>();

    protected RVPropertyPage(String pageName, JasperDesign design) {
        super(pageName);
        this.design = design;
    }

    private void createButtons(Composite bGroup) {
        this.addButton = new Button(bGroup, 8);
        this.addButton.setText(Messages.common_add);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RVPropertyPage.this.openAddDialog();
            }
        });
        this.editButton = new Button(bGroup, 8);
        this.editButton.setText(Messages.common_edit);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)RVPropertyPage.this.tableViewer.getSelection();
                if (selection.size() > 0) {
                    ReturnValueContainer selectedValue = (ReturnValueContainer)selection.getFirstElement();
                    RVPropertyPage.this.openEditDialog(selectedValue);
                }
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(bGroup, 8);
        this.deleteButton.setText(Messages.common_delete);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)RVPropertyPage.this.tableViewer.getSelection();
                if (selection.size() > 0) {
                    ReturnValueContainer selectedValue = (ReturnValueContainer)selection.getFirstElement();
                    int index = RVPropertyPage.this.values.indexOf(selectedValue);
                    RVPropertyPage.this.values.remove(index);
                    RVPropertyPage.this.tableViewer.refresh();
                    RVPropertyPage.this.toVariables = null;
                    RVPropertyPage.this.updateButtonsStatus();
                    RVPropertyPage.this.callModifyListeners();
                }
            }
        });
        this.deleteButton.setEnabled(false);
        ListOrderButtons upDownButtons = new ListOrderButtons();
        upDownButtons.createOrderButtons(bGroup, this.tableViewer);
        upDownButtons.addChangeListener(new ChangeListener(){

            @Override
            public void changed(ChangeEvent event) {
                RVPropertyPage.this.callModifyListeners();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)RVPropertyPage.this.tableViewer.getSelection();
                boolean enabledStatus = selection != null && selection.size() > 0;
                RVPropertyPage.this.editButton.setEnabled(enabledStatus);
                RVPropertyPage.this.deleteButton.setEnabled(enabledStatus);
            }
        });
        this.updateButtonsStatus();
    }

    protected void openAddDialog() {
        ReturnValueContainer container = new ReturnValueContainer();
        InputReturnValueDialog inputDialog = new InputReturnValueDialog(this.getShell(), container, this.getToVariablesNames());
        if (inputDialog.open() == 0) {
            this.addElemenet(container);
        }
    }

    protected void addElemenet(ReturnValueContainer container) {
        this.values.add(container);
        this.tableViewer.refresh();
        this.toVariables = null;
        this.fromVariables = null;
        this.updateButtonsStatus();
        this.callModifyListeners();
    }

    protected void openEditDialog(ReturnValueContainer edited) {
        ReturnValueContainer result = edited.clone();
        String[] toVariables = this.getVariablesPlusElement(this.getToVariablesNames(), edited.getToVariable());
        InputReturnValueDialog inputDialog = new InputReturnValueDialog(this.getShell(), result, toVariables);
        if (inputDialog.open() == 0) {
            this.editElement(edited, result);
        }
    }

    protected void editElement(ReturnValueContainer edited, ReturnValueContainer newValue) {
        int index = this.values.indexOf(edited);
        this.values.set(index, newValue);
        this.tableViewer.refresh();
        this.toVariables = null;
        this.fromVariables = null;
        this.updateButtonsStatus();
        this.callModifyListeners();
    }

    protected void updateButtonsStatus() {
        if (this.addButton != null) {
            if (this.getToVariablesNames().length == 0) {
                this.addButton.setEnabled(false);
                this.setErrorMessage(Messages.RVPropertyPage_error_message_report_variables_all_used);
            } else {
                this.addButton.setEnabled(true);
                this.setErrorMessage(null);
            }
        }
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 68100);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.attachCellEditors(this.tableViewer, (Composite)this.table);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 55, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 55, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 55, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(55, 100, true));
        this.table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[4];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.RVPropertyPage_subreport_variable);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.RVPropertyPage_to_variable);
        column[2] = new TableColumn(this.table, 0);
        column[2].setText(Messages.RVPropertyPage_calculation_type);
        column[3] = new TableColumn(this.table, 0);
        column[3].setText(Messages.RVPropertyPage_incrementer_factory_class);
        this.fillTable();
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                int selectedIndex = RVPropertyPage.this.table.getSelectionIndex();
                if (selectedIndex != -1) {
                    ReturnValueContainer selectedElement = RVPropertyPage.this.values.get(selectedIndex);
                    RVPropertyPage.this.openEditDialog(selectedElement);
                }
            }
        });
        viewer.setColumnProperties(new String[]{"FROMVARIABLE", "TOVARIABLE", "CALCULATIONTYPE", "INCREMENTERFACTORYCLASS"});
    }

    protected HashSet<String> getAlreadyUsedToVariables() {
        HashSet<String> result = new HashSet<String>();
        for (ReturnValueContainer value : this.values) {
            result.add(value.getToVariable());
        }
        return result;
    }

    private HashSet<String> getAlreadyUsedFromVariables() {
        HashSet<String> result = new HashSet<String>();
        for (ReturnValueContainer value : this.values) {
            result.add(value.getFromVariable());
        }
        return result;
    }

    protected String[] getToVariablesNames() {
        if (this.toVariables == null) {
            JRVariable[] vlist;
            ArrayList<String> res = new ArrayList<String>();
            HashSet<String> usedVariables = this.getAlreadyUsedToVariables();
            JRVariable[] jRVariableArray = vlist = this.getMainDatasetVariables();
            int n = vlist.length;
            int n2 = 0;
            while (n2 < n) {
                JRVariable o = jRVariableArray[n2];
                JRDesignVariable jdVar = (JRDesignVariable)o;
                if (!jdVar.isSystemDefined() && !usedVariables.contains(jdVar.getName())) {
                    res.add(jdVar.getName());
                }
                ++n2;
            }
            return res.toArray(new String[res.size()]);
        }
        return this.toVariables;
    }

    protected String[] getFromVariablesNames() {
        if (this.fromVariables == null) {
            JRVariable[] vlist;
            ArrayList<String> res = new ArrayList<String>();
            HashSet<String> usedVariables = this.getAlreadyUsedFromVariables();
            JRVariable[] jRVariableArray = vlist = this.getDatasetVariables();
            int n = vlist.length;
            int n2 = 0;
            while (n2 < n) {
                JRVariable o = jRVariableArray[n2];
                JRDesignVariable jdVar = (JRDesignVariable)o;
                if (!jdVar.isSystemDefined() && !usedVariables.contains(jdVar.getName())) {
                    res.add(jdVar.getName());
                }
                ++n2;
            }
            return res.toArray(new String[res.size()]);
        }
        return this.fromVariables;
    }

    protected String[] getVariablesPlusElement(String[] variables, String elementToAdd) {
        String[] result = new String[variables.length + 1];
        result[0] = elementToAdd;
        int i = 1;
        while (i < result.length) {
            result[i] = variables[i - 1];
            ++i;
        }
        return result;
    }

    private void callModifyListeners() {
        Event e = new Event();
        e.data = this.values;
        e.widget = this.table;
        ModifyEvent modEvent = new ModifyEvent(e);
        for (ModifyListener listener : this.returnValuesModified) {
            listener.modifyText(modEvent);
        }
    }

    protected boolean validate() {
        int setSize;
        ArrayList<String> lto = new ArrayList<String>();
        for (ReturnValueContainer d : this.values) {
            lto.add(d.getToVariable());
        }
        int size = lto.size();
        if (size != (setSize = new HashSet(lto).size())) {
            this.setErrorMessage(Messages.RVPropertyPage_error_message_return_variables_contain_duplicate_tovariable_values);
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    protected void fillTable() {
        this.tableViewer.setInput(this.values);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_RETURN_VALUE;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.buildTable(composite);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.minimumWidth = 500;
        gd.widthHint = 500;
        this.table.setLayoutData((Object)gd);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.createButtons(bGroup);
    }

    public void setValue(List<ReturnValueContainer> value) {
        this.values = value == null ? new ArrayList<ReturnValueContainer>() : new ArrayList<ReturnValueContainer>(value);
        if (this.table != null) {
            this.fillTable();
        }
        this.updateButtonsStatus();
    }

    public List<ReturnValueContainer> getValue() {
        return this.values;
    }

    public void addModifyListener(ModifyListener listener) {
        this.returnValuesModified.add(listener);
    }

    public abstract JRVariable[] getDatasetVariables();

    protected JRVariable[] getMainDatasetVariables() {
        if (this.design == null) {
            return new JRVariable[0];
        }
        JRDataset dataset = this.design.getMainDataset();
        if (dataset != null) {
            return dataset.getVariables();
        }
        return new JRVariable[0];
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ReturnValueContainer val = (ReturnValueContainer)element;
            switch (columnIndex) {
                case 0: {
                    return val.getFromVariable();
                }
                case 1: {
                    return val.getToVariable();
                }
                case 2: {
                    return val.getCalculation().getName();
                }
                case 3: {
                    return Misc.nvl((String)val.getIncrementerFactoryClassName());
                }
            }
            return "";
        }
    }
}

