/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.text;

import com.jaspersoft.studio.property.descriptor.EditableDialogCellEditor;
import com.jaspersoft.studio.property.descriptor.text.InputDialog;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class InputDialogCellEditor
extends EditableDialogCellEditor {
    private static final int GAP = 6;
    private Composite composite;
    private String title;
    private Label textLabel;

    public InputDialogCellEditor(Composite parent, String title) {
        this(parent, 0, title);
        this.setValue(new JRDesignQuery());
    }

    public InputDialogCellEditor(Composite parent, int style, String title) {
        super(parent, style);
        this.doSetValue("");
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new CellLayout());
        this.textLabel = new Label(this.composite, 16384);
        this.textLabel.setBackground(bg);
        this.textLabel.setFont(cell.getFont());
        return this.composite;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ValueHandler valueHandler = new ValueHandler();
        InputDialog dialog = new InputDialog(cellEditorWindow.getShell(), this.title, "", (String)this.getValue(), valueHandler);
        return dialog.open() == 0 ? dialog.getValue() : null;
    }

    protected void updateContents(Object value) {
        String jrQuery = (String)value;
        if (jrQuery == null) {
            jrQuery = "";
        }
        this.textLabel.setText(jrQuery);
    }

    private class CellLayout
    extends Layout {
        private CellLayout() {
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point rgbSize = InputDialogCellEditor.this.textLabel.computeSize(-1, -1, force);
            return new Point(6 + rgbSize.x, rgbSize.y);
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point rgbSize = InputDialogCellEditor.this.textLabel.computeSize(-1, -1, force);
            int ty = (bounds.height - rgbSize.y) / 2;
            if (ty < 0) {
                ty = 0;
            }
            InputDialogCellEditor.this.textLabel.setBounds(5, ty, bounds.width - 6, bounds.height);
        }
    }

    protected static class ValueHandler
    implements ICellEditorValidator,
    IInputValidator {
        public String isValid(Object object) {
            return null;
        }

        public String isValid(String text) {
            return this.isValid((Object)text);
        }
    }
}

