/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptors;

import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.help.IHelp;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.text.EditableTextCellEditor;
import com.jaspersoft.studio.property.descriptors.AbstractJSSCellEditorValidator;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.IPropertyDescriptorWidget;
import com.jaspersoft.studio.property.section.widgets.SPPixel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class PixelPropertyDescriptor
extends TextPropertyDescriptor
implements IPropertyDescriptorWidget,
IHelp {
    private boolean readOnly = false;
    protected static final AbstractJSSCellEditorValidator DEFAULT_VALIDATOR = new AbstractJSSCellEditorValidator(){

        public String isValid(Object value) {
            block4: {
                try {
                    if (!(value instanceof Integer)) break block4;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return Messages.common_this_is_not_an_integer_number;
                }
            }
            if (value instanceof String) {
                new Integer((String)value);
            }
            return null;
        }
    };
    private IHelpRefBuilder refBuilder;

    public PixelPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        EditableTextCellEditor editor = new EditableTextCellEditor(parent){

            protected Object doGetValue() {
                String value = (String)super.doGetValue();
                if (value == null || value.equals("")) {
                    return null;
                }
                return new Integer(value);
            }

            protected void doSetValue(Object value) {
                if (value == null) {
                    super.doSetValue((Object)"");
                } else {
                    Assert.isTrue((this.text != null && value instanceof Integer ? 1 : 0) != 0);
                    super.doSetValue((Object)((Integer)value).toString());
                }
            }
        };
        if (this.getValidator() == null) {
            this.setValidator(DEFAULT_VALIDATOR);
        }
        editor.setValidator(this.getValidator());
        HelpSystem.bindToHelp((IPropertyDescriptor)this, editor.getControl());
        return editor;
    }

    public ASPropertyWidget<PixelPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
        SPPixel spNumber = new SPPixel(parent, section, this);
        return spNumber;
    }

    @Override
    public void setHelpRefBuilder(IHelpRefBuilder refBuilder) {
        this.refBuilder = refBuilder;
    }

    @Override
    public String getHelpReference() {
        if (this.refBuilder != null) {
            return this.refBuilder.getHelpReference();
        }
        return null;
    }

    public AbstractJSSCellEditorValidator getValidator() {
        return (AbstractJSSCellEditorValidator)super.getValidator();
    }

    public void setValidator(ICellEditorValidator validator) {
        Assert.isTrue((boolean)(validator instanceof AbstractJSSCellEditorValidator));
        super.setValidator(validator);
    }
}

