/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.infoList;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;

public class ElementDescription
implements Comparable<ElementDescription> {
    private String name;
    private String description;
    private List<SortableStyleRange> textStyles;

    public ElementDescription(String name, String description, boolean parseHtml) {
        this.name = name;
        this.description = Misc.nvl((String)description);
        this.textStyles = new ArrayList<SortableStyleRange>();
        if (parseHtml) {
            this.parseHTMLdescription();
        }
    }

    private void replaceAll(String regex, String replacment) {
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(this.description);
        this.description = matcher.replaceAll(replacment);
    }

    private void removeCode(int index) {
        if (index != -1) {
            int endIndex = this.description.indexOf("</code>");
            SortableStyleRange codeRange = new SortableStyleRange();
            codeRange.start = index;
            codeRange.length = endIndex - index - 6;
            codeRange.fontStyle = 2;
            this.textStyles.add(codeRange);
            this.description = String.valueOf(this.description.substring(0, index)) + this.description.substring(index + 6, endIndex) + this.description.substring(endIndex + 7);
        }
    }

    private void removeBold(int index) {
        if (index != -1) {
            int endIndex = this.description.indexOf("</b>");
            SortableStyleRange codeRange = new SortableStyleRange();
            codeRange.start = index;
            codeRange.length = endIndex - index - 3;
            codeRange.fontStyle = 1;
            this.textStyles.add(codeRange);
            this.description = String.valueOf(this.description.substring(0, index)) + this.description.substring(index + 3, endIndex) + this.description.substring(endIndex + 4);
        }
    }

    private void removeLink(int index) {
        if (index != -1) {
            int startLinkIndex = this.description.indexOf("\"", index + 1);
            int endLinkIndex = this.description.indexOf("\"", startLinkIndex + 1);
            int closeApiIndex = this.description.indexOf(">", endLinkIndex);
            String link = this.description.substring(startLinkIndex + 1, endLinkIndex);
            int endIndex = this.description.indexOf("</api>");
            String linkText = this.description.substring(closeApiIndex + 1, endIndex);
            String stringStart = this.description.substring(0, index);
            SortableStyleRange codeRange = new SortableStyleRange();
            codeRange.start = stringStart.length();
            codeRange.length = linkText.length();
            codeRange.fontStyle = 4;
            codeRange.data = link;
            this.textStyles.add(codeRange);
            this.description = String.valueOf(stringStart) + linkText + this.description.substring(endIndex + 6);
        }
    }

    private Integer getMinimum(int[] numbersArray) {
        Integer minimumIndex = null;
        int actualMinimum = Integer.MAX_VALUE;
        int i = 0;
        while (i < numbersArray.length) {
            int actualNumber = numbersArray[i];
            if (actualNumber != -1 && actualNumber < actualMinimum) {
                minimumIndex = i;
                actualMinimum = actualNumber;
            }
            ++i;
        }
        return minimumIndex;
    }

    private void parseHTMLdescription() {
        this.replaceAll("> +<", "><");
        this.replaceAll("<br>|<br/>|</br>|</ul>|<p>|</p>", "\r\n");
        this.replaceAll("<ul>|</li>", "");
        this.replaceAll("<li>", "\r\n -");
        this.replaceAll("&lt;", "<");
        this.replaceAll("&gt;", ">");
        while (true) {
            int indexCode = this.description.indexOf("<code>");
            int indexBold = this.description.indexOf("<b>");
            int indexLink = this.description.indexOf("<api ");
            Integer min = this.getMinimum(new int[]{indexCode, indexBold, indexLink});
            if (min == null) break;
            if (min == 0) {
                this.removeCode(indexCode);
                continue;
            }
            if (min == 1) {
                this.removeBold(indexBold);
                continue;
            }
            if (min != 2) continue;
            this.removeLink(indexLink);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public StyleRange[] getStyles() {
        Collections.sort(this.textStyles);
        return this.textStyles.toArray(new StyleRange[this.textStyles.size()]);
    }

    @Override
    public int compareTo(ElementDescription o) {
        return this.name.compareTo(o.getName());
    }

    public static List<ElementDescription> getPropertiesInformation(String pathname) {
        ArrayList<ElementDescription> descriptions;
        block6: {
            descriptions = new ArrayList<ElementDescription>();
            FileInputStream fin = null;
            try {
                try {
                    fin = new FileInputStream(new File(pathname));
                    Properties props = new Properties();
                    props.load(fin);
                    for (String pName : props.stringPropertyNames()) {
                        descriptions.add(new ElementDescription(pName, props.getProperty(pName), false));
                    }
                }
                catch (Exception e) {
                    JaspersoftStudioPlugin.getInstance().logError(NLS.bind((String)"Error occurred while opening the file {0}.", (Object)pathname), e);
                    FileUtils.closeStream((Closeable)fin);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(fin);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)fin);
        }
        Collections.sort(descriptions, new Comparator<ElementDescription>(){

            @Override
            public int compare(ElementDescription o1, ElementDescription o2) {
                if (o1.getName() != null && o2.getName() != null) {
                    return o1.getName().compareTo(o2.getName());
                }
                return 0;
            }
        });
        return descriptions;
    }

    private class SortableStyleRange
    extends StyleRange
    implements Comparable<SortableStyleRange> {
        private SortableStyleRange() {
        }

        @Override
        public int compareTo(SortableStyleRange o) {
            return this.start + this.length - (o.start + o.length);
        }
    }
}

