/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.desc;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.util.ItemPropertyUtil;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.graphics.Image;

public abstract class ADescriptor {
    protected boolean showAllProperties = false;
    protected ItemPropertyDescription<?>[] itemProperties;
    protected List<ItemData> itemDatas;
    protected ItemData itemData;
    protected Item item;
    protected ItemProperty oldItemProperty;
    protected APropertyNode pnode;

    public boolean isShowAllProperties() {
        return this.showAllProperties;
    }

    public ItemPropertyDescription<?>[] getItemPropertyDescriptors() {
        if (this.itemProperties == null) {
            this.initItemPropertyDescriptors();
        }
        return this.itemProperties;
    }

    public ItemPropertyDescription<?> getDescription(String id) {
        ItemPropertyDescription<?>[] itemPropertyDescriptionArray = this.getItemPropertyDescriptors();
        int n = itemPropertyDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemPropertyDescription<?> ip = itemPropertyDescriptionArray[n2];
            if (ip.getName().equals(id)) {
                return ip;
            }
            ++n2;
        }
        return null;
    }

    public void setupDefaultValue(Item selected, StandardItemProperty newitem) {
    }

    public String getDisplayName() {
        return Messages.ADescriptor_0;
    }

    protected abstract void initItemPropertyDescriptors();

    public abstract IPropertyEditor getPropertyEditor();

    public Image getIcon(Object element) {
        if (element instanceof ItemData) {
            return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/datasets-16.png");
        }
        return null;
    }

    public void setOldItemProperty(ItemProperty oldItemProperty) {
        this.oldItemProperty = oldItemProperty;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public void setItemData(ItemData itemData) {
        this.itemData = itemData;
    }

    public ItemData getItemData() {
        return this.itemData;
    }

    public void setItemDatas(List<ItemData> itemDatas, APropertyNode pnode) {
        this.itemDatas = itemDatas;
        this.pnode = pnode;
    }

    public void validateItem(ItemProperty itemProperty) throws ValidationError {
        this.validateItem(itemProperty, false);
    }

    public void validateItem(ItemProperty itemProperty, boolean isNew) throws ValidationError {
        if (itemProperty != null) {
            if (Misc.isNullOrEmpty((String)itemProperty.getName())) {
                throw new ValidationError(Messages.ADescriptor_2);
            }
            if (this.item != null) {
                for (ItemProperty ip : this.item.getProperties()) {
                    if (isNew || this.oldItemProperty == ip || ip == itemProperty || !ip.getName().equals(itemProperty.getName())) continue;
                    throw new ValidationError(itemProperty.getName(), Messages.ADescriptor_3);
                }
            }
        } else if (this.itemDatas != null) {
            for (ItemData id : this.itemDatas) {
                ADescriptor.validateItems(id, this.getItemPropertyDescriptors());
            }
        } else if (this.itemData != null) {
            ADescriptor.validateItems(this.itemData, this.getItemPropertyDescriptors());
        }
    }

    public static void validateItems(ItemData id, ItemPropertyDescription<?>[] itemPropDesc) throws ValidationError {
        if (id.getItems() == null) {
            return;
        }
        for (Item it : id.getItems()) {
            if (it.getProperties() == null) continue;
            ItemPropertyDescription<?>[] itemPropertyDescriptionArray = itemPropDesc;
            int n = itemPropDesc.length;
            int n2 = 0;
            while (n2 < n) {
                ItemProperty p;
                ItemPropertyDescription<?> ipd = itemPropertyDescriptionArray[n2];
                if (ipd.isMandatory() && ((p = ItemPropertyUtil.getProperty(it.getProperties(), ipd.getName())) == null || (p.getValueExpression() == null || Misc.isNullOrEmpty((String)p.getValueExpression().getText())) && Misc.isNullOrEmpty((String)p.getValue()))) {
                    throw new ValidationError(ipd.getName(), String.valueOf(ipd.getLabel()) + " is mandatory property.");
                }
                ++n2;
            }
        }
    }
}

