/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.jface.dialogs.EditableDatasetBaseComposite;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.ComponentElementDatasetAdapter;
import com.jaspersoft.studio.model.dataset.ComponentElementDatasetRunAdapter;
import com.jaspersoft.studio.model.dataset.IEditableDatasetRun;
import com.jaspersoft.studio.property.dataset.DatasetRunSelectionListener;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.dialog.ElementDatasetDialog;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AItemDialog
extends ATitledDialog
implements IExpressionContextSetter {
    private JasperReportsConfiguration jrConfig;
    protected List<ItemData> itemDatas;
    protected StandardItemData itemData;
    protected StandardItem item;
    protected ADescriptor descriptor;
    private Button useDatasetB;
    protected Combo dsviewer;
    protected EditableDatasetBaseComposite compositeDatasetInfo;
    protected boolean showDataset = true;
    protected ExpressionContext currentExpContext;
    protected ExpressionContext expContext;
    private Composite dsCmp;
    protected boolean refresh = false;

    public AItemDialog(Shell parentShell, ADescriptor descriptor, JasperReportsConfiguration jrConfig, boolean showDataset) {
        super(parentShell);
        this.setTitle(descriptor.getDisplayName());
        this.setDefaultSize(500, 600);
        this.jrConfig = jrConfig;
        this.descriptor = descriptor;
        this.showDataset = showDataset;
    }

    public boolean close() {
        ArrayList<ItemProperty> todel = new ArrayList<ItemProperty>();
        for (ItemProperty p : this.item.getProperties()) {
            if (p == null || !Misc.isNullOrEmpty((String)p.getValue()) || p.getValueExpression() != null && !Misc.isNullOrEmpty((String)p.getValueExpression().getText())) continue;
            todel.add(p);
        }
        for (ItemProperty p : todel) {
            this.item.removeItemProperty(p);
        }
        this.descriptor.setItem(null);
        return super.close();
    }

    public void setValues(List<ItemData> itemDatas, StandardItemData itemData, StandardItem item) {
        this.item = item;
        this.descriptor.setItem((Item)item);
        this.setItemData(itemData);
        this.itemDatas = itemDatas;
    }

    private void setItemData(StandardItemData itemData) {
        this.itemData = itemData;
        this.descriptor.setItemData((ItemData)itemData);
    }

    public StandardItemData getItemData() {
        return this.itemData;
    }

    protected void fillData() {
        if (this.showDataset) {
            this.useDatasetB.setSelection(this.itemData.getDataset() != null);
            this.setupItemDataCombo();
            this.setupExpressionContext();
            if (this.itemData.getDataset() != null) {
                if (this.compositeDatasetInfo != null) {
                    this.compositeDatasetInfo.dispose();
                }
                this.createDatasetComposite(this.dsCmp, true);
            } else {
                if (this.compositeDatasetInfo != null) {
                    this.compositeDatasetInfo.dispose();
                }
                this.compositeDatasetInfo = null;
            }
        } else {
            this.setupExpressionContext();
        }
        this.setError(null);
        this.validateForm();
        this.tcmp.getParent().update();
        this.tcmp.getParent().layout(true);
    }

    protected void setupItemDataCombo() {
        String[] items = new String[this.itemDatas.size()];
        int i = 0;
        while (i < items.length) {
            ItemData id = this.itemDatas.get(i);
            JRElementDataset ed = id.getDataset();
            if (ed == null) {
                items[i] = Messages.AItemDialog_0;
            } else {
                String string = items[i] = ed.getDatasetRun() != null ? ed.getDatasetRun().getDatasetName() : Messages.AItemDialog_1;
            }
            if (id.getItems() != null) {
                int n = i;
                items[n] = String.valueOf(items[n]) + " ; " + id.getItems().size() + Messages.AItemDialog_3;
            }
            ++i;
        }
        this.dsviewer.setItems(items);
        this.dsviewer.select(this.itemDatas.indexOf(this.itemData));
    }

    protected void validateForm() {
        if (this.refresh) {
            return;
        }
        Button ok = this.getButton(0);
        if (!ok.isEnabled()) {
            ok.setEnabled(true);
        }
        String str = null;
        try {
            this.descriptor.validateItem(null);
        }
        catch (Exception e) {
            str = e.getMessage();
            ok.setEnabled(false);
        }
        this.setError(str);
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        this.currentExpContext = expContext;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        if (this.showDataset) {
            CTabFolder tabFolder = new CTabFolder(cmp, 0x800080);
            tabFolder.setLayoutData((Object)new GridData(1808));
            this.createValue(tabFolder);
            this.createDataset(tabFolder);
        } else {
            this.createValue(cmp);
        }
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AItemDialog.this.fillData();
            }
        });
        return cmp;
    }

    protected abstract void createValue(CTabFolder var1);

    protected abstract void createValue(Composite var1);

    private void createDataset(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.ItemDialog_7);
        Composite cmp = new Composite((Composite)tabFolder, 0);
        cmp.setLayout((Layout)new GridLayout(3, false));
        this.createDataItemSelector(cmp);
        this.useDatasetB = new Button(cmp, 32);
        this.useDatasetB.setText(Messages.ItemDialog_6);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.useDatasetB.setLayoutData((Object)gd);
        this.useDatasetB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AItemDialog.this.handleUseDataset();
            }
        });
        this.dsCmp = new Composite(cmp, 0);
        this.dsCmp.setLayout((Layout)new FillLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.widthHint = 750;
        this.dsCmp.setLayoutData((Object)gd);
        bptab.setControl((Control)cmp);
    }

    protected void createDataItemSelector(Composite cmp) {
        new Label(cmp, 0).setText(Messages.AItemDialog_4);
        this.dsviewer = new Combo(cmp, 8);
        GridData gd = new GridData();
        gd.widthHint = 200;
        this.dsviewer.setLayoutData((Object)gd);
        this.createAddItemDataButton(cmp);
        Label sep = new Label(cmp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        sep.setLayoutData((Object)gd);
        this.dsviewer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AItemDialog.this.handleDsSelectionChanged();
            }
        });
    }

    protected void createAddItemDataButton(Composite cmp) {
        Button dsNewButton = new Button(cmp, 8);
        dsNewButton.setText(Messages.common_add);
        dsNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRDesignElementDataset eds = new JRDesignElementDataset();
                ElementDatasetDialog dialog = new ElementDatasetDialog(UIUtils.getShell(), Messages.ItemDialog_7, Messages.ItemDialog_7, (JRElementDataset)eds, AItemDialog.this.jrConfig);
                dialog.setExpressionContext(AItemDialog.this.currentExpContext);
                if (AItemDialog.this.openChildDialog((Dialog)dialog) == 0) {
                    StandardItemData id = new StandardItemData();
                    id.setDataset(dialog.getDataset());
                    int indx = AItemDialog.this.dsviewer.getSelectionIndex();
                    if (indx >= 0 && indx < AItemDialog.this.itemDatas.size()) {
                        AItemDialog.this.itemDatas.add(indx, (ItemData)id);
                    } else {
                        AItemDialog.this.itemDatas.add((ItemData)id);
                    }
                    Button b = AItemDialog.this.getButton(0);
                    b.setEnabled(true);
                    AItemDialog.this.itemData.removeItem((Item)AItemDialog.this.item);
                    id.addItem((Item)AItemDialog.this.item);
                    AItemDialog.this.setItemData(id);
                    AItemDialog.this.setupExpressionContext();
                    AItemDialog.this.fillData();
                }
            }
        });
    }

    protected void createDatasetComposite(Composite container, boolean center) {
        this.compositeDatasetInfo = new EditableDatasetBaseComposite(new ComponentElementDatasetAdapter((JRDesignElementDataset)this.itemData.getDataset(), this.jrConfig), container, 0){

            @Override
            protected IEditableDatasetRun getEditableDatesetRun() {
                return new ComponentElementDatasetRunAdapter(this.getEditableDataset());
            }
        };
        this.compositeDatasetInfo.addDatasetRunSelectionListener(new DatasetRunSelectionListener(){

            @Override
            public void selectionChanged() {
                ExpressionContext contextFromDSRun = AItemDialog.this.getExpressionContextFromDSRun();
                AItemDialog.this.compositeDatasetInfo.setExpressionContext(contextFromDSRun);
                AItemDialog.this.setExpressionContext(contextFromDSRun);
            }
        });
        this.compositeDatasetInfo.setExpressionContext(this.getExpressionContextFromDSRun());
        this.compositeDatasetInfo.setDefaultExpressionContext(this.expContext);
        this.dsCmp.layout();
        UIUtils.relayoutDialog((Shell)this.getShell(), (int)0, (int)-1);
        if (center) {
            UIUtils.centerDialog((Shell)this.getShell());
        }
    }

    private ExpressionContext getExpressionContextFromDSRun() {
        if (this.itemData.getDataset() != null) {
            JRDesignDataset ds = ModelUtils.getDesignDatasetForDatasetRun(this.jrConfig.getJasperDesign(), this.itemData.getDataset().getDatasetRun());
            return new ExpressionContext(ds, this.jrConfig);
        }
        return null;
    }

    private void handleDsSelectionChanged() {
        int indx = this.dsviewer.getSelectionIndex();
        if (indx >= 0) {
            this.itemData.removeItem((Item)this.item);
            StandardItemData newID = (StandardItemData)this.itemDatas.get(indx);
            newID.addItem((Item)this.item);
            this.setItemData(newID);
            this.compositeDatasetInfo.dispose();
            this.compositeDatasetInfo = null;
            this.fillData();
            this.setupExpressionContext();
            this.validateForm();
        }
    }

    protected void setupExpressionContext() {
        if (this.itemData.getDataset() != null) {
            JRDesignDataset ds = ModelUtils.getDesignDatasetForDatasetRun(this.jrConfig.getJasperDesign(), this.itemData.getDataset().getDatasetRun());
            this.currentExpContext = new ExpressionContext(ds, this.jrConfig);
        } else {
            this.currentExpContext = new ExpressionContext(this.jrConfig);
        }
    }

    private void handleUseDataset() {
        boolean useDs = this.useDatasetB.getSelection();
        if (!useDs) {
            this.itemData.setDataset(null);
            this.compositeDatasetInfo.dispose();
            this.compositeDatasetInfo = null;
        } else {
            this.itemData.setDataset((JRElementDataset)new JRDesignElementDataset());
            this.createDatasetComposite(this.dsCmp, false);
        }
        this.setupItemDataCombo();
        this.setupExpressionContext();
    }
}

