/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.property.infoList.ElementDescription;
import com.jaspersoft.studio.property.infoList.SelectableComposite;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.PropertyEditorAdapter;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.ItemPropertyLayoutData;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TextPropertyDescription;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationTitleAreaDialog;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ItemPropertyDialog
extends PersistentLocationTitleAreaDialog {
    private ItemPropertyDescription<?> ipDesc;
    private String staticValue;
    private JRExpression expressionValue;
    private String propertyName;
    private WItemProperty itemProperty;
    protected ExpressionContext context;
    protected boolean isExpressionMode = false;
    private ADescriptor descriptor;
    private Text propertyNameText;
    private Composite dialogArea;
    private IPropertyEditor internalEditor = new PropertyEditorAdapter(){

        @Override
        public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
            if (ItemPropertyDialog.this.isExpressionMode) {
                ItemPropertyDialog.this.expressionValue = valueExpression;
            } else {
                ItemPropertyDialog.this.staticValue = value;
            }
            ItemPropertyDialog.this.validateDialog();
        }

        @Override
        public JRExpression getPropertyValueExpression(String propertyName) {
            return ItemPropertyDialog.this.getExpressionValue();
        }

        @Override
        public String getPropertyValue(String propertyName) {
            return ItemPropertyDialog.this.getStaticValue();
        }
    };

    public ItemPropertyDialog(Shell parentShell, ItemProperty handledProperty, ADescriptor descriptor, ExpressionContext context) {
        super(parentShell);
        this.setSaveSettings(false);
        this.setDefaultSize(450, 350);
        this.context = context;
        if (handledProperty != null) {
            this.staticValue = handledProperty.getValue();
            this.expressionValue = handledProperty.getValueExpression();
            this.propertyName = handledProperty.getName();
        } else {
            this.staticValue = "";
            this.expressionValue = null;
            this.propertyName = "";
        }
        this.isExpressionMode = this.expressionValue != null;
        this.descriptor = descriptor;
        ItemPropertyDescription<?> ipDesc = descriptor.getDescription(this.propertyName);
        this.ipDesc = ipDesc == null ? new TextPropertyDescription(this.propertyName, "", false) : ipDesc.clone();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ItemPropertyElementDialog_shellTitle);
    }

    protected WItemProperty createProperty(Composite parent, ItemPropertyDescription<?> idDesc, IPropertyEditor editor) {
        return new WItemProperty(parent, 0, this.ipDesc, editor){

            @Override
            public boolean isExpressionMode() {
                return ItemPropertyDialog.this.isExpressionMode;
            }

            @Override
            protected void handleEditButton() {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    wizard.setValue((JRDesignExpression)this.getExpressionValue());
                    wizard.setExpressionContext(this.getExpressionContext());
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(this.getShell(), wizard);
                    if (dialog.open() == 0) {
                        JRDesignExpression value = wizard.getValue();
                        this.setValue(null, (JRExpression)value);
                    }
                }
            }
        };
    }

    public JRExpression getExpressionValue() {
        return this.expressionValue;
    }

    public String getStaticValue() {
        return this.staticValue;
    }

    public StandardItemProperty getValue() {
        return new StandardItemProperty(this.propertyName, this.getStaticValue(), this.getExpressionValue());
    }

    public boolean close() {
        this.descriptor.setOldItemProperty(null);
        if (this.isExpressionMode) {
            this.staticValue = null;
            if (this.expressionValue == null) {
                this.expressionValue = new JRDesignExpression();
            }
        } else {
            this.expressionValue = null;
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ItemPropertyDialog_EditItemProperty);
        this.setMessage("Define the value of the new property");
        this.dialogArea = new Composite(parent, 0);
        this.dialogArea.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.dialogArea.setLayout((Layout)layout);
        Label lblPropertyName = new Label(this.dialogArea, 0);
        lblPropertyName.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblPropertyName.setText(Messages.ItemPropertyDialog_PropertyName);
        this.propertyNameText = new Text(this.dialogArea, 2048);
        this.propertyNameText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.propertyNameText.setText(this.propertyName);
        Button useExpressionCheckbox = new Button(this.dialogArea, 32);
        useExpressionCheckbox.setText(Messages.ItemPropertyElementDialog_2);
        useExpressionCheckbox.setLayoutData((Object)new GridData(4, 4, true, false));
        useExpressionCheckbox.setSelection(this.isExpressionMode);
        useExpressionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemPropertyDialog.this.isExpressionMode = ((Button)e.widget).getSelection();
                ItemPropertyDialog.this.itemProperty.updateWidget();
                ItemPropertyDialog.this.validateDialog();
            }
        });
        Label lblPropertyValue = new Label(this.dialogArea, 0);
        lblPropertyValue.setText(Messages.ItemPropertyDialog_PropertyValue);
        lblPropertyValue.setLayoutData((Object)new GridData(4, 4, true, false));
        this.itemProperty = this.createProperty(this.dialogArea, this.ipDesc, this.internalEditor);
        this.itemProperty.setLayoutData(new GridData(1808));
        ItemPropertyLayoutData contentLayout = new ItemPropertyLayoutData();
        contentLayout.expressionFillVertical = true;
        contentLayout.buttonVisibleSimpleMode = false;
        this.itemProperty.setContentLayoutData(contentLayout);
        this.itemProperty.setExpressionContext(this.context);
        List<ElementDescription> hints = this.getPropertiesInformation();
        if (!hints.isEmpty()) {
            final SelectableComposite infoPanel = new SelectableComposite(this.dialogArea);
            infoPanel.setItems(hints);
            GridData infoGD = new GridData(4, 4, true, true);
            infoGD.heightHint = 200;
            infoGD.verticalIndent = 5;
            infoPanel.setLayoutData(infoGD);
            infoPanel.SetDoubleClickListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String newname = infoPanel.getSelectedElement().getName();
                    ItemPropertyDescription<?> ipDescNew = ItemPropertyDialog.this.descriptor.getDescription(newname);
                    if (ipDescNew != null) {
                        ItemPropertyDialog.this.propertyName = newname;
                        ItemPropertyDialog.this.staticValue = ipDescNew.getDefaultValueString();
                        ItemPropertyDialog.this.expressionValue = null;
                        ItemPropertyDescription<?> ipDesc = ItemPropertyDialog.this.descriptor.getDescription(ItemPropertyDialog.this.propertyName);
                        ItemPropertyDialog.this.rebuildWidget(ipDesc);
                    }
                }
            });
        }
        this.itemProperty.updateWidget();
        this.addListeners();
        return this.dialogArea;
    }

    protected void rebuildWidget(ItemPropertyDescription<?> ipDesc) {
        this.itemProperty.dispose();
        this.ipDesc = ipDesc == null ? new TextPropertyDescription(this.propertyName, "", false) : ipDesc.clone();
        this.itemProperty = this.createProperty(this.dialogArea, this.ipDesc, this.internalEditor);
        this.itemProperty.setLayoutData(new GridData(1808));
        ItemPropertyLayoutData contentLayout = new ItemPropertyLayoutData();
        contentLayout.expressionFillVertical = true;
        contentLayout.buttonVisibleSimpleMode = false;
        this.itemProperty.setContentLayoutData(contentLayout);
        this.itemProperty.setExpressionContext(this.context);
        this.dialogArea.layout();
        this.itemProperty.updateWidget();
    }

    private void addListeners() {
        this.propertyNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Point p = ItemPropertyDialog.this.propertyNameText.getSelection();
                ItemPropertyDialog.this.propertyName = ItemPropertyDialog.this.propertyNameText.getText();
                ItemPropertyDescription<?> ipDesc = ItemPropertyDialog.this.descriptor.getDescription(ItemPropertyDialog.this.propertyName);
                ItemPropertyDialog.this.rebuildWidget(ipDesc);
                ItemPropertyDialog.this.propertyNameText.setSelection(p);
                ItemPropertyDialog.this.validateDialog();
            }
        });
    }

    protected Control createContents(Composite parent) {
        Control cmp = super.createContents(parent);
        this.validateDialog();
        return cmp;
    }

    private List<ElementDescription> getPropertiesInformation() {
        ArrayList<ElementDescription> descriptions = new ArrayList<ElementDescription>();
        ItemPropertyDescription<?>[] itemPropertyDescriptionArray = this.descriptor.getItemPropertyDescriptors();
        int n = itemPropertyDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemPropertyDescription<?> ipd = itemPropertyDescriptionArray[n2];
            descriptions.add(new ElementDescription(ipd.getName(), ipd.getDescription(), false));
            ++n2;
        }
        return descriptions;
    }

    protected void validateDialog() {
        Button ok = this.getButton(0);
        String str = null;
        try {
            this.descriptor.validateItem((ItemProperty)this.getValue());
        }
        catch (Exception e) {
            str = e.getMessage();
        }
        if (Misc.isNullOrEmpty((String)str)) {
            this.setErrorMessage(null);
            if (ok != null) {
                ok.setEnabled(true);
            }
        } else {
            this.setErrorMessage(str);
            if (ok != null) {
                ok.setEnabled(false);
            }
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x8000);
        this.setBlockOnOpen(true);
    }
}

