/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.itemproperty.sp;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.property.itemproperty.desc.AItemDataListPropertyDescriptor;
import com.jaspersoft.studio.property.itemproperty.dialog.AItemDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.ItemDataDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.TableItemDialog;
import com.jaspersoft.studio.property.itemproperty.label.ItemLabelProvider;
import com.jaspersoft.studio.property.itemproperty.sp.ItemDataListContentProvider;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPItemDataList
extends ASPropertyWidget<AItemDataListPropertyDescriptor>
implements IExpressionContextSetter {
    protected ExpressionContext expContext;
    private TreeViewer elTViewer;
    private Button btnAddElement;
    private Button btnEditElement;
    private Button btnDelElement;
    protected TreeViewer dsTViewer;
    private Button btnAddNewDataset;
    private Button btnModifyDataset;
    private Button btnRemoveDataset;
    private Control control;
    protected Map<String, Object> postCreateMap = new HashMap<String, Object>();
    protected List<ItemData> itemDatas;
    private Button btnUpDataset;
    private Button btnDownDataset;
    protected APropertyNode pnode;
    private TabFolder tabfolder;

    public SPItemDataList(Composite parent, AbstractSection section, AItemDataListPropertyDescriptor pDescriptor) {
        this(parent, section, pDescriptor, true);
    }

    public SPItemDataList(Composite parent, AbstractSection section, AItemDataListPropertyDescriptor pDescriptor, boolean showElements) {
        super(parent, section, pDescriptor);
        if (showElements) {
            this.control = this.createComponentTab(parent);
        } else {
            this.control = this.createDatasetsTab(parent);
            GridData gd = new GridData(4, 128, true, false, 1, 1);
            gd.heightHint = 300;
            this.control.setLayoutData((Object)gd);
        }
        if (this.getControl() != null) {
            this.setupFocusControl((IPropertyDescriptor)pDescriptor, this.getControl());
        }
    }

    private ADescriptor getDescriptor() {
        return ((AItemDataListPropertyDescriptor)this.pDescriptor).getDescriptor();
    }

    @Override
    protected void createComponent(Composite parent) {
    }

    protected Control createComponentTab(Composite parent) {
        this.tabfolder = new TabFolder(parent, 0);
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        gd.heightHint = 300;
        this.tabfolder.setLayoutData((Object)gd);
        TabItem elementsTab = new TabItem(this.tabfolder, 0);
        elementsTab.setText(((AItemDataListPropertyDescriptor)this.pDescriptor).getDisplayName());
        elementsTab.setControl(this.createElementsTab((Composite)this.tabfolder));
        TabItem datasetsTab = new TabItem(this.tabfolder, 0);
        datasetsTab.setText(Messages.SPItemDataList_5);
        datasetsTab.setControl((Control)this.createDatasetsTab((Composite)this.tabfolder));
        return this.tabfolder;
    }

    protected ViewerComparator getElementViewerComparator() {
        return null;
    }

    private Control createElementsTab(Composite parentFolder) {
        Composite elementsCmp = this.section.getWidgetFactory().createComposite(parentFolder);
        elementsCmp.setLayout((Layout)new GridLayout(2, false));
        this.elTViewer = new TreeViewer(elementsCmp, 2820);
        Tree elementsTree = this.elTViewer.getTree();
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        elementsTree.setLayoutData((Object)gd);
        this.elTViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider(this.getDescriptor()));
        this.elTViewer.setContentProvider((IContentProvider)new ItemDataListContentProvider(true));
        this.elTViewer.setComparator(this.getElementViewerComparator());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.elTViewer, (int)2);
        this.elTViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SPItemDataList.this.enableDefaultTreeButtons();
            }
        });
        this.elTViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SPItemDataList.this.handleEditElement(SPItemDataList.this.elTViewer);
            }
        });
        this.btnAddElement = this.section.getWidgetFactory().createButton(elementsCmp, Messages.SPItemdDataList_0, 8);
        this.btnAddElement.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnAddElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPItemDataList.this.handleNewElement(SPItemDataList.this.elTViewer);
            }
        });
        this.btnEditElement = this.section.getWidgetFactory().createButton(elementsCmp, Messages.SPItemDataList_1, 0);
        this.btnEditElement.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnEditElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPItemDataList.this.handleEditElement(SPItemDataList.this.elTViewer);
            }
        });
        this.btnDelElement = this.section.getWidgetFactory().createButton(elementsCmp, Messages.SPItemDataList_2, 0);
        this.btnDelElement.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnDelElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPItemDataList.this.handleDeleteElement(SPItemDataList.this.elTViewer);
            }
        });
        this.enableDefaultTreeButtons();
        return elementsCmp;
    }

    private void handleEditElement(TreeViewer tviewer) {
        StandardItemData itemDataClone;
        List clones;
        ItemDataDialog dialog;
        StructuredSelection sel = (StructuredSelection)tviewer.getSelection();
        sel.getFirstElement();
        Object obj = sel.getFirstElement();
        if (sel == null || obj == null) {
            return;
        }
        if (obj instanceof StandardItem) {
            List clones2 = JRCloneUtils.cloneList(this.itemDatas);
            StandardItemData itemData = (StandardItemData)this.getStandardItemData(false, tviewer, this.itemDatas);
            StandardItemData itemDataClone2 = (StandardItemData)this.getStandardItemData(false, tviewer, clones2);
            int ind = itemData.getItems().indexOf((StandardItem)obj);
            if (ind >= 0) {
                StandardItem item = (StandardItem)itemDataClone2.getItems().get(ind);
                this.showItemDialog(clones2, itemDataClone2, item);
            }
        } else if (obj instanceof StandardItemData && (dialog = this.createItemDataDialog(clones = JRCloneUtils.cloneList(this.itemDatas), itemDataClone = (StandardItemData)this.getStandardItemData(false, tviewer, clones))).open() == 0) {
            this.postCreateItemDialog(new ArrayList<ItemData>(clones));
        }
    }

    protected void addPostCreateCommand(String id, Object value) {
        Object obj = this.pnode.getPropertyValue(id);
        if (obj instanceof ItemProperty && value != null && ((ItemProperty)obj).getValueExpression() != null) {
            return;
        }
        this.postCreateMap.put(id, value);
    }

    protected void postCreateItemDialog(List<ItemData> clones) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        for (String key : this.postCreateMap.keySet()) {
            cmds.add(this.section.getChangePropertyCommand(key, this.postCreateMap.get(key), this.pnode));
        }
        this.postCreateMap.clear();
        this.section.changeProperty(((AItemDataListPropertyDescriptor)this.pDescriptor).getId(), new ArrayList<ItemData>(clones), cmds);
    }

    private void handleDeleteElement(TreeViewer tviewer) {
        List clones = JRCloneUtils.cloneList(this.itemDatas);
        StructuredSelection sel = (StructuredSelection)tviewer.getSelection();
        Object obj = sel.getFirstElement();
        if (sel == null || obj == null) {
            return;
        }
        if (obj instanceof StandardItem) {
            StandardItem item = (StandardItem)obj;
            StandardItemData itemData = (StandardItemData)this.getStandardItemData(false, tviewer, this.itemDatas);
            if (itemData != null) {
                StandardItemData itemDataClone = (StandardItemData)this.getStandardItemData(false, tviewer, clones);
                int ind = itemData.getItems().indexOf(item);
                if (ind >= 0 && !itemData.getItems().isEmpty()) {
                    itemDataClone.removeItem((Item)itemDataClone.getItems().get(ind));
                }
            }
        } else if (obj instanceof StandardItemData) {
            StandardItemData itemData = (StandardItemData)obj;
            StandardItemData itemDataClone = (StandardItemData)this.getStandardItemData(false, tviewer, clones);
            int ind = this.itemDatas.indexOf(itemData);
            if (ind >= 0) {
                clones.remove(itemDataClone);
            }
        } else {
            return;
        }
        this.section.changeProperty(((AItemDataListPropertyDescriptor)this.pDescriptor).getId(), new ArrayList(clones));
    }

    protected void handleNewElement(TreeViewer tviewer) {
        List clones = JRCloneUtils.cloneList(this.itemDatas);
        StandardItemData itemData = new StandardItemData();
        clones.add(itemData);
        if (this.createItemDataDialog(clones, itemData).open() == 0) {
            this.postCreateItemDialog(new ArrayList<ItemData>(clones));
        }
    }

    protected ItemDataDialog createItemDataDialog(List<ItemData> clones, StandardItemData itemData) {
        ItemDataDialog dialog = new ItemDataDialog(UIUtils.getShell(), Messages.SPItemDataList_6, Messages.SPItemDataList_7, clones, itemData, this.section.getJasperReportsContext(), this.getDescriptor(), this.expContext, this.pnode){

            @Override
            protected AItemDialog createItemDialog() {
                return SPItemDataList.this.createItemDialog();
            }
        };
        return dialog;
    }

    protected void showItemDialog(List<ItemData> citemsData, StandardItemData itemData, StandardItem item) {
        this.getDescriptor().setItemDatas(citemsData, this.pnode);
        this.getDescriptor().setItemData((ItemData)itemData);
        AItemDialog dialog = this.createItemDialog();
        dialog.setValues(citemsData, itemData, item);
        dialog.setExpressionContext(this.expContext);
        if (dialog.open() == 0) {
            this.section.changeProperty(((AItemDataListPropertyDescriptor)this.pDescriptor).getId(), citemsData);
            this.setElementSelection((ItemData)dialog.getItemData(), (Item)item);
            this.getDescriptor().setItem(null);
        }
    }

    protected AItemDialog createItemDialog() {
        return new TableItemDialog(UIUtils.getShell(), this.getDescriptor(), this.section.getJasperReportsContext(), false);
    }

    private ItemData getStandardItemData(boolean createNew, TreeViewer tviewer, List<ItemData> clones) {
        IStructuredSelection sel = (IStructuredSelection)tviewer.getSelection();
        Object fe = sel.getFirstElement();
        if (fe != null) {
            if (fe instanceof StandardItemData) {
                return clones.get(this.itemDatas.indexOf((StandardItemData)fe));
            }
            if (fe instanceof StandardItem) {
                for (ItemData sid : this.itemDatas) {
                    for (Item it : sid.getItems()) {
                        if (it != fe) continue;
                        return clones.get(this.itemDatas.indexOf(sid));
                    }
                }
            }
        } else if (!Misc.isNullOrEmpty(this.itemDatas)) {
            return (StandardItemData)clones.get(0);
        }
        return createNew ? new StandardItemData() : null;
    }

    private void setElementSelection(final ItemData itemData, final Item item) {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SPItemDataList.this.elTViewer != null) {
                    SPItemDataList.this.elTViewer.expandToLevel((Object)itemData, 1);
                    if (item != null) {
                        SPItemDataList.this.elTViewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
                    } else {
                        SPItemDataList.this.elTViewer.setSelection((ISelection)new StructuredSelection((Object)itemData), true);
                    }
                }
                SPItemDataList.this.dsTViewer.expandToLevel((Object)itemData, 1);
                if (item != null) {
                    SPItemDataList.this.dsTViewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
                } else {
                    SPItemDataList.this.dsTViewer.setSelection((ISelection)new StructuredSelection((Object)itemData), true);
                }
            }
        });
    }

    private Composite createDatasetsTab(Composite parentFolder) {
        Composite datasetsCmp = this.section.getWidgetFactory().createComposite(parentFolder);
        datasetsCmp.setLayout((Layout)new GridLayout(2, false));
        this.dsTViewer = new TreeViewer(datasetsCmp, 2820);
        Tree tree = this.dsTViewer.getTree();
        GridData gd = new GridData(1808);
        gd.verticalSpan = 5;
        tree.setLayoutData((Object)gd);
        this.createDsLabelProvider();
        this.dsTViewer.setContentProvider((IContentProvider)new ItemDataListContentProvider(true){

            @Override
            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ItemData) {
                    return new Object[0];
                }
                return super.getChildren(parentElement);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.dsTViewer, (int)2);
        this.dsTViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SPItemDataList.this.enableDefaultDatasetsButtons();
            }
        });
        this.dsTViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SPItemDataList.this.handleEditElement(SPItemDataList.this.dsTViewer);
            }
        });
        this.btnAddNewDataset = this.section.getWidgetFactory().createButton(datasetsCmp, Messages.SPItemdDataList_0, 0);
        this.btnAddNewDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnAddNewDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPItemDataList.this.handleNewElement(SPItemDataList.this.dsTViewer);
            }
        });
        this.btnModifyDataset = this.section.getWidgetFactory().createButton(datasetsCmp, Messages.SPItemDataList_1, 0);
        this.btnModifyDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnModifyDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPItemDataList.this.handleEditElement(SPItemDataList.this.dsTViewer);
            }
        });
        this.btnRemoveDataset = this.section.getWidgetFactory().createButton(datasetsCmp, Messages.SPItemDataList_2, 0);
        this.btnRemoveDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnRemoveDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPItemDataList.this.handleDeleteElement(SPItemDataList.this.dsTViewer);
            }
        });
        this.btnUpDataset = this.section.getWidgetFactory().createButton(datasetsCmp, Messages.SPItemDataList_0, 0);
        this.btnUpDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnUpDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPItemDataList.this.handleUpElement(SPItemDataList.this.dsTViewer);
            }
        });
        this.btnDownDataset = this.section.getWidgetFactory().createButton(datasetsCmp, Messages.SPItemDataList_4, 0);
        this.btnDownDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnDownDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPItemDataList.this.handleDownElement(SPItemDataList.this.dsTViewer);
            }
        });
        this.enableDefaultDatasetsButtons();
        return datasetsCmp;
    }

    protected void createDsLabelProvider() {
        this.dsTViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider(this.getDescriptor()){

            @Override
            public Image getImage(Object element) {
                return null;
            }

            @Override
            public String getText4ItemData(ItemData element) {
                return "Item Data " + (SPItemDataList.this.itemDatas.indexOf(element) + 1);
            }
        });
    }

    private void handleUpElement(TreeViewer tviewer) {
        this.moveItem(true);
    }

    private void handleDownElement(TreeViewer tviewer) {
        this.moveItem(false);
    }

    protected JRPropertyChangeSupport getComponentEventSupport(JRDesignComponentElement jrElement) {
        Component c = jrElement.getComponent();
        if (c instanceof JRChangeEventsSupport) {
            return ((JRChangeEventsSupport)c).getEventSupport();
        }
        return null;
    }

    private void moveItem(boolean up) {
        StructuredSelection selection = (StructuredSelection)this.dsTViewer.getSelection();
        if (selection == null) {
            return;
        }
        Object sel = selection.getFirstElement();
        if (sel instanceof Item) {
            Item item = (Item)sel;
            JRPropertyChangeSupport es = this.getComponentEventSupport((JRDesignComponentElement)this.pnode.getValue());
            for (ItemData id : this.itemDatas) {
                int size;
                List items = id.getItems();
                if (Misc.isNullOrEmpty((Collection)items) || (size = items.size()) <= 1) continue;
                int i = 0;
                while (i < size) {
                    if (items.get(i) == item) {
                        int ind = items.indexOf(item);
                        int newind = up ? Math.max(0, ind - 1) : Math.min(items.size() - 1, ind + 1);
                        Item tmp = (Item)items.get(newind);
                        items.set(newind, item);
                        items.set(ind, tmp);
                        if (es != null) {
                            es.fireIndexedPropertyChange((String)((AItemDataListPropertyDescriptor)this.pDescriptor).getId(), newind, (Object)tmp, (Object)item);
                        }
                        if (this.elTViewer != null) {
                            this.elTViewer.refresh(true);
                        }
                        this.dsTViewer.refresh(true);
                        this.btnUpDataset.setEnabled(newind > 0);
                        this.btnDownDataset.setEnabled(newind < size - 1);
                        this.setElementSelection(id, item);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        Object expContextAdapter;
        this.pnode = pnode;
        this.itemDatas = (List)value;
        if (this.elTViewer != null) {
            this.elTViewer.setInput(this.itemDatas);
        }
        this.dsTViewer.setInput(this.itemDatas);
        this.getDescriptor().setItemDatas(this.itemDatas, pnode);
        this.enableDefaultDatasetsButtons();
        this.enableDefaultTreeButtons();
        JRDesignElement designEl = null;
        if (pnode.getValue() instanceof JRDesignElement) {
            designEl = (JRDesignElement)pnode.getValue();
        }
        if ((expContextAdapter = pnode.getAdapter(ExpressionContext.class)) != null) {
            this.setExpressionContext((ExpressionContext)expContextAdapter);
        } else {
            this.setExpressionContext(ModelUtils.getElementExpressionContext(designEl, pnode));
        }
        this.dsTViewer.expandAll();
    }

    private void enableDefaultTreeButtons() {
        if (this.elTViewer == null) {
            return;
        }
        this.btnAddElement.setEnabled(true);
        boolean enableMoveBtns = !this.elTViewer.getSelection().isEmpty();
        this.btnEditElement.setEnabled(enableMoveBtns);
        this.btnDelElement.setEnabled(enableMoveBtns);
    }

    private void enableDefaultDatasetsButtons() {
        this.btnAddNewDataset.setEnabled(true);
        StructuredSelection selection = (StructuredSelection)this.dsTViewer.getSelection();
        this.btnModifyDataset.setEnabled(!selection.isEmpty());
        this.btnRemoveDataset.setEnabled(!selection.isEmpty());
        Object sel = selection.getFirstElement();
        if (sel instanceof Item) {
            Item item = (Item)sel;
            for (ItemData id : this.itemDatas) {
                int size;
                List items = id.getItems();
                if (Misc.isNullOrEmpty((Collection)items) || (size = items.size()) <= 1) continue;
                int i = 0;
                while (i < size) {
                    if (items.get(i) == item) {
                        this.btnUpDataset.setEnabled(i > 0);
                        this.btnDownDataset.setEnabled(i < size - 1);
                        return;
                    }
                    ++i;
                }
            }
        }
        this.btnUpDataset.setEnabled(false);
        this.btnDownDataset.setEnabled(false);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public int getSelectedItemDataIndex() {
        StructuredSelection sel = null;
        sel = this.elTViewer != null && this.tabfolder.getSelectionIndex() == 0 ? (StructuredSelection)this.elTViewer.getSelection() : (StructuredSelection)this.dsTViewer.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof ItemData) {
            return this.itemDatas.indexOf(obj);
        }
        if (obj instanceof Item) {
            Item item = (Item)obj;
            for (ItemData id : this.itemDatas) {
                List items = id.getItems();
                if (Misc.isNullOrEmpty((Collection)items)) continue;
                for (Item it : items) {
                    if (it != item) continue;
                    return this.itemDatas.indexOf(id);
                }
            }
        }
        if (!Misc.isNullOrEmpty(this.itemDatas)) {
            return 0;
        }
        return -1;
    }
}

