/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.propertiesviewer;

import com.jaspersoft.studio.property.propertiesviewer.IPropertiesViewerNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.PatternFilter;

public class PropertiesPatternFilter
extends PatternFilter {
    private Map<IPropertiesViewerNode, Collection<String>> keywordCache = new HashMap<IPropertiesViewerNode, Collection<String>>();

    private String[] getKeywords(Object element) {
        ArrayList<String> keywordList = new ArrayList<String>();
        if (element instanceof IPropertiesViewerNode) {
            IPropertiesViewerNode node = (IPropertiesViewerNode)element;
            Collection<String> keywordCollection = this.keywordCache.get(element);
            if (keywordCollection == null) {
                keywordCollection = node.getNodeKeywords();
                this.keywordCache.put(node, keywordCollection);
            }
            if (!keywordCollection.isEmpty()) {
                keywordList.addAll(keywordCollection);
            }
        }
        return keywordList.toArray(new String[keywordList.size()]);
    }

    public boolean isElementSelectable(Object element) {
        return element instanceof IPropertiesViewerNode;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        IPropertiesViewerNode node;
        if (WorkbenchActivityHelper.restrictUseOf((Object)element)) {
            return false;
        }
        if (this.isLeafMatch(viewer, element)) {
            return true;
        }
        ITreeContentProvider contentProvider = (ITreeContentProvider)((TreeViewer)viewer).getContentProvider();
        Object[] children = contentProvider.getChildren((Object)(node = (IPropertiesViewerNode)element));
        return this.filter(viewer, element, children).length > 0;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        IPropertiesViewerNode node = (IPropertiesViewerNode)element;
        String text = node.getName();
        if (this.wordMatches(text)) {
            return true;
        }
        String[] keywords = this.getKeywords(node);
        int i = 0;
        while (i < keywords.length) {
            if (this.wordMatches(keywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

