/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.propertiesviewer;

import com.jaspersoft.studio.property.propertiesviewer.IPropertiesViewerNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PropertiesViewerContentProvider<T extends IPropertiesViewerNode>
implements ITreeContentProvider {
    private List<T> nodes = new ArrayList<T>();

    public PropertiesViewerContentProvider(List<T> allNodes) {
        Assert.isNotNull(allNodes);
        this.nodes.addAll(allNodes);
    }

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof IPropertiesViewerNode) || parentElement == null) {
            return null;
        }
        IPropertiesViewerNode parent = (IPropertiesViewerNode)parentElement;
        ArrayList<IPropertiesViewerNode> children = new ArrayList<IPropertiesViewerNode>();
        for (IPropertiesViewerNode node : this.nodes) {
            if (node.getCategory() == null || !parent.getId().equals(node.getCategory())) continue;
            children.add(node);
        }
        return children.toArray();
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<IPropertiesViewerNode> children = new ArrayList<IPropertiesViewerNode>();
        for (IPropertiesViewerNode node : this.nodes) {
            if (node.getCategory() != null) continue;
            children.add(node);
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (!(element instanceof IPropertiesViewerNode)) {
            return null;
        }
        IPropertiesViewerNode node = (IPropertiesViewerNode)element;
        if (node.getCategory() == null) {
            return null;
        }
        for (IPropertiesViewerNode parent : this.nodes) {
            if (!parent.getId().equals(node.getCategory())) continue;
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

