/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.report.EditorContributor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.properties.internal.IHighlightPropertyWidget;
import com.jaspersoft.studio.properties.internal.IWidgetsProviderSection;
import com.jaspersoft.studio.properties.internal.WidgetDescriptor;
import com.jaspersoft.studio.properties.view.AbstractPropertySection;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetWidgetFactory;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.property.ISetValueCommandProvider;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPWidgetFactory;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class AbstractSection
extends AbstractPropertySection
implements PropertyChangeListener,
IWidgetsProviderSection {
    protected Map<Object, ASPropertyWidget<?>> widgets = new HashMap();
    protected JasperReportsConfiguration jasperReportsContext;
    private List<APropertyNode> elements;
    private APropertyNode element;
    private EditDomain editDomain;
    protected HashMap<Object, WidgetDescriptor> providedProperties = null;
    protected Composite parent;
    private boolean isRefreshing = false;

    public void refresh() {
        this.setRefreshing(true);
        APropertyNode el = this.getElement();
        if (el != null) {
            el.getPropertyDescriptors();
            for (Object key : this.widgets.keySet()) {
                this.widgets.get(key).setData(el, el.getPropertyValue(key));
            }
        }
        this.setRefreshing(false);
    }

    public ASPropertyWidget<?> createWidget4Property(Composite composite, Object property) {
        return this.createWidget4Property(composite, property, true);
    }

    public ASPropertyWidget<?> createWidget4Property(Composite composite, Object property, boolean showLabel) {
        return this.createWidget4Property(this.getElement(), composite, property, showLabel);
    }

    public ASPropertyWidget<?> createWidget(Composite composite, Object property, boolean showLabel, IPropertyDescriptor pd) {
        CLabel label = this.createLabel(composite, showLabel, pd);
        ASPropertyWidget<?> widget = SPWidgetFactory.createWidget(composite, this, pd);
        if (widget != null) {
            widget.setLabel(label);
            this.widgets.put(pd.getId(), widget);
            return widget;
        }
        return null;
    }

    public ASPropertyWidget<?> createWidget4Property(APropertyNode element, Composite composite, Object property, boolean showLabel) {
        if (element != null) {
            IPropertyDescriptor[] pds;
            IPropertyDescriptor[] iPropertyDescriptorArray = pds = element.getPropertyDescriptors();
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor pd = iPropertyDescriptorArray[n2];
                if (pd.getId().equals(property)) {
                    CLabel label = this.createLabel(composite, showLabel, pd);
                    ASPropertyWidget<?> widget = SPWidgetFactory.createWidget(composite, this, pd);
                    if (widget == null) break;
                    widget.setLabel(label);
                    this.widgets.put(pd.getId(), widget);
                    return widget;
                }
                ++n2;
            }
        }
        return null;
    }

    public void resetErrors() {
        for (ASPropertyWidget<?> w : this.widgets.values()) {
            w.resetErrors();
        }
    }

    public void showErrors(List<ValidationError> errors) {
        for (ValidationError ve : errors) {
            List ids = ve.getProps();
            for (String id : ids) {
                ASPropertyWidget<?> w = this.widgets.get(id);
                if (w == null) continue;
                w.showErrors(ve.getMessage(), ve.isWarning());
            }
        }
    }

    private CLabel createLabel(Composite composite, boolean showLabel, IPropertyDescriptor pd) {
        CLabel label = null;
        if (showLabel) {
            label = this.getWidgetFactory().createCLabel(composite, pd.getDisplayName(), 0);
            label.setToolTipText(pd.getDescription());
        }
        return label;
    }

    public IPropertyDescriptor getPropertyDesriptor(Object property) {
        if (this.getElement() != null) {
            IPropertyDescriptor[] pds;
            IPropertyDescriptor[] iPropertyDescriptorArray = pds = this.getElement().getPropertyDescriptors();
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor pd = iPropertyDescriptorArray[n2];
                if (pd.getId().equals(property)) {
                    return pd;
                }
                ++n2;
            }
        }
        return null;
    }

    public APropertyNode getSelectedElement() {
        return this.element;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.setInputC(part, selection);
    }

    protected void setInputC(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.element = null;
            this.elements = new ArrayList<APropertyNode>();
            List selected = ((IStructuredSelection)selection).toList();
            for (Object item : selected) {
                APropertyNode model;
                if (!(item instanceof EditPart) || (model = this.getModelFromEditPart(item)) == null) continue;
                this.jasperReportsContext = model.getJasperConfiguration();
                if (this.element == null) {
                    EditorContributor provider = (EditorContributor)part.getAdapter(EditorContributor.class);
                    if (provider != null) {
                        this.setEditDomain(provider.getEditDomain());
                    }
                    if (this.getElement() != model) {
                        if (this.getElement() != null) {
                            this.getElement().getPropertyChangeSupport().removePropertyChangeListener(this);
                        }
                        this.setElement(model);
                        this.getElement().getPropertyChangeSupport().removePropertyChangeListener(this);
                        this.getElement().getPropertyChangeSupport().addPropertyChangeListener(this);
                    }
                }
                this.elements.add(model);
            }
        }
    }

    protected APropertyNode getModelFromEditPart(Object item) {
        Object model = ((EditPart)item).getModel();
        if (model instanceof APropertyNode) {
            return (APropertyNode)model;
        }
        return null;
    }

    public void setElement(APropertyNode element) {
        this.element = element;
        if (element != null && element.getJasperConfiguration() != null) {
            this.jasperReportsContext = element.getJasperConfiguration();
        }
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public void setEditDomain(EditDomain editDomain) {
        this.editDomain = editDomain;
    }

    public void aboutToBeShown() {
        if (this.getElement() != null) {
            this.getElement().getPropertyChangeSupport().removePropertyChangeListener(this);
            this.getElement().getPropertyChangeSupport().addPropertyChangeListener(this);
        }
    }

    public void aboutToBeHidden() {
        if (this.getElement() != null) {
            this.getElement().getPropertyChangeSupport().removePropertyChangeListener(this);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.parent = parent;
    }

    public boolean isDisposed() {
        if (this.parent != null) {
            return this.parent.isDisposed();
        }
        return true;
    }

    public void dispose() {
        if (this.getElement() != null) {
            this.getElement().getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        super.dispose();
    }

    public APropertyNode getElement() {
        return this.element;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isDisposed()) {
            String n = evt.getPropertyName();
            this.setRefreshing(true);
            APropertyNode el = this.getElement();
            if (el != null) {
                el.getPropertyDescriptors();
                for (Object key : this.widgets.keySet()) {
                    if (!n.equals(key)) continue;
                    this.widgets.get(key).setData(el, el.getPropertyValue(key));
                }
            }
            UIUtils.getDisplay().syncExec(() -> this.getTabbedPropertySheetPage().showErrors());
            this.setRefreshing(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRefreshing() {
        AbstractSection abstractSection = this;
        synchronized (abstractSection) {
            return this.isRefreshing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshing(boolean value) {
        AbstractSection abstractSection = this;
        synchronized (abstractSection) {
            this.isRefreshing = value;
        }
    }

    public boolean changeProperty(Object property, Object newValue) {
        return this.changeProperty(property, newValue, null);
    }

    protected JSSCompoundCommand getCompoundCommand(String name, ANode node) {
        return new JSSCompoundCommand(name, node);
    }

    public boolean changeProperty(Object property, Object newValue, List<Command> commands) {
        if (!this.isRefreshing() && this.elements != null && !this.elements.isEmpty() && this.getEditDomain() != null) {
            CommandStack cs = this.getEditDomain().getCommandStack();
            JSSCompoundCommand cc = this.getCompoundCommand("Set " + property, null);
            for (APropertyNode n : this.elements) {
                Command c;
                cc.setReferenceNodeIfNull(n);
                if (!this.isChanged(property, newValue, n) || (c = this.getChangePropertyCommand(property, newValue, n)) == null) continue;
                cc.add(c);
            }
            if (!cc.getCommands().isEmpty()) {
                if (commands != null) {
                    for (Command c : commands) {
                        cc.add(c);
                    }
                }
                cs.execute((Command)cc);
                this.getTabbedPropertySheetPage().showErrors();
                return true;
            }
        }
        return false;
    }

    public boolean runCommand(JSSCompoundCommand cc) {
        if (!this.isRefreshing() && this.getEditDomain() != null) {
            CommandStack cs = this.getEditDomain().getCommandStack();
            if (!cc.getCommands().isEmpty()) {
                cs.execute((Command)cc);
                this.getTabbedPropertySheetPage().showErrors();
                return true;
            }
        }
        return false;
    }

    public boolean changePropertyOn(Object property, Object newValue, List<APropertyNode> nodes, List<Command> commands) {
        if (!this.isRefreshing() && nodes != null && !nodes.isEmpty() && this.getEditDomain() != null) {
            CommandStack cs = this.getEditDomain().getCommandStack();
            JSSCompoundCommand cc = this.getCompoundCommand("Set " + property, null);
            for (APropertyNode n : nodes) {
                Command c;
                cc.setReferenceNodeIfNull(n);
                if (!this.isChanged(property, newValue, n) || (c = this.getChangePropertyCommand(property, newValue, n)) == null) continue;
                cc.add(c);
            }
            if (!cc.getCommands().isEmpty()) {
                if (commands != null) {
                    for (Command c : commands) {
                        cc.add(c);
                    }
                }
                cs.execute((Command)cc);
                this.getTabbedPropertySheetPage().showErrors();
                return true;
            }
        }
        return false;
    }

    public void changePropertyOn(Object property, Object newValue, APropertyNode n) {
        this.changePropertyOn(property, newValue, n, null);
    }

    public void changePropertyOn(Object property, Object newValue, APropertyNode n, List<Command> commands) {
        if (!this.isRefreshing() && this.elements != null && !this.elements.isEmpty() && this.getEditDomain() != null) {
            CommandStack cs = this.getEditDomain().getCommandStack();
            if (this.isChanged(property, newValue, n)) {
                JSSCompoundCommand cc = this.getCompoundCommand("Set " + property, n);
                Command c = this.getChangePropertyCommand(property, newValue, n);
                if (c != null) {
                    cc.add(c);
                }
                if (!cc.getCommands().isEmpty()) {
                    if (commands != null) {
                        for (Command c1 : commands) {
                            cc.add(c1);
                        }
                    }
                    cs.execute((Command)cc);
                    this.getTabbedPropertySheetPage().showErrors();
                }
            }
        }
    }

    protected boolean isChanged(Object property, Object newValue, APropertyNode n) {
        Object oldValue = n.getPropertyValue(property);
        if (oldValue == null && newValue == null) {
            return false;
        }
        return oldValue == null || newValue == null || !oldValue.equals(newValue) || this.getEditDomain() == null;
    }

    public Command getChangePropertyCommand(Object property, Object newValue, APropertyNode n) {
        if (this.isChanged(property, newValue, n)) {
            ISetValueCommandProvider provider = (ISetValueCommandProvider)n.getAdapter(ISetValueCommandProvider.class);
            if (provider != null) {
                return provider.getSetValueCommand(n, n.getDisplayText(), property, newValue);
            }
            SetValueCommand setCommand = new SetValueCommand(n.getDisplayText());
            setCommand.setTarget(n);
            setCommand.setPropertyId(property);
            setCommand.setPropertyValue(newValue);
            return setCommand;
        }
        return null;
    }

    public List<APropertyNode> getElements() {
        return this.elements;
    }

    public void setElements(List<APropertyNode> elements) {
        this.elements = elements;
    }

    public static Composite createNewRow(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setBackground(parent.getBackground());
        RowLayout rl = new RowLayout();
        rl.fill = true;
        rl.wrap = true;
        cmp.setLayout((Layout)rl);
        return cmp;
    }

    public static CLabel createLabel(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, String txt, int width) {
        CLabel lbl = widgetFactory.createCLabel(parent, txt, 131072);
        if (parent.getLayout() instanceof RowLayout) {
            RowData rd = new RowData();
            rd.width = width;
            lbl.setLayoutData((Object)rd);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(130);
            if (width > 0) {
                gd.minimumWidth = width;
            }
            lbl.setLayoutData((Object)gd);
        }
        return lbl;
    }

    protected void initializeProvidedProperties() {
        this.providedProperties = new HashMap();
    }

    public List<Object> getHandledProperties() {
        if (this.providedProperties == null) {
            this.initializeProvidedProperties();
        }
        return new ArrayList<Object>(this.providedProperties.keySet());
    }

    public WidgetDescriptor getPropertyInfo(Object propertyId) {
        if (this.providedProperties == null) {
            this.initializeProvidedProperties();
        }
        return this.providedProperties.get(propertyId);
    }

    protected void addProvidedProperties(Object id, String propertyName) {
        this.providedProperties.put(id, new WidgetDescriptor(propertyName));
    }

    public void expandForProperty(Object propertyId) {
    }

    public IHighlightPropertyWidget getWidgetForProperty(Object propertyId) {
        return this.widgets.get(propertyId);
    }

    public JasperReportsConfiguration getJasperReportsContext() {
        return this.jasperReportsContext;
    }
}

