/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.graphic;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElementLineBox;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.properties.internal.IHighlightPropertyWidget;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.graphic.ASHighlightControl;
import com.jaspersoft.studio.property.section.widgets.BackgroundHighlight;
import com.jaspersoft.studio.utils.UIUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class PaddingSection
extends AbstractSection {
    private Spinner bottomPadding;
    private Spinner topPadding;
    private Spinner leftPadding;
    private Spinner rightPadding;
    private Spinner allPadding;

    @Override
    protected APropertyNode getModelFromEditPart(Object item) {
        APropertyNode model = super.getModelFromEditPart(item);
        if (model != null && model instanceof MGraphicElementLineBox || model instanceof MStyle) {
            model = (APropertyNode)model.getPropertyValue("LineBox");
        }
        return model;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout(14, false);
        composite.setLayout((Layout)layout);
        CLabel label = this.getWidgetFactory().createCLabel(composite, String.valueOf(Messages.common_padding) + ":", 131072);
        GridData gd = new GridData();
        gd.widthHint = 100;
        label.setLayoutData((Object)gd);
        CLabel l = new CLabel(composite, 131072);
        l.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/border_frame.gif"));
        l.setBackground(composite.getDisplay().getSystemColor(1));
        this.allPadding = new Spinner(composite, 2048);
        this.allPadding.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.allPadding.setToolTipText(Messages.PaddingSection_all_padding_tool_tip);
        this.allPadding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaddingSection.this.changeProperty("padding", new Integer(PaddingSection.this.allPadding.getSelection()));
            }
        });
        l = new CLabel(composite, 131072);
        l.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/border_top.gif"));
        l.setBackground(composite.getDisplay().getSystemColor(1));
        this.topPadding = new Spinner(composite, 2048);
        this.topPadding.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.topPadding.setToolTipText(Messages.PaddingSection_top_padding_tool_tip);
        this.topPadding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaddingSection.this.changeProperty("topPadding", new Integer(PaddingSection.this.topPadding.getSelection()));
            }
        });
        l = new CLabel(composite, 131072);
        l.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/border_bottom.png"));
        l.setBackground(composite.getDisplay().getSystemColor(1));
        this.bottomPadding = new Spinner(composite, 2048);
        this.bottomPadding.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.bottomPadding.setToolTipText(Messages.PaddingSection_bottom_padding_tool_tip);
        this.bottomPadding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaddingSection.this.changeProperty("bottomPadding", new Integer(PaddingSection.this.bottomPadding.getSelection()));
            }
        });
        l = new CLabel(composite, 131072);
        l.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/border_left.gif"));
        l.setBackground(composite.getDisplay().getSystemColor(1));
        this.leftPadding = new Spinner(composite, 2048);
        this.leftPadding.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.leftPadding.setToolTipText(Messages.PaddingSection_left_padding_tool_tip);
        this.leftPadding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaddingSection.this.changeProperty("leftPadding", new Integer(PaddingSection.this.leftPadding.getSelection()));
            }
        });
        l = new CLabel(composite, 131072);
        l.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/border_right.gif"));
        l.setBackground(composite.getDisplay().getSystemColor(1));
        this.rightPadding = new Spinner(composite, 2048);
        this.rightPadding.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.rightPadding.setToolTipText(Messages.PaddingSection_right_padding_tool_tip);
        this.rightPadding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaddingSection.this.changeProperty("rightPadding", new Integer(PaddingSection.this.rightPadding.getSelection()));
            }
        });
    }

    @Override
    public IHighlightPropertyWidget getWidgetForProperty(Object propertyId) {
        if (propertyId.equals("padding")) {
            return new ASHighlightControl((Control)this.allPadding, new BackgroundHighlight((Control)this.allPadding));
        }
        if (propertyId.equals("leftPadding")) {
            return new ASHighlightControl((Control)this.leftPadding, new BackgroundHighlight((Control)this.leftPadding));
        }
        if (propertyId.equals("rightPadding")) {
            return new ASHighlightControl((Control)this.rightPadding, new BackgroundHighlight((Control)this.rightPadding));
        }
        if (propertyId.equals("topPadding")) {
            return new ASHighlightControl((Control)this.topPadding, new BackgroundHighlight((Control)this.topPadding));
        }
        return new ASHighlightControl((Control)this.bottomPadding, new BackgroundHighlight((Control)this.bottomPadding));
    }

    @Override
    protected void initializeProvidedProperties() {
        super.initializeProvidedProperties();
        this.addProvidedProperties("padding", Messages.BordersSection_Padding_Box_Title);
        this.addProvidedProperties("bottomPadding", Messages.common_bottom);
        this.addProvidedProperties("topPadding", Messages.BordersSection_Top_Label);
        this.addProvidedProperties("leftPadding", Messages.BordersSection_Left_Label);
        this.addProvidedProperties("rightPadding", Messages.common_right);
    }

    @Override
    public void refresh() {
        this.setRefreshing(true);
        APropertyNode element = this.getElement();
        if (element != null) {
            UIUtil.setSpinnerSelection(this.allPadding, element.getPropertyValue("padding"), 0);
            UIUtil.setSpinnerSelection(this.bottomPadding, element.getPropertyValue("bottomPadding"), 0);
            UIUtil.setSpinnerSelection(this.topPadding, element.getPropertyValue("topPadding"), 0);
            UIUtil.setSpinnerSelection(this.leftPadding, element.getPropertyValue("leftPadding"), 0);
            UIUtil.setSpinnerSelection(this.rightPadding, element.getPropertyValue("rightPadding"), 0);
        }
        this.setRefreshing(false);
    }

    @Override
    public boolean isDisposed() {
        return this.allPadding.isDisposed();
    }
}

