/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.report;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetWidgetFactory;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.section.report.PageFormatWidget;
import com.jaspersoft.studio.property.section.report.util.PHolderUtil;
import com.jaspersoft.studio.property.section.report.util.PageSize;
import com.jaspersoft.studio.property.section.report.util.UnitsWidget;
import com.jaspersoft.studio.property.section.report.util.ValueUnitsWidget;
import com.jaspersoft.studio.swt.widgets.NullableSpinner;
import com.jaspersoft.studio.swt.widgets.NumericText;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;

public final class PageFormatDialog
extends FormDialog {
    private List<ValueUnitsWidget> uvWidgets = new ArrayList<ValueUnitsWidget>();
    private ValueUnitsWidget pheigh;
    private ValueUnitsWidget pwidth;
    private ValueUnitsWidget tmargin;
    private ValueUnitsWidget bmargin;
    private ValueUnitsWidget lmargin;
    private ValueUnitsWidget rmargin;
    private ValueUnitsWidget cwidth;
    private ValueUnitsWidget space;
    private Button portrait;
    private Button landscape;
    private NullableSpinner cols;
    private Combo pformat;
    private JSSCompoundCommand command;
    private PageFormatWidget pageFormatWidget;
    private UnitsWidget uw;
    private TabbedPropertySheetWidgetFactory toolkit;
    private JasperDesign jd;
    private JasperReportsConfiguration jConfig;
    private MReport jnode;
    private Combo cPrintOrder;
    private Combo cColumnDirection;
    private Composite tleft;

    public PageFormatDialog(Shell shell, ANode node) {
        super(shell);
        this.jConfig = node.getJasperConfiguration();
        this.jnode = (MReport)node.getRoot();
        this.jd = node.getJasperDesign();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PageFormatDialog_0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, ContextHelpIDs.WIZARD_FORMAT_PAGE);
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(Messages.PageFormatDialog_1);
        this.toolkit = new TabbedPropertySheetWidgetFactory();
        Composite composite = mform.getForm().getBody();
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setBackgroundMode(2);
        UIUtils.getDisplay().asyncExec(() -> {
            composite.setBackground(this.tleft.getBackground());
            composite.getParent().update();
            composite.getParent().layout(true);
        });
        this.createPageSize(composite);
        this.createThumbnail(composite);
        this.createOrientation(composite);
        this.createMargins(composite);
        this.createColumns(composite);
        this.setJasperDesign(this.jd);
        this.setTBounds();
    }

    private void createColumns(Composite composite) {
        Group bright = this.toolkit.createGroup(composite, Messages.PageFormatDialog_2);
        bright.setLayoutData((Object)new GridData(1808));
        bright.setBackgroundMode(2);
        bright.setLayout((Layout)new GridLayout(3, false));
        new Label((Composite)bright, 0).setText(Messages.PageFormatDialog_3);
        this.cols = new NullableSpinner((Composite)bright, 2048, 0, 0);
        this.cols.setNullable(false);
        this.cols.setMinimum(1.0);
        this.cols.setMaximum(2.147483647E9);
        this.cols.setValue(1);
        this.cols.setToolTipText(Messages.PageFormatDialog_4);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.cols.setLayoutData(gd);
        this.cwidth = new ValueUnitsWidget();
        this.cwidth.createComponent((Composite)bright, Messages.PageFormatDialog_5, Messages.PageFormatDialog_6);
        this.space = new ValueUnitsWidget();
        this.space.createComponent((Composite)bright, Messages.PageFormatDialog_7, Messages.PageFormatDialog_8);
        this.uvWidgets.add(this.cwidth);
        this.uvWidgets.add(this.space);
        SelectionAdapter spaceListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageFormatDialog.this.cols.setMaximum(PageFormatDialog.this.getMaxColumnsNumber(false));
                NumericText textControl = (NumericText)e.widget;
                Point currentSelection = textControl.getSelection();
                PageFormatDialog.this.recalcColumns();
                PageFormatDialog.this.setTBounds();
                textControl.setFocus();
                textControl.setSelection(currentSelection.x, currentSelection.y);
            }
        };
        SelectionAdapter colsListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NumericText textControl = (NumericText)e.widget;
                Point currentSelection = textControl.getSelection();
                PageFormatDialog.this.recalcColumns();
                PageFormatDialog.this.setTBounds();
                textControl.setFocus();
                textControl.setSelection(currentSelection.x, currentSelection.y);
                PageFormatDialog.this.enablePrintOrderAndColumnDirection();
            }
        };
        this.cols.addSelectionListener((SelectionListener)colsListener);
        this.cwidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageFormatDialog.this.cols.setMaximum(PageFormatDialog.this.getMaxColumnsNumber(true));
                PageFormatDialog.this.setTBounds();
            }
        });
        this.space.addSelectionListener((SelectionListener)spaceListener);
        new Label((Composite)bright, 0).setText(Messages.MReport_print_order);
        this.cPrintOrder = new Combo((Composite)bright, 2056);
        String[] printOrderItems = NamedEnumPropertyDescriptor.getEnumItems((NamedEnum[])PrintOrderEnum.HORIZONTAL.getDeclaringClass().getEnumConstants(), NullEnum.NOTNULL);
        this.cPrintOrder.setItems(printOrderItems);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.cPrintOrder.setLayoutData((Object)gd);
        this.cPrintOrder.setToolTipText(Messages.PageFormatDialog_PrintOrderTooltip);
        new Label((Composite)bright, 0).setText(Messages.PageFormatDialog_ColumnDirectionLabel);
        this.cColumnDirection = new Combo((Composite)bright, 2056);
        String[] columnDirectionItems = NamedEnumPropertyDescriptor.getEnumItems((NamedEnum[])RunDirectionEnum.LTR.getDeclaringClass().getEnumConstants(), NullEnum.NOTNULL);
        this.cColumnDirection.setItems(columnDirectionItems);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.cColumnDirection.setLayoutData((Object)gd);
        this.cColumnDirection.setToolTipText(Messages.PageFormatDialog_ColumnDirectionTooltip);
        this.enablePrintOrderAndColumnDirection();
    }

    private void recalcColumns() {
        int maxspace;
        int pagespace = this.pwidth.getValue() - this.lmargin.getValue() - this.rmargin.getValue();
        int nrcolspace = this.cols.getValueAsInteger() - 1;
        int colspace = nrcolspace * this.space.getValue();
        int mspace = Math.max(0, nrcolspace > 0 ? colspace / nrcolspace : pagespace);
        if (mspace > (maxspace = Math.max(0, nrcolspace > 0 ? pagespace / nrcolspace : pagespace))) {
            mspace = maxspace;
        }
        if (mspace < this.space.getValue()) {
            this.space.setValue(mspace);
        }
        this.space.setMaxPixels(maxspace);
        int cw = this.getMaxColumnsWidth();
        this.setWdithMaximum();
        this.cwidth.setValue(cw);
        this.tmargin.setMaxPixels(this.pheigh.getValue() - this.bmargin.getValue());
        this.bmargin.setMaxPixels(this.pheigh.getValue() - this.tmargin.getValue());
        this.lmargin.setMaxPixels(this.pwidth.getValue() - this.rmargin.getValue());
        this.rmargin.setMaxPixels(this.pwidth.getValue() - this.lmargin.getValue());
    }

    private void createMargins(Composite composite) {
        Group bleft = this.toolkit.createGroup(composite, Messages.PageFormatDialog_9);
        bleft.setLayoutData((Object)new GridData(1808));
        bleft.setLayout((Layout)new GridLayout(3, false));
        bleft.setBackgroundMode(2);
        this.tmargin = new ValueUnitsWidget();
        this.tmargin.createComponent((Composite)bleft, Messages.PageFormatDialog_10, Messages.PageFormatDialog_11);
        this.bmargin = new ValueUnitsWidget();
        this.bmargin.createComponent((Composite)bleft, Messages.PageFormatDialog_12, Messages.PageFormatDialog_13);
        this.lmargin = new ValueUnitsWidget();
        this.lmargin.createComponent((Composite)bleft, Messages.PageFormatDialog_14, Messages.PageFormatDialog_15);
        this.rmargin = new ValueUnitsWidget();
        this.rmargin.createComponent((Composite)bleft, Messages.PageFormatDialog_16, Messages.PageFormatDialog_17);
        this.uvWidgets.add(this.tmargin);
        this.uvWidgets.add(this.bmargin);
        this.uvWidgets.add(this.lmargin);
        this.uvWidgets.add(this.rmargin);
        SelectionAdapter mlistner = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageFormatDialog.this.setWdithMaximum();
                PageFormatDialog.this.cols.setMaximum(PageFormatDialog.this.getMaxColumnsNumber(false));
                NumericText textControl = (NumericText)e.widget;
                Point currentSelection = textControl.getSelection();
                PageFormatDialog.this.recalcColumns();
                PageFormatDialog.this.setTBounds();
                textControl.setFocus();
                textControl.setSelection(currentSelection.x, currentSelection.y);
            }
        };
        this.tmargin.addSelectionListener((SelectionListener)mlistner);
        this.bmargin.addSelectionListener((SelectionListener)mlistner);
        this.lmargin.addSelectionListener((SelectionListener)mlistner);
        this.rmargin.addSelectionListener((SelectionListener)mlistner);
    }

    private void createOrientation(Composite composite) {
        Group mleft = this.toolkit.createGroup(composite, Messages.PageFormatDialog_18);
        mleft.setLayoutData((Object)new GridData(1808));
        mleft.setLayout((Layout)new GridLayout(2, false));
        this.portrait = this.toolkit.createButton((Composite)mleft, Messages.PageFormatDialog_19, 16);
        this.landscape = this.toolkit.createButton((Composite)mleft, Messages.PageFormatDialog_20, 16);
        this.portrait.setSelection(true);
        SelectionListener orientationlistner = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int h;
                int w = PageFormatDialog.this.pwidth.getValue();
                if (w > (h = PageFormatDialog.this.pheigh.getValue()) && PageFormatDialog.this.portrait.getSelection() || h > w && !PageFormatDialog.this.portrait.getSelection()) {
                    PageFormatDialog.this.pwidth.setValue(h);
                    PageFormatDialog.this.pheigh.setValue(w);
                    PageFormatDialog.this.setTBounds();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        UIUtils.getDisplay().asyncExec(() -> {
            this.portrait.setBackground(mleft.getBackground());
            this.landscape.setBackground(mleft.getBackground());
            composite.getParent().update();
            composite.getParent().layout(true);
        });
        this.portrait.addSelectionListener(orientationlistner);
    }

    private void createThumbnail(Composite composite) {
        this.pageFormatWidget = new PageFormatWidget(composite, 0);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.pageFormatWidget.setLayoutData(gd);
    }

    private void setTBounds() {
        this.pageFormatWidget.setCols(this.cols.getValueAsInteger());
        this.pageFormatWidget.setTmargin(this.tmargin.getValue());
        this.pageFormatWidget.setBmargin(this.bmargin.getValue());
        this.pageFormatWidget.setLmargin(this.lmargin.getValue());
        this.pageFormatWidget.setRmargin(this.rmargin.getValue());
        this.pageFormatWidget.setPheight(this.pheigh.getValue());
        this.pageFormatWidget.setPwidth(this.pwidth.getValue());
        this.pageFormatWidget.setSpace(this.space.getValue());
        this.pageFormatWidget.setCwidth(this.cwidth.getValue());
        this.pageFormatWidget.setTBounds();
    }

    private void createPageSize(Composite composite) {
        this.tleft = this.toolkit.createComposite(composite);
        this.tleft.setLayout((Layout)new GridLayout(3, false));
        this.tleft.setLayoutData((Object)new GridData(1808));
        this.toolkit.createLabel(this.tleft, Messages.PageFormatDialog_21);
        this.pformat = this.toolkit.createCombo(this.tleft, 2060);
        this.pformat.setItems(PageSize.getFormats());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.pformat.setLayoutData((Object)gd);
        this.pwidth = new ValueUnitsWidget();
        this.pwidth.createComponent(this.tleft, Messages.PageFormatDialog_22, Messages.PageFormatDialog_23);
        this.pwidth.setMaxPixels(0x3FFFFFFF);
        this.pheigh = new ValueUnitsWidget();
        this.pheigh.createComponent(this.tleft, Messages.PageFormatDialog_24, Messages.PageFormatDialog_25);
        this.pheigh.setMaxPixels(0x3FFFFFFF);
        this.uvWidgets.add(this.pwidth);
        this.uvWidgets.add(this.pheigh);
        this.uw = new UnitsWidget();
        this.uw.createComponent(this.tleft, Messages.PageFormatDialog_26, Messages.PageFormatDialog_27, 2);
        this.uw.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PageFormatDialog.this.recalcColumns();
                PageFormatDialog.this.setAllUnits();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        SelectionAdapter psizeMListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageFormatDialog.this.setWdithMaximum();
                PageFormatDialog.this.cols.setMaximum(PageFormatDialog.this.getMaxColumnsNumber(false));
                NumericText textControl = (NumericText)e.widget;
                Point currentSelection = textControl.getSelection();
                String format = PageSize.deductPageFormat(PageFormatDialog.this.pwidth.getValue(), PageFormatDialog.this.pheigh.getValue());
                PageFormatDialog.this.pformat.select(PageSize.getFormatIndx(format));
                PageFormatDialog.this.recalcColumns();
                PageFormatDialog.this.setTBounds();
                textControl.setFocus();
                textControl.setSelection(currentSelection.x, currentSelection.y);
            }
        };
        this.pwidth.addSelectionListener((SelectionListener)psizeMListener);
        this.pheigh.addSelectionListener((SelectionListener)psizeMListener);
        this.pformat.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Point p = PageSize.getFormatSize(PageSize.getFormats()[PageFormatDialog.this.pformat.getSelectionIndex()]);
                if (PageFormatDialog.this.portrait.getSelection()) {
                    PageFormatDialog.this.pwidth.setValue(p.x);
                    PageFormatDialog.this.pheigh.setValue(p.y);
                } else {
                    PageFormatDialog.this.pwidth.setValue(p.y);
                    PageFormatDialog.this.pheigh.setValue(p.x);
                }
                PageFormatDialog.this.recalcColumns();
                PageFormatDialog.this.setTBounds();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void setAllUnits() {
        String unit = this.uw.getUnit();
        for (ValueUnitsWidget vuw : this.uvWidgets) {
            vuw.setUnit(unit);
        }
    }

    private void setJasperDesign(JasperDesign jd) {
        this.pheigh.setValue(jd.getPageHeight());
        this.pwidth.setValue(jd.getPageWidth());
        String format = PageSize.deductPageFormat(jd.getPageWidth(), jd.getPageHeight());
        this.pformat.select(PageSize.getFormatIndx(format));
        this.tmargin.setValue(jd.getTopMargin());
        this.bmargin.setValue(jd.getBottomMargin());
        this.lmargin.setValue(jd.getLeftMargin());
        this.rmargin.setValue(jd.getRightMargin());
        this.cwidth.setValue(jd.getColumnWidth());
        this.setWdithMaximum();
        this.space.setValue(jd.getColumnSpacing());
        this.cols.setValue(jd.getColumnCount());
        this.cols.setMaximum(this.getMaxColumnsNumber(false));
        this.landscape.setSelection(false);
        this.portrait.setSelection(false);
        if (jd.getOrientationValue().equals((Object)OrientationEnum.LANDSCAPE)) {
            this.landscape.setSelection(true);
        } else if (jd.getOrientationValue().equals((Object)OrientationEnum.PORTRAIT)) {
            this.portrait.setSelection(true);
        }
        String defunit = MReport.getMeasureUnit(this.jConfig, jd);
        this.uw.setUnit(defunit);
        this.pheigh.setUnit(PHolderUtil.getUnit((JRPropertiesHolder)jd, "pageHeight", defunit));
        this.pwidth.setUnit(PHolderUtil.getUnit((JRPropertiesHolder)jd, "pageWidth", defunit));
        this.tmargin.setUnit(PHolderUtil.getUnit((JRPropertiesHolder)jd, "topMargin", defunit));
        this.bmargin.setUnit(PHolderUtil.getUnit((JRPropertiesHolder)jd, "bottomMargin", defunit));
        this.lmargin.setUnit(PHolderUtil.getUnit((JRPropertiesHolder)jd, "leftMargin", defunit));
        this.rmargin.setUnit(PHolderUtil.getUnit((JRPropertiesHolder)jd, "rightMargin", defunit));
        this.cwidth.setUnit(PHolderUtil.getUnit((JRPropertiesHolder)jd, "columnWidth", defunit));
        this.space.setUnit(PHolderUtil.getUnit((JRPropertiesHolder)jd, "columnSpacing", defunit));
        PrintOrderEnum currPrintOrderValue = jd.getPrintOrderValue();
        if (PrintOrderEnum.HORIZONTAL.equals((Object)currPrintOrderValue)) {
            this.cPrintOrder.select(1);
        } else {
            this.cPrintOrder.select(0);
        }
        RunDirectionEnum currColDirection = jd.getColumnDirection();
        if (RunDirectionEnum.RTL.equals((Object)currColDirection)) {
            this.cColumnDirection.select(1);
        } else {
            this.cColumnDirection.select(0);
        }
        this.enablePrintOrderAndColumnDirection();
    }

    protected void setWdithMaximum() {
        this.cwidth.setMaxPixels(Math.max(0, this.pwidth.getValue() - this.lmargin.getValue() - this.rmargin.getValue()));
    }

    public boolean close() {
        this.createCommand();
        return super.close();
    }

    public JSSCompoundCommand getCommand() {
        return this.command;
    }

    protected int getMaxColumnsNumber(boolean realColWidth) {
        int colWidth = realColWidth ? this.cwidth.getValue() : 1;
        float value = (this.pwidth.getValue() - this.lmargin.getValue() - this.rmargin.getValue()) / Math.max(colWidth + this.space.getValue(), 1);
        return (int)Math.floor(value);
    }

    protected int getMaxColumnsWidth() {
        int colNumber = Math.max(this.cols.getValueAsInteger(), 1);
        float value = (this.pwidth.getValue() - this.lmargin.getValue() - this.rmargin.getValue() - this.space.getValue() * (colNumber - 1)) / colNumber;
        return (int)Math.floor(value);
    }

    public void createCommand() {
        this.command = new JSSCompoundCommand(this.jnode);
        if (this.jd.getPageHeight() != this.pheigh.getValue()) {
            this.command.add(this.createCommand("pageHeight", this.pheigh.getValue()));
        }
        if (this.jd.getPageWidth() != this.pwidth.getValue()) {
            this.command.add(this.createCommand("pageWidth", this.pwidth.getValue()));
        }
        if (this.jd.getTopMargin() != this.tmargin.getValue()) {
            this.command.add(this.createCommand("topMargin", this.tmargin.getValue()));
        }
        if (this.jd.getBottomMargin() != this.bmargin.getValue()) {
            this.command.add(this.createCommand("bottomMargin", this.bmargin.getValue()));
        }
        if (this.jd.getLeftMargin() != this.lmargin.getValue()) {
            this.command.add(this.createCommand("leftMargin", this.lmargin.getValue()));
        }
        if (this.jd.getRightMargin() != this.rmargin.getValue()) {
            this.command.add(this.createCommand("rightMargin", this.rmargin.getValue()));
        }
        if (this.jd.getColumnCount() != this.cols.getValueAsInteger().intValue()) {
            this.command.add(this.createCommand("columnCount", this.cols.getValueAsInteger()));
        }
        if (this.jd.getColumnWidth() != this.cwidth.getValue()) {
            this.command.add(this.createCommand("columnWidth", this.cwidth.getValue()));
        }
        if (this.jd.getColumnSpacing() != this.space.getValue()) {
            this.command.add(this.createCommand("columnSpacing", this.space.getValue()));
        }
        if (this.jd.getPrintOrderValue() != PrintOrderEnum.getByName((String)this.cPrintOrder.getText())) {
            this.command.add(this.createCommand("printOrder", NamedEnumPropertyDescriptor.getIntValue(PrintOrderEnum.HORIZONTAL, NullEnum.NULL, PrintOrderEnum.getByName((String)this.cPrintOrder.getText()))));
        }
        RunDirectionEnum selectedColDirection = NamedEnumPropertyDescriptor.getEnumValue(RunDirectionEnum.LTR, NullEnum.NOTNULL, Math.max(this.cColumnDirection.getSelectionIndex(), 0));
        if (this.jd.getColumnDirection() != selectedColDirection) {
            this.command.add(this.createCommand("columnDirection", NamedEnumPropertyDescriptor.getIntValue(RunDirectionEnum.LTR, NullEnum.NOTNULL, selectedColDirection)));
        }
        if (this.jd.getOrientationValue().equals((Object)OrientationEnum.LANDSCAPE) && !this.landscape.getSelection()) {
            this.command.add(this.createCommand("orientation", OrientationEnum.PORTRAIT));
        } else if (this.jd.getOrientationValue().equals((Object)OrientationEnum.PORTRAIT) && !this.portrait.getSelection()) {
            this.command.add(this.createCommand("orientation", OrientationEnum.LANDSCAPE));
        }
        boolean changes = false;
        JRPropertiesMap pmap = this.jd.getPropertiesMap().cloneProperties();
        String defunit = this.uw.getUnit();
        changes = PHolderUtil.setProperty(changes, pmap, "", defunit, null);
        changes = PHolderUtil.setProperty(changes, pmap, "pageHeight", this.pheigh.getUnit(), defunit);
        changes = PHolderUtil.setProperty(changes, pmap, "pageWidth", this.pwidth.getUnit(), defunit);
        changes = PHolderUtil.setProperty(changes, pmap, "topMargin", this.tmargin.getUnit(), defunit);
        changes = PHolderUtil.setProperty(changes, pmap, "bottomMargin", this.bmargin.getUnit(), defunit);
        changes = PHolderUtil.setProperty(changes, pmap, "leftMargin", this.lmargin.getUnit(), defunit);
        changes = PHolderUtil.setProperty(changes, pmap, "rightMargin", this.rmargin.getUnit(), defunit);
        changes = PHolderUtil.setProperty(changes, pmap, "columnWidth", this.cwidth.getUnit(), defunit);
        changes = PHolderUtil.setProperty(changes, pmap, "columnSpacing", this.space.getUnit(), defunit);
        if (changes) {
            this.command.add(this.createCommand("PROPERTY_MAP", pmap));
        }
    }

    private Command createCommand(String property, Object value) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(this.jnode);
        cmd.setPropertyId(property);
        cmd.setPropertyValue(value);
        return cmd;
    }

    protected void enablePrintOrderAndColumnDirection() {
        int c = this.cols.getValueAsInteger();
        this.cPrintOrder.setEnabled(c >= 1);
        this.cColumnDirection.setEnabled(c >= 1);
    }
}

