/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.style.inerithance;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.style.inerithance.StylesListSection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractContextualMenu
extends SelectionAdapter {
    private Menu dropMenu = null;
    private List<MenuItem> items = null;
    protected StylesListSection parentSection = null;

    public AbstractContextualMenu(StylesListSection parentSection) {
        this.parentSection = parentSection;
    }

    public void widgetSelected(SelectionEvent e) {
        Control button = (Control)e.getSource();
        if (this.dropMenu == null) {
            this.dropMenu = new Menu(button);
            this.items = this.getItems(this.dropMenu);
        }
        if (this.dropMenu != null && !this.dropMenu.isDisposed()) {
            if (this.dropMenu.isVisible()) {
                this.dropMenu.setVisible(false);
            } else {
                this.locatePopupMenu(button);
                for (MenuItem item : this.items) {
                    String text = this.getItemText(item);
                    if (text == null) continue;
                    item.setText(text);
                }
                this.dropMenu.setVisible(true);
            }
        }
    }

    protected void locatePopupMenu(Control control) {
        Rectangle r = control.getBounds();
        r.y = 0;
        r.x = 0;
        Point loc = control.toDisplay(r.x, r.y);
        loc.y += r.height;
        this.dropMenu.setLocation(loc);
    }

    protected void createElementNullCommand(JSSCompoundCommand cCommand, APropertyNode element) {
        HashMap<String, Object> descriptors = element.getStylesDescriptors();
        for (String property : descriptors.keySet()) {
            if (property.equals("LineBox")) {
                this.createElementNullCommand(cCommand, (APropertyNode)element.getPropertyValue("LineBox"));
                continue;
            }
            if (property.equals("LinePen")) {
                this.createElementNullCommand(cCommand, (APropertyNode)element.getPropertyValue("LinePen"));
                continue;
            }
            if (property.equals("LinePen_BOTTOM")) {
                this.createElementNullCommand(cCommand, (APropertyNode)element.getPropertyValue("LinePen_BOTTOM"));
                continue;
            }
            if (property.equals("LinePen_LEFT")) {
                this.createElementNullCommand(cCommand, (APropertyNode)element.getPropertyValue("LinePen_LEFT"));
                continue;
            }
            if (property.equals("LinePen_RIGHT")) {
                this.createElementNullCommand(cCommand, (APropertyNode)element.getPropertyValue("LinePen_RIGHT"));
                continue;
            }
            if (property.equals("LinePen_TOP")) {
                this.createElementNullCommand(cCommand, (APropertyNode)element.getPropertyValue("LinePen_TOP"));
                continue;
            }
            if (property.equals("paragraph")) {
                this.createElementNullCommand(cCommand, (APropertyNode)element.getPropertyValue("paragraph"));
                continue;
            }
            Command c = this.parentSection.generateSetAttributeCommand(element, property);
            if (c == null) continue;
            cCommand.add(c);
        }
    }

    public void dispose() {
        if (this.dropMenu != null && !this.dropMenu.isDisposed()) {
            this.dropMenu.dispose();
        }
        this.dropMenu = null;
        this.items = null;
    }

    protected String getItemText(MenuItem item) {
        return null;
    }

    protected abstract List<MenuItem> getItems(Menu var1);
}

