/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.style.inerithance;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.style.inerithance.StylesListSection;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class ElementClickListener
extends MouseAdapter {
    private String property;
    private StylesListSection parentSection;

    public ElementClickListener(String property, StylesListSection parentSection) {
        this.property = property;
        this.parentSection = parentSection;
    }

    public static APropertyNode getRealElement(APropertyNode baseElement, String fullProperty) {
        String[] properties = fullProperty.split("\\.");
        APropertyNode element = baseElement;
        int i = 0;
        while (i < properties.length - 1) {
            element = (APropertyNode)element.getPropertyValue(properties[i]);
            ++i;
        }
        return element;
    }

    public void mouseUp(MouseEvent e) {
        List<APropertyNode> selectedElements = this.parentSection.getElements();
        JSSCompoundCommand cc = new JSSCompoundCommand("Set " + this.property, (ANode)selectedElements.get(0));
        for (APropertyNode targetElement : selectedElements) {
            Command c;
            String propertyName = this.property;
            int lastSegment = propertyName.lastIndexOf(".");
            if (lastSegment != -1) {
                propertyName = propertyName.substring(lastSegment + 1);
            }
            if ((c = this.parentSection.generateSetAttributeCommand(ElementClickListener.getRealElement(targetElement, this.property), propertyName)) == null) continue;
            cc.add(c);
        }
        if (!cc.getCommands().isEmpty()) {
            this.parentSection.executeAndRefresh((Command)cc);
        }
    }
}

