/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.DefaultWidgetsHighlighters;
import com.jaspersoft.studio.utils.ImageUtils;
import java.util.UUID;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class SPBooleanToggle
extends ASPropertyWidget<CheckBoxPropertyDescriptor> {
    private ToolItem cmb3Bool;
    private Composite parent;
    private String imageId = null;

    public SPBooleanToggle(Composite parent, AbstractSection section, CheckBoxPropertyDescriptor pDescriptor, Image image) {
        super(parent, section, pDescriptor);
        if (image != null) {
            this.cmb3Bool.setImage(image);
            this.imageId = UUID.randomUUID().toString();
            Image cachedImage = ResourceManager.getImage((String)this.imageId);
            if (cachedImage == null || cachedImage.isDisposed()) {
                ResourceManager.addImage((String)this.imageId, (Image)image);
            }
        }
    }

    @Override
    public Control getControl() {
        return this.parent;
    }

    @Override
    public Control getControlToBorder() {
        return this.parent;
    }

    protected PaintListener getPaintControlListener() {
        return DefaultWidgetsHighlighters.getWidgetForType(ToolItem.class);
    }

    @Override
    public void createComponent(Composite parent) {
        this.parent = parent;
        this.cmb3Bool = new ToolItem((ToolBar)parent, 32);
        this.cmb3Bool.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPBooleanToggle.this.section.changeProperty(((CheckBoxPropertyDescriptor)SPBooleanToggle.this.pDescriptor).getId(), new Boolean(SPBooleanToggle.this.cmb3Bool.getSelection()));
            }
        });
        this.cmb3Bool.setToolTipText(((CheckBoxPropertyDescriptor)this.pDescriptor).getDescription());
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        if (this.imageId != null) {
            if (elementValue == null) {
                Image originalImage;
                ImageData grayData;
                Image grayImage = ResourceManager.getImage((String)(String.valueOf(this.imageId) + "greyScale"));
                if (grayImage == null && (grayData = ImageUtils.createGrayImage(originalImage = ResourceManager.getImage((String)this.imageId))) != null) {
                    grayImage = new Image(originalImage.getDevice(), grayData);
                    ResourceManager.addImage((String)(String.valueOf(this.imageId) + "greyScale"), (Image)grayImage);
                }
                if (grayImage != null) {
                    this.cmb3Bool.setImage(grayImage);
                }
            } else {
                this.cmb3Bool.setImage(ResourceManager.getImage((String)this.imageId));
            }
        }
        if (elementValue == null) {
            this.cmb3Bool.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + ((CheckBoxPropertyDescriptor)this.pDescriptor).getDescription());
        } else {
            this.cmb3Bool.setToolTipText(((CheckBoxPropertyDescriptor)this.pDescriptor).getDescription());
        }
        this.setData(pnode, resolvedValue);
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.createContextualMenu(pnode);
        this.cmb3Bool.setEnabled(pnode.isEditable());
        boolean v = false;
        if (b != null) {
            v = (Boolean)b;
        }
        this.cmb3Bool.setSelection(v);
    }
}

