/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.classname.ClassTypeCellEditor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPText;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPClassType<T extends IPropertyDescriptor>
extends SPText<T> {
    protected Button btn;
    private List<Class<?>> classes;

    public void setClassesOfType(List<Class<?>> classes) {
        this.classes = classes;
    }

    public SPClassType(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
    }

    @Override
    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
        this.btn.setEnabled(!readonly);
    }

    @Override
    protected int getStyle() {
        return 2048;
    }

    @Override
    protected void createComponent(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        super.createComponent(container);
        GridData textData = new GridData(768);
        textData.minimumWidth = 50;
        this.ftext.setLayoutData(textData);
        this.btn = this.section.getWidgetFactory().createButton(container, "...", 8);
        this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String classname = ClassTypeCellEditor.getJavaClassDialog(SPClassType.this.btn.getShell(), SPClassType.this.classes);
                if (classname != null) {
                    SPClassType.this.handleTextChanged(SPClassType.this.section, SPClassType.this.pDescriptor.getId(), classname);
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this.btn.getParent();
    }

    @Override
    protected void handleTextChanged(AbstractSection section, Object property, String text) {
        if (text != null && text.trim().isEmpty()) {
            text = null;
        }
        section.changeProperty(property, text);
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.btn.setEnabled(pnode.isEditable());
        super.setData(pnode, b);
    }
}

