/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPFontNameCombo<T extends IPropertyDescriptor>
extends ASPropertyWidget<T> {
    private PreferenceListener preferenceListener = new PreferenceListener();
    protected Combo combo;
    protected boolean isRefreshing;
    protected String[] lastFonts = null;
    private static String separator = "__________________";
    private APropertyNode pnode;

    public SPFontNameCombo(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
        JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, (IResource)section.getJasperReportsContext().get("ifile"));
    }

    private int indexOf(Combo combo, String searchedString) {
        String[] elements = combo.getItems();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(searchedString)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static List<String[]> getFontNames() {
        ArrayList<String[]> classes = new ArrayList<String[]>();
        ArrayList<String> elements = new ArrayList<String>();
        classes.add(elements.toArray(new String[elements.size()]));
        elements = new ArrayList();
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            elements.add(name);
            ++i;
        }
        classes.add(elements.toArray(new String[elements.size()]));
        return classes;
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.pnode = pnode;
        if (pnode != null) {
            this.createContextualMenu(pnode);
            this.isRefreshing = true;
            this.combo.setEnabled(pnode.isEditable());
            this.refreshFonts();
            if (b != null) {
                this.combo.setText(b.toString());
            }
            this.isRefreshing = false;
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        this.setData(pnode, resolvedValue);
        if (this.combo != null && !this.combo.isDisposed()) {
            if (elementValue != null) {
                this.combo.setForeground(ColorConstants.black);
            } else {
                this.combo.setForeground(UIUtils.INHERITED_COLOR);
            }
        }
    }

    protected void refreshFonts() {
        if (this.pnode != null) {
            JasperReportsConfiguration jConfig = this.pnode.getJasperConfiguration();
            if (jConfig != null) {
                boolean sameList;
                String[] fontList = jConfig.getFontList();
                boolean bl = sameList = this.lastFonts == fontList;
                if (!sameList) {
                    this.combo.setItems(fontList);
                    this.lastFonts = fontList;
                }
            } else {
                FontUtils.stringToItems(SPFontNameCombo.getFontNames());
            }
        }
    }

    public void propertyChange(AbstractSection section, String property, String value) {
        section.changeProperty(property, value);
    }

    @Override
    protected void createComponent(Composite parent) {
        if (this.combo == null) {
            this.combo = new Combo(parent, 0);
            this.combo.addModifyListener(new ModifyListener(){
                private int time = 0;

                public void modifyText(ModifyEvent e) {
                    if (!SPFontNameCombo.this.isRefreshing) {
                        if (e.time - this.time > 100) {
                            String value = SPFontNameCombo.this.combo.getText();
                            if (!value.equals(separator)) {
                                SPFontNameCombo.this.propertyChange(SPFontNameCombo.this.section, "fontName", SPFontNameCombo.this.combo.getText());
                            } else {
                                SPFontNameCombo.this.combo.select(SPFontNameCombo.this.indexOf(SPFontNameCombo.this.combo, (String)SPFontNameCombo.this.section.getElement().getPropertyActualValue("fontName")));
                            }
                            int stringLength = SPFontNameCombo.this.combo.getText().length();
                            SPFontNameCombo.this.combo.setSelection(new Point(stringLength, stringLength));
                        }
                        this.time = e.time;
                    }
                }
            });
            this.combo.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JaspersoftStudioPlugin.getInstance().removePreferenceListener(SPFontNameCombo.this.preferenceListener);
                }
            });
        }
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("FONT_LIST")) {
                SPFontNameCombo.this.refreshFonts();
            }
        }
    }
}

