/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.jface.IntegerCellEditorValidator;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.text.MFont;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboItemSeparator;
import com.jaspersoft.studio.property.combomenu.ComboMenuViewer;
import com.jaspersoft.studio.property.descriptor.combo.FontNamePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPFontNamePopUp;
import com.jaspersoft.studio.property.section.widgets.SPFontSize;
import com.jaspersoft.studio.swt.widgets.NumericCombo;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignFont;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.StyleResolver;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.swt.ResourceManager;

public class SPFontPanelChartPopUp
extends ASPropertyWidget<IPropertyDescriptor> {
    private PreferenceListener preferenceListener = new PreferenceListener();
    private ComboMenuViewer fontName;
    private NumericCombo fontSize;
    private ToolItem boldButton;
    private ToolItem italicButton;
    private ToolItem underlineButton;
    private ToolItem strikeTroughtButton;
    private boolean itemsSetted;
    private MFont mfont;
    private APropertyNode parentNode;
    private Composite group;

    public SPFontPanelChartPopUp(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
        JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, (IResource)section.getJasperReportsContext().get("ifile"));
        this.itemsSetted = false;
    }

    @Override
    public Control getControl() {
        return this.group.getParent();
    }

    private List<ComboItem> stringToItems(List<String[]> fontsList) {
        int i = 0;
        ArrayList<ComboItem> itemsList = new ArrayList<ComboItem>();
        FontUtil util = FontUtil.getInstance((JasperReportsContext)this.parentNode.getJasperConfiguration());
        int index = 0;
        while (index < fontsList.size()) {
            String[] fonts;
            String[] stringArray = fonts = fontsList.get(index);
            int n = fonts.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Image resolvedImage = ResourceManager.getImage((String)element);
                if (resolvedImage == null) {
                    resolvedImage = new Image(null, ImageUtils.convertToSWT(SPFontNamePopUp.createFontImage(element, util)));
                    ResourceManager.addImage((String)element, (Image)resolvedImage);
                }
                itemsList.add(new ComboItem(element, true, resolvedImage, i, element, element));
                ++i;
                ++n2;
            }
            if (index + 1 != fontsList.size() && fonts.length > 0) {
                itemsList.add(new ComboItemSeparator(i));
                ++i;
            }
            ++index;
        }
        return itemsList;
    }

    public void propertyChange(AbstractSection section, String property, String value, FontNamePropertyDescriptor pd) {
        this.changeProperty(section, this.pDescriptor.getId(), pd.getId(), value);
    }

    @Override
    protected void createComponent(Composite parent) {
        this.mfont = new MFont((JRFont)new JRDesignFont(null));
        this.group = this.section.getWidgetFactory().createSection(parent, this.pDescriptor.getDisplayName(), true, 3);
        final FontNamePropertyDescriptor pd = (FontNamePropertyDescriptor)this.mfont.getPropertyDescriptor("fontName");
        this.fontName = new ComboMenuViewer(this.group, 2, "SampleSampleSample");
        this.fontName.setToolTipText(pd.getDescription());
        this.fontName.addSelectionListener(new ComboItemAction(){

            @Override
            public void exec() {
                SPFontPanelChartPopUp.this.propertyChange(SPFontPanelChartPopUp.this.section, "fontName", SPFontPanelChartPopUp.this.fontName.getSelectionValue() != null ? SPFontPanelChartPopUp.this.fontName.getSelectionValue().toString() : null, pd);
            }
        });
        this.fontName.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JaspersoftStudioPlugin.getInstance().removePreferenceListener(SPFontPanelChartPopUp.this.preferenceListener);
            }
        });
        final RWComboBoxPropertyDescriptor pd1 = (RWComboBoxPropertyDescriptor)this.mfont.getPropertyDescriptor("fontSize");
        Composite fontSizeLayout = new Composite(this.group, 0);
        GridData fontSizeData = new GridData();
        fontSizeData.widthHint = 65;
        fontSizeData.minimumWidth = 65;
        fontSizeLayout.setLayout((Layout)new GridLayout(1, false));
        fontSizeLayout.setLayoutData((Object)fontSizeData);
        this.fontSize = new NumericCombo(fontSizeLayout, 0x800000, 0, 6);
        this.fontSize.setLayoutData(new GridData(768));
        this.fontSize.setItems(pd1.getItems());
        this.fontSize.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int time = 0;

            public void widgetSelected(SelectionEvent e) {
                if (e.time - this.time > 100) {
                    String value = SPFontPanelChartPopUp.this.fontSize.getText();
                    if (IntegerCellEditorValidator.instance().isValid(value) == null) {
                        SPFontPanelChartPopUp.this.changeProperty(SPFontPanelChartPopUp.this.section, SPFontPanelChartPopUp.this.pDescriptor.getId(), pd1.getId(), value);
                    }
                }
                this.time = e.time;
            }
        });
        this.fontSize.setToolTipText(pd1.getDescription());
        new SPChartButtom(this, this.group, this.section, (IPropertyDescriptor)pd1, (APropertyNode)this.mfont, this.pDescriptor.getId().toString());
        ToolBar toolBar = new ToolBar(this.group, 0x804040);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        toolBar.setLayoutData((Object)gd);
        this.boldButton = this.createItem(toolBar, "isBold", "icons/resources/edit-bold.png");
        this.italicButton = this.createItem(toolBar, "isItalic", "icons/resources/edit-italic.png");
        this.underlineButton = this.createItem(toolBar, "isUnderline", "icons/resources/edit-underline.png");
        this.strikeTroughtButton = this.createItem(toolBar, "isStrikeThrough", "icons/resources/edit-strike.png");
    }

    private ToolItem createItem(ToolBar toolBar, Object id, String image) {
        final IPropertyDescriptor ipd = this.mfont.getPropertyDescriptor(id);
        final ToolItem item = new ToolItem(toolBar, 32);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPFontPanelChartPopUp.this.changeProperty(SPFontPanelChartPopUp.this.section, SPFontPanelChartPopUp.this.pDescriptor.getId(), ipd.getId(), new Boolean(item.getSelection()));
            }
        });
        item.setImage(JaspersoftStudioPlugin.getInstance().getImage(image));
        item.setToolTipText(ipd.getDescription());
        return item;
    }

    private void changeProperty(AbstractSection section, Object property, Object prop, Object value) {
        section.changePropertyOn(prop, value, this.mfont);
        if (property != null && this.parentNode != null) {
            section.changePropertyOn(property, new MFont(this.mfont.getValue()), this.parentNode);
        }
    }

    public void setFontSizeNumber(Number resolvedNumber, Number ownNumber) {
        if (resolvedNumber != null) {
            int oldpos = this.fontSize.getCaretPosition();
            if (ownNumber == null) {
                this.fontSize.setDefaultValue(resolvedNumber);
            }
            this.fontSize.setValue(ownNumber);
            if (this.fontSize.getText().length() >= oldpos) {
                this.fontSize.setSelection(new Point(oldpos, oldpos));
            }
        } else if (ownNumber != null) {
            int oldpos = this.fontSize.getCaretPosition();
            this.fontSize.setValue(ownNumber);
            if (this.fontSize.getText().length() >= oldpos) {
                this.fontSize.setSelection(new Point(oldpos, oldpos));
            }
        } else {
            this.fontSize.setValue(null);
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        this.parentNode = pnode;
        this.mfont = (MFont)value;
        if (this.mfont != null) {
            JRFont fontValue = this.mfont.getValue();
            if (!this.itemsSetted) {
                this.fontName.setItems(this.stringToItems(ModelUtils.getFontNames(this.parentNode.getJasperConfiguration())));
                this.itemsSetted = true;
            }
            StyleResolver sr = new StyleResolver((JasperReportsContext)this.mfont.getJasperConfiguration());
            String strfontname = sr.getFontName(fontValue);
            this.fontName.setText(strfontname);
            this.setFontSizeNumber(Float.valueOf(fontValue.getFontsize()), fontValue.getOwnFontsize());
            Boolean b = sr.isBold(fontValue);
            this.boldButton.setSelection(b != null ? b : false);
            b = sr.isItalic(fontValue);
            this.italicButton.setSelection(b != null ? b : false);
            b = sr.isUnderline(fontValue);
            this.underlineButton.setSelection(b != null ? b : false);
            b = sr.isStrikeThrough(fontValue);
            this.strikeTroughtButton.setSelection(b != null ? b : false);
        }
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("FONT_LIST") && SPFontPanelChartPopUp.this.parentNode != null) {
                List<String[]> fonts = ModelUtils.getFontNames(SPFontPanelChartPopUp.this.parentNode.getJasperConfiguration());
                SPFontPanelChartPopUp.this.fontName.setItems(SPFontPanelChartPopUp.this.stringToItems(fonts));
            }
        }
    }

    private static class SPChartButtom<T extends IPropertyDescriptor>
    extends SPFontSize<T> {
        private String fontNameProperty;
        final /* synthetic */ SPFontPanelChartPopUp this$0;

        public SPChartButtom(Composite parent, AbstractSection section, T pDescriptor, APropertyNode fontValue, String fontNameProperty) {
            this.this$0 = var1_1;
            super(parent, section, pDescriptor, fontValue);
            this.fontNameProperty = fontNameProperty;
        }

        @Override
        protected void createCommand(boolean increment) {
            Float fontSizeValue = this.this$0.fontSize.getValueAsFloat();
            Float newValue = Float.valueOf(2.0f);
            if (fontSizeValue != null) {
                newValue = fontSizeValue;
                Integer plus = null;
                plus = increment ? Integer.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)SPFontSize.factor.intValue()) + 1) : Integer.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)(-SPFontSize.factor.intValue())) - 1);
                if (newValue.floatValue() + (float)plus.intValue() > 99.0f) {
                    newValue = Float.valueOf(99.0f);
                } else if (newValue.floatValue() + (float)plus.intValue() > 0.0f) {
                    newValue = Float.valueOf(newValue.floatValue() + (float)plus.intValue());
                }
                this.section.changePropertyOn("fontSize", newValue, this.this$0.mfont);
                this.section.changePropertyOn(this.fontNameProperty, new MFont(this.this$0.mfont.getValue()), this.this$0.parentNode);
            }
        }
    }
}

