/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboMenuViewer;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPRWPopUpCombo;
import com.jaspersoft.studio.utils.EnumHelper;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.ResourceManager;

public class SPLineStyleEnum {
    private ComboMenuViewer combo;
    private List<ComboItem> itemsList;

    public SPLineStyleEnum(Composite parent, AbstractSection section, String property) {
        this.createComponent(parent, section, property);
    }

    public Object getSelectedValue() {
        return this.combo.getSelectionValue();
    }

    public void createComponent(Composite parent, final AbstractSection section, String property) {
        Composite composite = new Composite(parent, 0);
        RowLayout layout = new RowLayout();
        layout.marginLeft = 0;
        composite.setLayout((Layout)layout);
        this.itemsList = new ArrayList<ComboItem>();
        this.itemsList.add(new ComboItem("Inherited ", true, ResourceManager.getImage(this.getClass(), (String)"/icons/resources/inherited.png"), 0, (Object)NullEnum.INHERITED, null));
        this.itemsList.add(new ComboItem("Solid line ", true, ResourceManager.getImage(this.getClass(), (String)"/icons/resources/line-solid.png"), 1, LineStyleEnum.SOLID, EnumHelper.getIntValueForCombo(LineStyleEnum.SOLID, true)));
        this.itemsList.add(new ComboItem("Dashed line ", true, ResourceManager.getImage(this.getClass(), (String)"/icons/resources/line-dashed.png"), 2, LineStyleEnum.DASHED, EnumHelper.getIntValueForCombo(LineStyleEnum.DASHED, true)));
        this.itemsList.add(new ComboItem("Dotted line ", true, ResourceManager.getImage(this.getClass(), (String)"/icons/resources/line-dotted.png"), 3, LineStyleEnum.DOTTED, EnumHelper.getIntValueForCombo(LineStyleEnum.DOTTED, true)));
        this.itemsList.add(new ComboItem("Double line ", true, ResourceManager.getImage(this.getClass(), (String)"/icons/resources/line-double.png"), 4, LineStyleEnum.DOUBLE, EnumHelper.getIntValueForCombo(LineStyleEnum.DOUBLE, true)));
        this.combo = new ComboMenuViewer(composite, 0, SPRWPopUpCombo.getLongest(this.itemsList));
        this.combo.setItems(this.itemsList);
        this.combo.addSelectionListener(new ComboItemAction(){

            @Override
            public void exec() {
                SPLineStyleEnum.this.propertyChange(section, "lineStyle", SPLineStyleEnum.this.combo.getSelectionValue() != null ? SPLineStyleEnum.this.combo.getSelectionValue() : null);
            }
        });
    }

    public void setHelp(String href) {
        this.combo.setHelp(href);
    }

    public void propertyChange(AbstractSection section, String property, Object value) {
        section.changeProperty(property, value);
    }

    public int getIndexByType(LineStyleEnum searched) {
        int index = 0;
        for (ComboItem item : this.itemsList) {
            if (searched.equals(item.getItem())) break;
            ++index;
        }
        return index;
    }

    protected void setInhterited(boolean isInherited) {
        if (isInherited) {
            this.combo.setTextForeground(UIUtils.INHERITED_COLOR);
        } else {
            this.combo.setTextForeground(ColorConstants.black);
        }
    }

    public void setToolTipText(String text) {
        this.combo.setToolTipText(text);
    }

    public void setData(Integer b) {
        this.combo.select(b);
    }

    public void setData(Integer b, boolean isInherited) {
        this.setInhterited(isInherited);
        this.setData(b);
    }

    public void setData(LineStyleEnum lse, boolean isInherited) {
        this.setInhterited(isInherited);
        this.setData(lse);
    }

    public void setData(LineStyleEnum lse) {
        if (lse == null) {
            this.combo.select(0);
        } else if (lse == LineStyleEnum.SOLID) {
            this.combo.select(1);
        } else if (lse == LineStyleEnum.DASHED) {
            this.combo.select(2);
        } else if (lse == LineStyleEnum.DOTTED) {
            this.combo.select(3);
        } else if (lse == LineStyleEnum.DOUBLE) {
            this.combo.select(4);
        }
    }

    public Control getControl() {
        return this.combo.getControl();
    }
}

