/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPRWCombo;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPRWLanguageCombo<T extends IPropertyDescriptor>
extends SPRWCombo<T> {
    private static final HashSet<String> DEPRECATED_LANGUAGES = new HashSet();
    private static final String ERROR_STATE_KEY = "error_state";

    static {
        DEPRECATED_LANGUAGES.add("beanshell");
    }

    public SPRWLanguageCombo(Composite parent, AbstractSection section, T pDescriptor) {
        super(parent, section, pDescriptor);
    }

    private boolean isErrorState() {
        Object value = this.combo.getData(ERROR_STATE_KEY);
        if (value != null) {
            return (Boolean)value;
        }
        return false;
    }

    private void setErrorState(boolean value) {
        this.combo.setData(ERROR_STATE_KEY, (Object)value);
    }

    @Override
    protected void setComboSelection(String str, boolean isCaseSensitive) {
        super.setComboSelection(str, isCaseSensitive);
        if (str != null) {
            str = str.trim().toLowerCase();
        }
        boolean isErrorState = this.isErrorState();
        boolean isLanguageDeprecated = DEPRECATED_LANGUAGES.contains(str);
        if (isLanguageDeprecated && !isErrorState) {
            this.combo.setBackground(ColorConstants.orange);
            this.combo.setToolTipText(MessageFormat.format(Messages.SPRWLanguageCombo_languageDeprecated, str));
            this.setErrorState(true);
        } else if (!isLanguageDeprecated && isErrorState) {
            this.combo.setBackground(null);
            this.combo.setToolTipText(this.pDescriptor.getDescription());
            this.setErrorState(false);
        }
    }
}

