/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboMenuViewer;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SPRWPopUpCombo
extends ASPropertyWidget<NamedEnumPropertyDescriptor<LineStyleEnum>> {
    protected ComboMenuViewer combo;
    protected List<ComboItem> items = null;

    public SPRWPopUpCombo(Composite parent, AbstractSection section, NamedEnumPropertyDescriptor<LineStyleEnum> pDescriptor, List<ComboItem> items) {
        super(parent, section, pDescriptor);
        this.items = items;
        this.createComponent(parent);
    }

    @Override
    public Control getControl() {
        if (this.combo != null) {
            return this.combo.getControl();
        }
        return null;
    }

    @Override
    public void setData(APropertyNode pnode, Object b) {
        this.combo.setEnabled(pnode.isEditable());
        int index = 0;
        for (ComboItem item : this.items) {
            if (item.getValue() == null ? b == null : item.getValue().equals(b)) break;
            ++index;
        }
        this.combo.select(index);
    }

    @Override
    public void setData(APropertyNode pnode, Object resolvedValue, Object elementValue) {
        this.setData(pnode, resolvedValue);
        if (elementValue == null) {
            this.combo.setTextForeground(UIUtils.INHERITED_COLOR);
            this.combo.setToolTipText(String.valueOf(Messages.common_inherited_attribute) + ((NamedEnumPropertyDescriptor)this.pDescriptor).getDescription());
            if (this.getLabel() != null) {
                this.getLabel().setToolTipText(String.valueOf(Messages.common_inherited_attribute) + ((NamedEnumPropertyDescriptor)this.pDescriptor).getDescription());
                this.getLabel().setForeground(UIUtils.INHERITED_COLOR);
            }
        } else {
            this.combo.setTextForeground(ColorConstants.black);
            this.combo.setToolTipText(((NamedEnumPropertyDescriptor)this.pDescriptor).getDescription());
            if (this.getLabel() != null) {
                this.getLabel().setToolTipText(((NamedEnumPropertyDescriptor)this.pDescriptor).getDescription());
                this.getLabel().setForeground(ColorConstants.black);
            }
        }
    }

    public static String getLongest(List<ComboItem> itemList) {
        String longest = "";
        for (ComboItem item : itemList) {
            if (longest.length() >= item.getText().length()) continue;
            longest = item.getText();
        }
        return longest;
    }

    @Override
    protected void createComponent(Composite parent) {
        if (this.items != null) {
            this.combo = new ComboMenuViewer(parent, 0, SPRWPopUpCombo.getLongest(this.items));
            this.combo.addSelectionListener(new ComboItemAction(){

                @Override
                public void exec() {
                    SPRWPopUpCombo.this.section.changeProperty(((NamedEnumPropertyDescriptor)SPRWPopUpCombo.this.pDescriptor).getId(), SPRWPopUpCombo.this.combo.getSelectionValue());
                }
            });
            this.combo.setItems(this.items);
            this.combo.setToolTipText(((NamedEnumPropertyDescriptor)this.pDescriptor).getDescription());
            this.getControl().addFocusListener(this.focusListener);
        }
    }
}

