/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.section.widgets;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.subreport.MSubreport;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.GenericJSSParameter;
import com.jaspersoft.studio.property.descriptor.subreport.parameter.dialog.SubreportParameterEditor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRSubreportParameter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SPSubreportParametersButton<T extends IPropertyDescriptor>
extends ASPropertyWidget<T> {
    private Button button;
    private JRSubreportParameter[] dto;
    private MSubreport msubreport;

    public SPSubreportParametersButton(Composite parent, AbstractSection section, T pDescriptor, String buttonText) {
        super(parent, section, pDescriptor);
        this.createButton(parent, buttonText);
    }

    @Override
    protected void createComponent(Composite parent) {
    }

    protected void createButton(Composite parent, String buttonText) {
        this.button = this.section.getWidgetFactory().createButton(parent, buttonText, 8);
        this.button.setToolTipText(this.pDescriptor.getDescription());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubreportParameterEditor wizard = new SubreportParameterEditor(SPSubreportParametersButton.this.msubreport);
                wizard.setValue(GenericJSSParameter.convertFrom(SPSubreportParametersButton.this.dto));
                WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    JRSubreportParameter[] values = GenericJSSParameter.convertToSubreport(wizard.getValue());
                    SPSubreportParametersButton.this.section.changeProperty(SPSubreportParametersButton.this.pDescriptor.getId(), values);
                }
            }
        });
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        if (pnode instanceof MSubreport) {
            this.msubreport = (MSubreport)pnode;
        }
        if (value instanceof JRSubreportParameter[]) {
            this.dto = (JRSubreportParameter[])value;
        }
    }

    @Override
    public Control getControl() {
        return this.button;
    }
}

