/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.statistics;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jaspersoft.studio.ConfigurationManager;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;

public class DefaultAuditProvider {
    public static String STATS_URL_DEFAULT_VALUE = "https://heartbeat.cloud.jaspersoft.com";
    public static String STATS_HEADER_DEFAULT_VALUE = "jaspersoft-stats-token=Og6RqRY3FZMXkZQjoDmBrQQVoyB6ZdWIzB6qML5dSDx95S5r9UTcsabAIuOWB66k";
    public static String STATS_URL_PROPERTY = "com.jaspersoft.studio.community.stats.url";
    public static String STATS_HEADER_PROPERTY = "com.jaspersoft.studio.community.stats.header";
    private CloseableHttpClient httpClient = null;
    public static DefaultAuditProvider INSTANCE = new DefaultAuditProvider();

    private CloseableHttpClient getClient() {
        if (this.httpClient == null) {
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
            BasicCookieStore cookieStore = new BasicCookieStore();
            HttpClientContext context = HttpClientContext.create();
            context.setCookieStore((CookieStore)cookieStore);
            this.httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(globalConfig).setDefaultCookieStore((CookieStore)cookieStore).build();
        }
        return this.httpClient;
    }

    public void audit(final String used_action_id, final String category, final Properties attributes) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                HttpPost request = new HttpPost(System.getProperty(STATS_URL_PROPERTY, STATS_URL_DEFAULT_VALUE));
                try {
                    String[] headerParts;
                    Gson gson = new Gson();
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("category", category);
                    jsonObject.addProperty("used_action_id", used_action_id);
                    jsonObject.addProperty("jss_installation_uuid", ConfigurationManager.getInstallationUUID());
                    Enumeration<Object> keys = attributes.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        jsonObject.addProperty(key, attributes.getProperty(key));
                    }
                    String header = System.getProperty(STATS_HEADER_PROPERTY, STATS_HEADER_DEFAULT_VALUE);
                    if (!header.isEmpty() && (headerParts = header.split("=")).length == 2) {
                        request.setHeader((Header)new BasicHeader(headerParts[0], headerParts[1]));
                    }
                    StringEntity postingString = new StringEntity(gson.toJson((JsonElement)jsonObject));
                    request.setEntity((HttpEntity)postingString);
                    request.setHeader("Content-type", "application/json");
                    DefaultAuditProvider.this.getClient().execute((HttpUriRequest)request);
                }
                catch (IOException iOException) {}
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public void audit(String used_action_id, String category) {
        this.audit(used_action_id, category, new Properties());
    }
}

