/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.statistics.heartbeat;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.statistics.DefaultAuditProvider;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class CommunityLogin {
    public static String COMMUNITY_LOGIN_URL = "https://heartbeat.cloud.jaspersoft.com/login-api.php";
    private CloseableHttpClient httpClient = null;
    public static CommunityLogin INSTANCE = new CommunityLogin();

    private CommunityLogin() {
    }

    private CloseableHttpClient getClient() {
        if (this.httpClient == null) {
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
            BasicCookieStore cookieStore = new BasicCookieStore();
            HttpClientContext context = HttpClientContext.create();
            context.setCookieStore((CookieStore)cookieStore);
            this.httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(globalConfig).setDefaultCookieStore((CookieStore)cookieStore).build();
        }
        return this.httpClient;
    }

    public boolean verifyCredentials(String email, String password) throws IOException {
        try {
            CloseableHttpResponse response;
            String[] headerParts;
            HttpPost post = new HttpPost(COMMUNITY_LOGIN_URL);
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("email", email));
            urlParameters.add(new BasicNameValuePair("password", password));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters, "UTF-8"));
            String header = System.getProperty(DefaultAuditProvider.STATS_HEADER_PROPERTY, DefaultAuditProvider.STATS_HEADER_DEFAULT_VALUE);
            if (!header.isEmpty() && (headerParts = header.split("=")).length == 2) {
                post.setHeader((Header)new BasicHeader(headerParts[0], headerParts[1]));
            }
            boolean bl = (response = this.getClient().execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200;
            return bl;
        }
        finally {
            this.closeClient();
        }
    }

    public void closeClient() {
        if (this.httpClient != null) {
            try {
                try {
                    this.httpClient.close();
                }
                catch (IOException ex) {
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                    this.httpClient = null;
                }
            }
            finally {
                this.httpClient = null;
            }
        }
    }
}

