/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view.text;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.java2d.J2DLightweightSystem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboMenuViewer;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.section.graphic.borders.LineBoxDrawer;
import com.jaspersoft.studio.property.section.widgets.SPRWPopUpCombo;
import com.jaspersoft.studio.style.view.text.LineBoxRectangle;
import com.jaspersoft.studio.style.view.text.TextStyle;
import com.jaspersoft.studio.swt.widgets.ColorStyledText;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceManager;

public class BordersWidget
extends Composite {
    private ToolItem allBorder;
    private ToolItem noneBorder;
    private ToolItem upDownBorder;
    private ToolItem leftRightBorder;
    private LineBoxDrawer bd;
    private Spinner lineWidth;
    private ComboMenuViewer lineStyle;
    private Button checkBoxPadding;
    private Spinner paddingLeft;
    private Spinner paddingRight;
    private Spinner paddingBottom;
    private Spinner paddingTop;
    private RectangleFigure borderPreview;
    private Canvas square;
    private Group rightPanel;
    private ColorStyledText lineColor;
    private TextStyle element;
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();

    public BordersWidget(Composite parent, int style, TextStyle element) {
        super(parent, style);
        this.element = element;
        this.setLayout((Layout)new GridLayout(1, true));
        this.createPaddingPanel(this);
        this.rightPanel = new Group((Composite)this, 0);
        this.rightPanel.setText(Messages.common_borders);
        this.rightPanel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.rightPanel.setLayout((Layout)new GridLayout(2, false));
        this.createBorderPreview((Composite)this.rightPanel);
        this.createStyle((Composite)this.rightPanel);
        Composite toolBarLayout = new Composite((Composite)this.rightPanel, 0);
        toolBarLayout.setLayout((Layout)new GridLayout(1, false));
        GridData toolBardGridData = new GridData(1, 1, true, false);
        toolBardGridData.horizontalSpan = 2;
        toolBardGridData.widthHint = 200;
        toolBardGridData.horizontalIndent = 5;
        toolBarLayout.setLayoutData((Object)toolBardGridData);
        Label textLabel = new Label(toolBarLayout, 0);
        textLabel.setText(Messages.BordersSection_Default_Label);
        ToolBar toolBar = new ToolBar(toolBarLayout, 0x800040);
        this.createButtons(toolBar);
        this.allBorder.setSelection(false);
        this.noneBorder.setSelection(false);
        this.leftRightBorder.setSelection(false);
        this.upDownBorder.setSelection(false);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    private void createBorderPreview(Composite composite) {
        this.square = new Canvas(composite, 0x100800);
        this.square.setBackground(ColorConstants.white);
        this.square.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                BordersWidget.this.updateRightPanel();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        GridData gd = new GridData(1108);
        gd.widthHint = 120;
        gd.heightHint = 120;
        this.square.setLayoutData((Object)gd);
        J2DLightweightSystem lws = new J2DLightweightSystem();
        lws.setControl(this.square);
        this.bd = new LineBoxDrawer(null, this.square);
        this.borderPreview = new LineBoxRectangle(this.bd, this.element.getBorders());
        this.square.setToolTipText(Messages.BordersSection_preview_ToolTip);
        lws.setContents((IFigure)this.borderPreview);
    }

    private void checkBoxValueChange() {
        if (this.checkBoxPadding.getSelection()) {
            this.paddingRight.setEnabled(false);
            this.paddingTop.setEnabled(false);
            this.paddingBottom.setEnabled(false);
        } else {
            this.paddingRight.setEnabled(true);
            this.paddingTop.setEnabled(true);
            this.paddingBottom.setEnabled(true);
        }
    }

    private void createPaddingPanel(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(Messages.BordersSection_Padding_Box_Title);
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        this.checkBoxPadding = new Button((Composite)composite, 0x800020 | Window.getDefaultOrientation());
        this.checkBoxPadding.setText(Messages.BordersSection_Same_Padding_Value_Check);
        this.checkBoxPadding.setLayoutData((Object)gd);
        this.checkBoxPadding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersWidget.this.checkBoxValueChange();
                BordersWidget.this.changePropertyPadding();
                BordersWidget.this.callListeners((Control)BordersWidget.this.checkBoxPadding, "padding");
            }
        });
        new CLabel((Composite)composite, 131072).setText(Messages.BordersSection_Left_Label);
        this.paddingLeft = new Spinner((Composite)composite, 0x800800);
        this.paddingLeft.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.paddingLeft.setToolTipText(Messages.BordersSection_padding_tool_tip);
        this.paddingLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersWidget.this.changePropertyPadding();
                BordersWidget.this.callListeners((Control)BordersWidget.this.paddingLeft, "leftPadding");
            }
        });
        new CLabel((Composite)composite, 131072).setText(Messages.common_right);
        this.paddingRight = new Spinner((Composite)composite, 0x800800);
        this.paddingRight.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.paddingRight.setToolTipText(Messages.BordersSection_padding_tool_tip);
        this.paddingRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersWidget.this.changePropertyPadding();
                BordersWidget.this.callListeners((Control)BordersWidget.this.paddingRight, "rightPadding");
            }
        });
        new CLabel((Composite)composite, 131072).setText(Messages.BordersSection_Top_Label);
        this.paddingTop = new Spinner((Composite)composite, 0x800800);
        this.paddingTop.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.paddingTop.setToolTipText(Messages.BordersSection_padding_tool_tip);
        this.paddingTop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersWidget.this.changePropertyPadding();
                BordersWidget.this.callListeners((Control)BordersWidget.this.paddingTop, "topPadding");
            }
        });
        new CLabel((Composite)composite, 131072).setText(Messages.common_bottom);
        this.paddingBottom = new Spinner((Composite)composite, 0x800800);
        this.paddingBottom.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.paddingBottom.setToolTipText(Messages.BordersSection_padding_tool_tip);
        this.paddingBottom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersWidget.this.changePropertyPadding();
                BordersWidget.this.callListeners((Control)BordersWidget.this.paddingBottom, "bottomPadding");
            }
        });
    }

    private Control createStyle(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        new CLabel(composite, 131072).setText(String.valueOf(Messages.common_pen_color) + ":");
        this.lineColor = new ColorStyledText(composite);
        this.lineColor.setColor(AlfaRGB.getFullyOpaque(new RGB(0, 0, 0)));
        this.lineColor.addListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BordersWidget.this.changeProperty("lineColor", BordersWidget.this.lineColor.getColor());
                BordersWidget.this.callListeners((Control)BordersWidget.this.lineColor, "lineColor");
            }
        });
        new CLabel(composite, 0).setText(String.valueOf(Messages.common_pen_style) + ":");
        this.createLineStyle(composite);
        new CLabel(composite, 131072).setText(String.valueOf(Messages.common_pen_width) + ":");
        this.lineWidth = new Spinner(composite, 0x800800);
        this.lineWidth.setValues(0, 0, 5000, 1, 1, 1);
        this.lineWidth.setToolTipText(Messages.BordersSection_width_tool_tip);
        this.lineWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = BordersWidget.this.lineWidth.getSelection();
                int digits = BordersWidget.this.lineWidth.getDigits();
                Float newValue = new Float((double)selection / Math.pow(10.0, digits));
                BordersWidget.this.changeProperty("lineWidth", newValue);
                BordersWidget.this.callListeners((Control)BordersWidget.this.lineWidth, "lineWidth");
            }
        });
        return composite;
    }

    private int lineStyletoInt(LineStyleEnum style) {
        if (style.equals((Object)LineStyleEnum.SOLID)) {
            return 1;
        }
        if (style.equals((Object)LineStyleEnum.DASHED)) {
            return 2;
        }
        if (style.equals((Object)LineStyleEnum.DOTTED)) {
            return 3;
        }
        if (style.equals((Object)LineStyleEnum.DOUBLE)) {
            return 4;
        }
        return 0;
    }

    private LineStyleEnum intToLinestyleEnum(int value) {
        if (value == 1) {
            return LineStyleEnum.SOLID;
        }
        if (value == 2) {
            return LineStyleEnum.DASHED;
        }
        if (value == 3) {
            return LineStyleEnum.DOTTED;
        }
        if (value == 4) {
            return LineStyleEnum.DOUBLE;
        }
        return null;
    }

    private void createLineStyle(Composite composite) {
        ArrayList<ComboItem> itemsList = new ArrayList<ComboItem>();
        itemsList.add(new ComboItem("Inherited ", true, ResourceManager.getImage(((Object)((Object)this)).getClass(), (String)"/icons/resources/inherited.png"), 0, (Object)NullEnum.INHERITED, null));
        itemsList.add(new ComboItem("Solid line ", true, ResourceManager.getImage(((Object)((Object)this)).getClass(), (String)"/icons/resources/line-solid.png"), 1, LineStyleEnum.SOLID, new Integer(LineStyleEnum.SOLID.getValue() + 1)));
        itemsList.add(new ComboItem("Dashed line ", true, ResourceManager.getImage(((Object)((Object)this)).getClass(), (String)"/icons/resources/line-dashed.png"), 2, LineStyleEnum.DASHED, new Integer(LineStyleEnum.DASHED.getValue() + 1)));
        itemsList.add(new ComboItem("Dotted line ", true, ResourceManager.getImage(((Object)((Object)this)).getClass(), (String)"/icons/resources/line-dotted.png"), 3, LineStyleEnum.DOTTED, new Integer(LineStyleEnum.DOTTED.getValue() + 1)));
        itemsList.add(new ComboItem("Double line ", true, ResourceManager.getImage(((Object)((Object)this)).getClass(), (String)"/icons/resources/line-double.png"), 4, LineStyleEnum.DOUBLE, new Integer(LineStyleEnum.DOUBLE.getValue() + 1)));
        this.lineStyle = new ComboMenuViewer(composite, 0, SPRWPopUpCombo.getLongest(itemsList));
        this.lineStyle.setItems(itemsList);
        this.lineStyle.addSelectionListener(new ComboItemAction(){

            @Override
            public void exec() {
                BordersWidget.this.changeProperty("lineStyle", BordersWidget.this.lineStyle.getSelectionValue() != null ? (Integer)BordersWidget.this.lineStyle.getSelectionValue() : null);
                BordersWidget.this.callListeners(BordersWidget.this.lineStyle.getControl(), "lineStyle");
            }
        });
        this.lineStyle.select(1);
    }

    private void createButtons(ToolBar toolBar) {
        this.noneBorder = new ToolItem(toolBar, 8);
        this.noneBorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlfaRGB beforeSelectionColor = BordersWidget.this.lineColor.getColor();
                int selection = BordersWidget.this.lineWidth.getSelection();
                Object beforeSelectionStyle = BordersWidget.this.lineStyle.getSelectionValue();
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM);
                AlfaRGB color = AlfaRGB.getFullyOpaque(new RGB(0, 0, 0));
                Float newValue = new Float(0.0f);
                BordersWidget.this.changeProperty("lineStyle", 1);
                BordersWidget.this.changeProperty("lineColor", color);
                BordersWidget.this.changeProperty("lineWidth", newValue);
                BordersWidget.this.bd.unselectAll();
                BordersWidget.this.lineStyle.select((Integer)beforeSelectionStyle);
                BordersWidget.this.lineWidth.setSelection(selection);
                BordersWidget.this.lineColor.setColor(beforeSelectionColor);
                BordersWidget.this.callListeners((Control)BordersWidget.this.noneBorder.getParent(), "lineStyle");
            }
        });
        this.noneBorder.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/border.png"));
        this.noneBorder.setToolTipText(Messages.BordersSection_No_Borders);
        this.allBorder = new ToolItem(toolBar, 8);
        this.allBorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM);
                int selection = BordersWidget.this.lineWidth.getSelection();
                int digits = BordersWidget.this.lineWidth.getDigits();
                Float newValue = new Float((double)selection / Math.pow(10.0, digits));
                AlfaRGB color = BordersWidget.this.lineColor.getColor();
                Object style = BordersWidget.this.lineStyle.getSelectionValue();
                BordersWidget.this.changeProperty("lineStyle", style);
                BordersWidget.this.changeProperty("lineColor", color);
                BordersWidget.this.changeProperty("lineWidth", newValue);
                BordersWidget.this.bd.unselectAll();
                BordersWidget.this.callListeners((Control)BordersWidget.this.allBorder.getParent(), "lineStyle");
            }
        });
        this.allBorder.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/border-outside.png"));
        this.allBorder.setToolTipText(Messages.BordersSection_all_borders_tool_tip);
        this.leftRightBorder = new ToolItem(toolBar, 8);
        this.leftRightBorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlfaRGB beforeSelectionColor = BordersWidget.this.lineColor.getColor();
                int selection = BordersWidget.this.lineWidth.getSelection();
                int digits = BordersWidget.this.lineWidth.getDigits();
                Float beforeSelectionWidth = new Float((double)selection / Math.pow(10.0, digits));
                Object beforeSelectionStyle = BordersWidget.this.lineStyle.getSelectionValue();
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT, false);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT, false);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM);
                Float newValue = new Float(0.0f);
                BordersWidget.this.changeProperty("lineStyle", 1);
                BordersWidget.this.changeProperty("lineColor", new AlfaRGB(new RGB(0, 0, 0), 255));
                BordersWidget.this.changeProperty("lineWidth", newValue);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP, false);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM, false);
                BordersWidget.this.changeProperty("lineStyle", beforeSelectionStyle);
                BordersWidget.this.changeProperty("lineColor", beforeSelectionColor);
                BordersWidget.this.changeProperty("lineWidth", beforeSelectionWidth);
                BordersWidget.this.bd.unselectAll();
                BordersWidget.this.lineColor.setColor(beforeSelectionColor);
                BordersWidget.this.lineWidth.setSelection(selection);
                BordersWidget.this.lineStyle.select((Integer)beforeSelectionStyle);
                BordersWidget.this.callListeners((Control)BordersWidget.this.leftRightBorder.getParent(), "lineStyle");
            }
        });
        this.leftRightBorder.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/border-right-left.png"));
        this.leftRightBorder.setToolTipText(Messages.BordersSection_Left_Right_Borders);
        this.upDownBorder = new ToolItem(toolBar, 8);
        this.upDownBorder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlfaRGB beforeSelectionColor = BordersWidget.this.lineColor.getColor();
                int selection = BordersWidget.this.lineWidth.getSelection();
                int digits = BordersWidget.this.lineWidth.getDigits();
                Float beforeSelectionWidth = new Float((double)selection / Math.pow(10.0, digits));
                Object beforeSelectionStyle = BordersWidget.this.lineStyle.getSelectionValue();
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP, false);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM, false);
                Float newValue = new Float(0.0f);
                BordersWidget.this.changeProperty("lineStyle", 1);
                BordersWidget.this.changeProperty("lineColor", new AlfaRGB(new RGB(0, 0, 0), 255));
                BordersWidget.this.changeProperty("lineWidth", newValue);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.LEFT, false);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.RIGHT, false);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.TOP);
                BordersWidget.this.bd.setBorderSelected(LineBoxDrawer.Location.BOTTOM);
                BordersWidget.this.changeProperty("lineStyle", beforeSelectionStyle);
                BordersWidget.this.changeProperty("lineColor", beforeSelectionColor);
                BordersWidget.this.changeProperty("lineWidth", beforeSelectionWidth);
                BordersWidget.this.bd.unselectAll();
                BordersWidget.this.lineColor.setColor(beforeSelectionColor);
                BordersWidget.this.lineWidth.setSelection(selection);
                BordersWidget.this.lineStyle.select((Integer)beforeSelectionStyle);
                BordersWidget.this.callListeners((Control)BordersWidget.this.upDownBorder.getParent(), "lineStyle");
            }
        });
        this.upDownBorder.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/border-top-bottom.png"));
        this.upDownBorder.setToolTipText(Messages.BordersSection_Top_Bottom_Borders);
    }

    public void changeProperty(String property, Object newValue) {
        boolean areAllUnselected = this.bd.areAllUnslected();
        if (areAllUnselected || this.bd.isBottomSelected()) {
            this.setLinePenAttribute(this.element.getBorders().getBottomPen(), property, newValue);
        }
        if (areAllUnselected || this.bd.isTopSelected()) {
            this.setLinePenAttribute(this.element.getBorders().getTopPen(), property, newValue);
        }
        if (areAllUnselected || this.bd.isLeftSelected()) {
            this.setLinePenAttribute(this.element.getBorders().getLeftPen(), property, newValue);
        }
        if (areAllUnselected || this.bd.isRightSelected()) {
            this.setLinePenAttribute(this.element.getBorders().getRightPen(), property, newValue);
        }
        this.bd.refresh();
    }

    private void setLinePenAttribute(JRBoxPen pen, String property, Object value) {
        if ("lineStyle".equals(property)) {
            pen.setLineStyle(this.intToLinestyleEnum((Integer)value));
        } else if ("lineColor".equals(property)) {
            AlfaRGB argbColor = (AlfaRGB)value;
            pen.setLineColor(new Color(argbColor.getRgb().red, argbColor.getRgb().green, argbColor.getRgb().blue, argbColor.getAlfa()));
        } else if ("lineWidth".equals(property)) {
            pen.setLineWidth((Float)value);
        }
    }

    private JRBoxPen locationToLine(LineBoxDrawer.Location loc) {
        JRLineBox borders = this.element.getBorders();
        if (loc == LineBoxDrawer.Location.TOP) {
            return borders.getTopPen();
        }
        if (loc == LineBoxDrawer.Location.BOTTOM) {
            return borders.getBottomPen();
        }
        if (loc == LineBoxDrawer.Location.RIGHT) {
            return borders.getRightPen();
        }
        return borders.getLeftPen();
    }

    private void updateRightPanel() {
        JRLineBox borders = this.element.getBorders();
        if (borders != null) {
            if (this.bd.getLastSelected() != null && this.bd.getLastSelected().isSelected()) {
                this.refreshLinePen(this.locationToLine(this.bd.getLastSelected().getLocation()));
            } else if (this.bd.isTopSelected()) {
                this.refreshLinePen(borders.getTopPen());
            } else if (this.bd.isBottomSelected()) {
                this.refreshLinePen(borders.getBottomPen());
            } else if (this.bd.isLeftSelected()) {
                this.refreshLinePen(borders.getLeftPen());
            } else if (this.bd.isRightSelected()) {
                this.refreshLinePen(borders.getRightPen());
            } else {
                this.lineColor.setColor(AlfaRGB.getFullyOpaque(new RGB(0, 0, 0)));
                this.lineWidth.setValues(0, 0, 5000, 1, 1, 1);
                this.lineStyle.select(1);
            }
        }
    }

    public void refresh() {
        this.refreshPadding();
        if (this.square != null) {
            this.square.redraw();
        }
    }

    private Integer getPaddingValue(Object padding) {
        return padding != null ? (Integer)padding : 0;
    }

    public void refreshPadding() {
        JRLineBox box = this.element.getBorders();
        if (box.getOwnPadding() != null) {
            this.checkBoxPadding.setSelection(true);
            Integer value = box.getPadding();
            this.paddingTop.setSelection(value.intValue());
            this.paddingBottom.setSelection(value.intValue());
            this.paddingLeft.setSelection(value.intValue());
            this.paddingRight.setSelection(value.intValue());
        } else {
            this.checkBoxPadding.setSelection(false);
            this.paddingTop.setSelection(this.getPaddingValue(box.getOwnTopPadding()).intValue());
            this.paddingBottom.setSelection(this.getPaddingValue(box.getOwnBottomPadding()).intValue());
            this.paddingLeft.setSelection(this.getPaddingValue(box.getOwnLeftPadding()).intValue());
            this.paddingRight.setSelection(this.getPaddingValue(box.getOwnRightPadding()).intValue());
        }
        this.checkBoxValueChange();
    }

    public void changePropertyPadding() {
        JRLineBox box = this.element.getBorders();
        if (this.checkBoxPadding.getSelection()) {
            box.setPadding(Integer.valueOf(this.paddingLeft.getSelection()));
            box.setBottomPadding(null);
            box.setLeftPadding(null);
            box.setRightPadding(null);
            box.setTopPadding(null);
        } else {
            box.setPadding(null);
            box.setBottomPadding(Integer.valueOf(this.paddingBottom.getSelection()));
            box.setLeftPadding(Integer.valueOf(this.paddingLeft.getSelection()));
            box.setRightPadding(Integer.valueOf(this.paddingRight.getSelection()));
            box.setTopPadding(Integer.valueOf(this.paddingTop.getSelection()));
        }
    }

    private void callListeners(Control widget, String property) {
        Event e = new Event();
        e.widget = widget;
        SelectionEvent sEvent = new SelectionEvent(e);
        sEvent.data = property;
        for (SelectionListener listener : this.selectionListeners) {
            listener.widgetSelected(sEvent);
        }
    }

    public void refreshLinePen(JRBoxPen lp) {
        Float propertyValue;
        if (lp != null && (propertyValue = Float.valueOf(lp.getOwnLineWidth() != null ? lp.getOwnLineWidth().floatValue() : 0.0f)).floatValue() > 0.0f) {
            Color awtColor;
            AlfaRGB backcolor;
            if (this.lineWidth != null && !this.lineWidth.isDisposed()) {
                UIUtil.setSpinnerSelection(this.lineWidth, null, (int)(propertyValue == null ? 0.0 : propertyValue.doubleValue() * Math.pow(10.0, 1.0)));
            }
            if (this.lineStyle != null && !this.isDisposed()) {
                int ls = lp.getOwnLineStyleValue() != null ? this.lineStyletoInt(lp.getOwnLineStyleValue()) : 0;
                this.lineStyle.select(ls);
            }
            AlfaRGB alfaRGB = backcolor = (awtColor = lp.getOwnLineColor()) != null ? new AlfaRGB(new RGB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue()), awtColor.getAlpha()) : AlfaRGB.getFullyOpaque(new RGB(0, 0, 0));
            if (this.lineColor != null) {
                this.lineColor.setColor(backcolor);
            }
        }
    }
}

