/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view.text;

import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.jasper.JSSReportConverter;
import com.jaspersoft.studio.style.view.text.TextStyle;
import com.jaspersoft.studio.style.view.text.UpdateStyleCommand;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;

public class PreviewGenerator {
    private static BufferedImage bi = null;
    private static JSSDrawVisitor visitor = null;
    private static JasperDesign jasperDesign = null;
    private static JRDesignStaticText textElement = null;

    public static ImageData generatePreview(TextStyle style, int width, int height, RGB containerBackground) {
        if (jasperDesign == null) {
            PreviewGenerator.createDesign();
        }
        ((JRDesignBand)jasperDesign.getTitle()).setHeight(height);
        jasperDesign.setPageWidth(width);
        PreviewGenerator.setDesignElement(style, width, height, containerBackground);
        PreviewGenerator.createBufferedImage();
        visitor.visitStaticText((JRStaticText)textElement);
        return ImageUtils.convertToSWT(bi);
    }

    private static void createDesign() {
        jasperDesign = new JasperDesign();
        jasperDesign.setJasperReportsContext((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
        JRDesignBand jrBand = new JRDesignBand();
        jasperDesign.setTitle((JRBand)jrBand);
        textElement = new JRDesignStaticText();
        jasperDesign.setLeftMargin(0);
        jasperDesign.setRightMargin(0);
        jasperDesign.setTopMargin(0);
        jasperDesign.setBottomMargin(0);
        jrBand.addElement((JRDesignElement)textElement);
        jrBand.setSplitType(SplitTypeEnum.STRETCH);
        textElement.setStretchType(StretchTypeEnum.NO_STRETCH);
        textElement.setPrintRepeatedValues(false);
        textElement.setPrintWhenDetailOverflows(true);
    }

    private static void setDesignElement(TextStyle style, int width, int height, RGB containerBackground) {
        textElement.setWidth(width - 1);
        textElement.setHeight(height - 1);
        textElement.setText(style.getDescription());
        UpdateStyleCommand.applayStyleToTextElement(style, (JRDesignTextElement)textElement);
        if (style.isTransparent().booleanValue()) {
            textElement.setMode(ModeEnum.OPAQUE);
            textElement.setBackcolor(new Color(containerBackground.red, containerBackground.green, containerBackground.blue));
        }
    }

    private static void createBufferedImage() {
        bi = new BufferedImage(textElement.getWidth(), textElement.getHeight(), 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        visitor = new JSSDrawVisitor(new JSSReportConverter((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance(), (JRReport)jasperDesign, true), g2d);
    }
}

