/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view.text;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.style.view.TemplateStyleView;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.ModelUtils;
import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.eclipse.ui.util.RunnableOverwriteQuestion;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TextStyle
extends TemplateStyle
implements IExportedResourceHandler {
    public static final String TEMPLATE_TYPE = "textStyle";
    private static final long serialVersionUID = 1539973461820002113L;
    private static final String TRANSPARENT = "is_transparent";
    private static final String FOREGROUND_COLOR = "foreground_color";
    private static final String BACKGROUND_COLOR = "background_color";
    private static final String VERTICAL_ALIGNMENT = "vertical_alignment";
    private static final String HORIZONTAL_ALIGNMENT = "horizontal_alignment";
    private static final String ROTATION = "rotation";
    private static final String BORDER_BOX = "linebox";
    private static final String FONT = "font";
    private static final String INDEX_FILE_NAME = "index.properties";
    private static final String STYLE_FILE_NAME = "exportedStyles.xml";
    private List<IResourceDefinition> cachedExportableResources = null;
    private Pair<String, List<IResourceDefinition>> cachedImportableResources = null;

    public TextStyle() {
        super(null, null);
    }

    public TextStyle(JRStyle style) {
        super(null, null);
        this.setTransparent(style.getOwnModeValue() != null ? ModeEnum.TRANSPARENT.equals((Object)style.getOwnModeValue()) : true);
        this.setBackGround(style.getOwnBackcolor());
        this.setForeGround(style.getOwnForecolor());
        this.setVerticalAlignmen(style.getOwnVerticalTextAlign() != null ? style.getOwnVerticalTextAlign() : VerticalTextAlignEnum.TOP);
        this.setHorizontalAlignmen(style.getOwnHorizontalTextAlign() != null ? style.getOwnHorizontalTextAlign() : HorizontalTextAlignEnum.LEFT);
        this.setRotation(style.getOwnRotationValue() != null ? style.getOwnRotationValue() : RotationEnum.NONE);
        JRBaseFont font = new JRBaseFont();
        font.setBold(Boolean.valueOf(style.isOwnBold() != null ? style.isOwnBold() : false));
        font.setItalic(new Boolean(style.isOwnItalic() != null ? style.isOwnItalic() : false));
        style.isItalic();
        font.setUnderline(new Boolean(style.isOwnUnderline() != null ? style.isOwnUnderline() : false));
        font.setStrikeThrough(new Boolean(style.isOwnStrikeThrough() != null ? style.isOwnStrikeThrough() : false));
        font.setFontName(style.getOwnFontName());
        font.setFontSize(style.getOwnFontsize());
        this.setFont((JRFont)font);
        JRLineBox originBox = style.getLineBox();
        JRBaseLineBox copyBox = new JRBaseLineBox(null);
        copyBox.setPadding(originBox.getOwnPadding() != null ? new Integer(originBox.getOwnPadding()) : null);
        copyBox.setTopPadding(originBox.getOwnTopPadding() != null ? new Integer(originBox.getOwnTopPadding()) : null);
        copyBox.setBottomPadding(originBox.getOwnBottomPadding() != null ? new Integer(originBox.getOwnBottomPadding()) : null);
        copyBox.setLeftPadding(originBox.getOwnLeftPadding() != null ? new Integer(originBox.getOwnLeftPadding()) : null);
        copyBox.setRightPadding(originBox.getOwnRightPadding() != null ? new Integer(originBox.getOwnRightPadding()) : null);
        this.copyLinePen(originBox.getPen(), copyBox.getPen());
        this.copyLinePen(originBox.getLeftPen(), copyBox.getLeftPen());
        this.copyLinePen(originBox.getRightPen(), copyBox.getRightPen());
        this.copyLinePen(originBox.getBottomPen(), copyBox.getBottomPen());
        this.copyLinePen(originBox.getTopPen(), copyBox.getTopPen());
        this.setBorders((JRLineBox)copyBox);
        String name = style.getName();
        if (name != null && !name.isEmpty()) {
            this.setDescription(name);
        }
    }

    public Boolean isTransparent() {
        Object value = this.getProperty(TRANSPARENT);
        return value != null ? (Boolean)value : false;
    }

    public AlfaRGB getBackGround() {
        return (AlfaRGB)this.getProperty(BACKGROUND_COLOR);
    }

    public AlfaRGB getForeGround() {
        return (AlfaRGB)this.getProperty(FOREGROUND_COLOR);
    }

    public Color getBackGroundColor() {
        return TextStyle.alfaRGBtoColor((AlfaRGB)this.getProperty(BACKGROUND_COLOR));
    }

    public Color getForeGroundColor() {
        return TextStyle.alfaRGBtoColor((AlfaRGB)this.getProperty(FOREGROUND_COLOR));
    }

    public VerticalTextAlignEnum getVerticalAlignmen() {
        return (VerticalTextAlignEnum)this.getProperty(VERTICAL_ALIGNMENT);
    }

    public HorizontalTextAlignEnum getHorizontalAlignmen() {
        return (HorizontalTextAlignEnum)this.getProperty(HORIZONTAL_ALIGNMENT);
    }

    public RotationEnum getRotation() {
        return (RotationEnum)this.getProperty(ROTATION);
    }

    public JRFont getFont() {
        return (JRFont)this.getProperty(FONT);
    }

    public JRLineBox getBorders() {
        return (JRLineBox)this.getProperty(BORDER_BOX);
    }

    public void setTransparent(Boolean value) {
        this.storePropertiy(TRANSPARENT, value);
    }

    public void setBackGround(AlfaRGB value) {
        this.storePropertiy(BACKGROUND_COLOR, value);
    }

    public void setForeGround(AlfaRGB value) {
        this.storePropertiy(FOREGROUND_COLOR, value);
    }

    public void setBackGround(Color value) {
        AlfaRGB aColor = value != null ? new AlfaRGB(new RGB(value.getRed(), value.getGreen(), value.getBlue()), value.getAlpha()) : null;
        this.storePropertiy(BACKGROUND_COLOR, aColor);
    }

    public void setForeGround(Color value) {
        AlfaRGB aColor = value != null ? new AlfaRGB(new RGB(value.getRed(), value.getGreen(), value.getBlue()), value.getAlpha()) : null;
        this.storePropertiy(FOREGROUND_COLOR, aColor);
    }

    public void setVerticalAlignmen(VerticalTextAlignEnum value) {
        this.storePropertiy(VERTICAL_ALIGNMENT, value);
    }

    public void setHorizontalAlignmen(HorizontalTextAlignEnum value) {
        this.storePropertiy(HORIZONTAL_ALIGNMENT, value);
    }

    public void setRotation(RotationEnum value) {
        this.storePropertiy(ROTATION, value);
    }

    public void setFont(JRFont value) {
        this.storePropertiy(FONT, value);
    }

    public void setBorders(JRLineBox value) {
        this.storePropertiy(BORDER_BOX, value);
    }

    private String getFontXML(JRFont value) {
        String result = "<font name=\"" + Misc.nvl((String)value.getOwnFontName()) + "\" ";
        result = String.valueOf(result) + "size=\"" + Misc.nvl((Object)value.getOwnFontsize(), (String)"") + "\" ";
        result = String.valueOf(result) + "isBold=\"" + value.isOwnBold() + "\" isItalic=\"" + value.isOwnItalic() + "\" ";
        result = String.valueOf(result) + "isUnderline=\"" + value.isOwnUnderline() + "\" isStriketrought=\"" + value.isOwnStrikeThrough() + "\"/>";
        return result;
    }

    private static JRFont buildFont(Node xmlFontNode) {
        NamedNodeMap fontAttributes = xmlFontNode.getAttributes();
        String fontName = fontAttributes.getNamedItem("name").getNodeValue();
        Float size = StringUtils.safeParseAsFloat((String)fontAttributes.getNamedItem("size").getNodeValue());
        boolean isBold = fontAttributes.getNamedItem("isBold").getNodeValue().equals("true");
        boolean isItalic = fontAttributes.getNamedItem("isItalic").getNodeValue().equals("true");
        boolean isUnderline = fontAttributes.getNamedItem("isUnderline").getNodeValue().equals("true");
        boolean isStriketrought = fontAttributes.getNamedItem("isStriketrought").getNodeValue().equals("true");
        JRBaseFont result = new JRBaseFont();
        result.setFontName(fontName);
        result.setFontSize(size);
        result.setBold(Boolean.valueOf(isBold));
        result.setItalic(Boolean.valueOf(isItalic));
        result.setUnderline(Boolean.valueOf(isUnderline));
        result.setStrikeThrough(Boolean.valueOf(isStriketrought));
        return result;
    }

    private AlfaRGB colorToAlfaRGB(Color value) {
        if (value == null) {
            return null;
        }
        int red = value.getRed();
        int green = value.getGreen();
        int blue = value.getBlue();
        return new AlfaRGB(new RGB(red, green, blue), value.getAlpha());
    }

    private static Color alfaRGBtoColor(AlfaRGB value) {
        if (value == null) {
            return null;
        }
        RGB rgb = value.getRgb();
        if (rgb == null) {
            return null;
        }
        int red = rgb.red;
        int green = rgb.green;
        int blue = rgb.blue;
        return new Color(red, green, blue, value.getAlfa());
    }

    private String getPenXML(String tagName, JRBoxPen value) {
        LineStyleEnum style = value.getOwnLineStyleValue() != null ? value.getOwnLineStyleValue() : LineStyleEnum.SOLID;
        float lineWidth = value.getOwnLineWidth() != null ? value.getOwnLineWidth().floatValue() : 0.0f;
        Color color = value.getOwnLineColor() != null ? value.getOwnLineColor() : new Color(0, 0, 0);
        String result = "<" + tagName + " lineStyle=\"" + style.getName() + "\" ";
        result = String.valueOf(result) + "lineWidth=\"" + lineWidth + "\">";
        result = String.valueOf(result) + TextStyle.xmlColor("lineColor", this.colorToAlfaRGB(color));
        result = String.valueOf(result) + "</" + tagName + ">";
        return result;
    }

    private static void buildPen(Node xmlPenNode, JRBoxPen sourcePen) {
        NamedNodeMap penAttributes = xmlPenNode.getAttributes();
        LineStyleEnum lineStyle = TextStyle.getLineStyleFromValue(penAttributes.getNamedItem("lineStyle").getNodeValue());
        float lineWidth = Float.parseFloat(penAttributes.getNamedItem("lineWidth").getNodeValue());
        AlfaRGB lineColor = null;
        Node firstChild = xmlPenNode.getFirstChild();
        if (firstChild != null && firstChild.getNodeName().equals("lineColor")) {
            lineColor = TextStyle.rgbColor(firstChild);
        }
        if (lineColor != null) {
            sourcePen.setLineColor(TextStyle.alfaRGBtoColor(lineColor));
        }
        sourcePen.setLineStyle(lineStyle);
        sourcePen.setLineWidth(Float.valueOf(lineWidth));
    }

    private String getLineBoxXML(JRLineBox value) {
        String result = "<linebox padding=\"" + value.getOwnPadding() + "\" ";
        result = String.valueOf(result) + "leftPadding=\"" + value.getOwnLeftPadding() + "\" ";
        result = String.valueOf(result) + "rightPadding=\"" + value.getOwnRightPadding() + "\" topPadding=\"" + value.getOwnTopPadding() + "\" ";
        result = String.valueOf(result) + "bottomPadding=\"" + value.getOwnBottomPadding() + "\">";
        result = String.valueOf(result) + this.getPenXML("pen", value.getPen());
        result = String.valueOf(result) + this.getPenXML("leftPen", value.getLeftPen());
        result = String.valueOf(result) + this.getPenXML("rightPen", value.getRightPen());
        result = String.valueOf(result) + this.getPenXML("topPen", value.getTopPen());
        result = String.valueOf(result) + this.getPenXML("bottomPen", value.getBottomPen());
        result = String.valueOf(result) + "</linebox>";
        return result;
    }

    private static Integer getSafeIntValue(String value) {
        if (value != null && !value.equals("null")) {
            try {
                Integer intValue = Integer.parseInt(value);
                return intValue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private static JRLineBox buildBox(Node xmlBoxNode) {
        NamedNodeMap boxAttributes = xmlBoxNode.getAttributes();
        Integer padding = TextStyle.getSafeIntValue(boxAttributes.getNamedItem("padding").getNodeValue());
        Integer leftPadding = TextStyle.getSafeIntValue(boxAttributes.getNamedItem("leftPadding").getNodeValue());
        Integer rightPadding = TextStyle.getSafeIntValue(boxAttributes.getNamedItem("rightPadding").getNodeValue());
        Integer bottomPadding = TextStyle.getSafeIntValue(boxAttributes.getNamedItem("bottomPadding").getNodeValue());
        Integer topPadding = TextStyle.getSafeIntValue(boxAttributes.getNamedItem("topPadding").getNodeValue());
        JRBaseLineBox result = new JRBaseLineBox(null);
        result.setPadding(padding);
        result.setTopPadding(topPadding);
        result.setBottomPadding(bottomPadding);
        result.setLeftPadding(leftPadding);
        result.setRightPadding(rightPadding);
        Node firstChild = xmlBoxNode.getFirstChild();
        while (firstChild != null) {
            if (firstChild.getNodeName().equals("pen")) {
                TextStyle.buildPen(firstChild, result.getPen());
            } else if (firstChild.getNodeName().equals("leftPen")) {
                TextStyle.buildPen(firstChild, result.getLeftPen());
            } else if (firstChild.getNodeName().equals("rightPen")) {
                TextStyle.buildPen(firstChild, result.getRightPen());
            } else if (firstChild.getNodeName().equals("topPen")) {
                TextStyle.buildPen(firstChild, result.getTopPen());
            } else if (firstChild.getNodeName().equals("bottomPen")) {
                TextStyle.buildPen(firstChild, result.getBottomPen());
            }
            firstChild = firstChild.getNextSibling();
        }
        return result;
    }

    @Override
    public String getXMLData() {
        String result = "<" + this.getTemplateName() + " type=\"" + this.getTemplateName() + "\" ";
        result = String.valueOf(result) + "verticalAlignment=\"" + this.getVerticalAlignmen().getName() + "\" horizontalAlignment=\"" + this.getHorizontalAlignmen().getName() + "\" rotation=\"" + this.getRotation().getName() + "\" ";
        result = String.valueOf(result) + "isTransparent=\"" + this.isTransparent().toString() + "\">";
        result = String.valueOf(result) + "<description>".concat(this.getDescription()).concat("</description>");
        if (this.getForeGround() != null) {
            result = String.valueOf(result) + TextStyle.xmlColor("foreground", this.getForeGround());
        }
        if (this.getBackGround() != null) {
            result = String.valueOf(result) + TextStyle.xmlColor("background", this.getBackGround());
        }
        result = String.valueOf(result) + this.getFontXML(this.getFont());
        result = String.valueOf(result) + this.getLineBoxXML(this.getBorders());
        result = String.valueOf(result) + "</" + this.getTemplateName() + ">";
        return result;
    }

    @Override
    public TemplateStyle buildFromXML(Node xmlNode) {
        try {
            NamedNodeMap rootAttributes = xmlNode.getAttributes();
            VerticalTextAlignEnum verticalAlignment = TextStyle.getTextVAlignmentFromValue(rootAttributes.getNamedItem("verticalAlignment").getNodeValue());
            HorizontalTextAlignEnum horizontalAlignment = TextStyle.getTextHAlignmentFromValue(rootAttributes.getNamedItem("horizontalAlignment").getNodeValue());
            RotationEnum rotation = TextStyle.getRotationFromValue(rootAttributes.getNamedItem(ROTATION).getNodeValue());
            boolean transparent = rootAttributes.getNamedItem("isTransparent").getNodeValue().equals("true");
            AlfaRGB background = null;
            AlfaRGB foreground = null;
            JRFont font = null;
            JRLineBox box = null;
            Node firstChild = xmlNode.getFirstChild();
            String description = null;
            while (firstChild != null) {
                if (firstChild.getNodeName().equals("foreground")) {
                    foreground = TextStyle.rgbColor(firstChild);
                } else if (firstChild.getNodeName().equals("background")) {
                    background = TextStyle.rgbColor(firstChild);
                } else if (firstChild.getNodeName().equals(FONT)) {
                    font = TextStyle.buildFont(firstChild);
                } else if (firstChild.getNodeName().equals(BORDER_BOX)) {
                    box = TextStyle.buildBox(firstChild);
                } else if (firstChild.getNodeName().equals("description")) {
                    Node descriptionNode = firstChild.getChildNodes().item(0);
                    description = descriptionNode != null ? descriptionNode.getNodeValue() : "";
                }
                firstChild = firstChild.getNextSibling();
            }
            TextStyle result = new TextStyle();
            result.setVerticalAlignmen(verticalAlignment);
            result.setHorizontalAlignmen(horizontalAlignment);
            result.setRotation(rotation);
            result.setTransparent(transparent);
            result.setBackGround(background);
            result.setForeGround(foreground);
            result.setFont(font);
            result.setBorders(box);
            result.setDescription(description);
            return result;
        }
        catch (Exception ex) {
            System.out.println("Unable to rebuild the text style");
            ex.printStackTrace();
            return null;
        }
    }

    public TextStyle clone() {
        TextStyle copy = new TextStyle();
        copy.setBackGround(this.getBackGround() != null ? this.getBackGround().clone() : null);
        copy.setForeGround(this.getForeGround() != null ? this.getForeGround().clone() : null);
        copy.setTransparent(new Boolean(this.isTransparent()));
        copy.setDescription(new String(this.getDescription()));
        copy.setRotation(this.getRotation());
        copy.setHorizontalAlignmen(this.getHorizontalAlignmen());
        copy.setVerticalAlignmen(this.getVerticalAlignmen());
        JRBaseFont copyFont = new JRBaseFont();
        JRFont originFont = this.getFont();
        copyFont.setBold(new Boolean(originFont.isOwnBold()));
        copyFont.setItalic(new Boolean(originFont.isOwnItalic()));
        copyFont.setUnderline(new Boolean(originFont.isOwnUnderline()));
        copyFont.setStrikeThrough(new Boolean(originFont.isOwnStrikeThrough()));
        copyFont.setFontName(originFont.getOwnFontName());
        copyFont.setFontSize(originFont.getOwnFontsize());
        copy.setFont((JRFont)copyFont);
        JRLineBox originBox = this.getBorders();
        JRBaseLineBox copyBox = new JRBaseLineBox(null);
        copyBox.setPadding(originBox.getOwnPadding() != null ? new Integer(originBox.getOwnPadding()) : null);
        copyBox.setTopPadding(originBox.getOwnTopPadding() != null ? new Integer(originBox.getOwnTopPadding()) : null);
        copyBox.setBottomPadding(originBox.getOwnBottomPadding() != null ? new Integer(originBox.getOwnBottomPadding()) : null);
        copyBox.setLeftPadding(originBox.getOwnLeftPadding() != null ? new Integer(originBox.getOwnLeftPadding()) : null);
        copyBox.setRightPadding(originBox.getOwnRightPadding() != null ? new Integer(originBox.getOwnRightPadding()) : null);
        this.copyLinePen(originBox.getPen(), copyBox.getPen());
        this.copyLinePen(originBox.getLeftPen(), copyBox.getLeftPen());
        this.copyLinePen(originBox.getRightPen(), copyBox.getRightPen());
        this.copyLinePen(originBox.getBottomPen(), copyBox.getBottomPen());
        this.copyLinePen(originBox.getTopPen(), copyBox.getTopPen());
        copy.setBorders((JRLineBox)copyBox);
        return copy;
    }

    private boolean equalsPen(JRBoxPen pen1, JRBoxPen pen2) {
        if (pen1 == null) {
            return pen2 == null;
        }
        if (pen2 == null) {
            return pen1 == null;
        }
        if (!ModelUtils.safeEquals(pen1.getOwnLineColor(), pen2.getOwnLineColor())) {
            return false;
        }
        if (!ModelUtils.safeEquals(pen1.getOwnLineStyleValue(), pen2.getOwnLineStyleValue())) {
            return false;
        }
        return ModelUtils.safeEquals(pen1.getOwnLineWidth(), pen2.getOwnLineWidth());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextStyle) {
            TextStyle element2 = (TextStyle)obj;
            if (!element2.isTransparent().equals(this.isTransparent())) {
                return false;
            }
            if (!ModelUtils.safeEquals(this.getBackGround(), element2.getBackGround())) {
                return false;
            }
            if (!ModelUtils.safeEquals(this.getForeGround(), element2.getForeGround())) {
                return false;
            }
            if (!ModelUtils.safeEquals(this.getHorizontalAlignmen(), element2.getHorizontalAlignmen())) {
                return false;
            }
            if (!ModelUtils.safeEquals(this.getVerticalAlignmen(), element2.getVerticalAlignmen())) {
                return false;
            }
            if (!ModelUtils.safeEquals(this.getRotation(), element2.getRotation())) {
                return false;
            }
            JRFont font1 = this.getFont();
            JRFont font2 = element2.getFont();
            if (!ModelUtils.safeEquals(font1.isOwnBold(), font2.isOwnBold())) {
                return false;
            }
            if (!ModelUtils.safeEquals(font1.isOwnItalic(), font2.isOwnItalic())) {
                return false;
            }
            if (!ModelUtils.safeEquals(font1.isOwnUnderline(), font2.isOwnUnderline())) {
                return false;
            }
            if (!ModelUtils.safeEquals(font1.isOwnStrikeThrough(), font2.isOwnStrikeThrough())) {
                return false;
            }
            if (!ModelUtils.safeEquals(font1.getOwnFontName(), font2.getOwnFontName())) {
                return false;
            }
            if (!ModelUtils.safeEquals(font1.getOwnFontsize(), font2.getOwnFontsize())) {
                return false;
            }
            JRLineBox box1 = this.getBorders();
            JRLineBox box2 = element2.getBorders();
            if (!ModelUtils.safeEquals(box1.getOwnPadding(), box2.getOwnPadding())) {
                return false;
            }
            if (!ModelUtils.safeEquals(box1.getOwnTopPadding(), box2.getOwnTopPadding())) {
                return false;
            }
            if (!ModelUtils.safeEquals(box1.getOwnBottomPadding(), box2.getOwnBottomPadding())) {
                return false;
            }
            if (!ModelUtils.safeEquals(box1.getOwnLeftPadding(), box2.getOwnLeftPadding())) {
                return false;
            }
            if (!ModelUtils.safeEquals(box1.getOwnRightPadding(), box2.getOwnRightPadding())) {
                return false;
            }
            if (!this.equalsPen(box1.getPen(), box2.getPen())) {
                return false;
            }
            if (!this.equalsPen(box1.getBottomPen(), box2.getBottomPen())) {
                return false;
            }
            if (!this.equalsPen(box1.getTopPen(), box2.getTopPen())) {
                return false;
            }
            if (!this.equalsPen(box1.getLeftPen(), box2.getLeftPen())) {
                return false;
            }
            return this.equalsPen(box1.getRightPen(), box2.getRightPen());
        }
        return false;
    }

    private void copyLinePen(JRBoxPen originPen, JRBoxPen destinationPen) {
        Color newColor = null;
        Color originLineColor = originPen.getOwnLineColor();
        if (originLineColor != null) {
            newColor = new Color(originLineColor.getRed(), originLineColor.getGreen(), originLineColor.getBlue(), originLineColor.getAlpha());
        }
        destinationPen.setLineColor(newColor);
        destinationPen.setLineStyle(originPen.getOwnLineStyleValue());
        destinationPen.setLineWidth(originPen.getOwnLineWidth() != null ? new Float(originPen.getOwnLineWidth().floatValue()) : null);
    }

    @Override
    public String getTemplateName() {
        return TEMPLATE_TYPE;
    }

    @Override
    public String getResourceNameExport() {
        Collection<TemplateStyle> styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors(TEMPLATE_TYPE);
        return "Text Styles (" + styles.size() + ")";
    }

    @Override
    public String getResourceNameImport(File exportedContainer) {
        ArrayList<TemplateStyle> loadedStyles = new ArrayList<TemplateStyle>();
        File exportedFolder = new File(exportedContainer, TEMPLATE_TYPE);
        File[] fileArray = exportedFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File styleDefinition = fileArray[n2];
            try {
                String xml = FileUtils.readFileAsAString((File)styleDefinition);
                List<TemplateStyle> fileStyles = TemplateStyleView.getTemplateStylesStorage().readTemplateFromFile(xml);
                loadedStyles.addAll(fileStyles);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        return "Text Styles (" + loadedStyles.size() + ")";
    }

    @Override
    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        File destDir;
        block10: {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            tempDir.deleteOnExit();
            destDir = new File(tempDir, TEMPLATE_TYPE);
            if (destDir.exists()) {
                FileUtils.recursiveDelete((File)destDir);
            }
            destDir.mkdirs();
            HashSet<TemplateStyle> resourcesToExportSet = new HashSet<TemplateStyle>();
            for (IResourceDefinition definition : resourcesToExport) {
                resourcesToExportSet.add((TemplateStyle)definition.getData());
            }
            Properties props = new Properties();
            Collection<TemplateStyle> styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors(TEMPLATE_TYPE);
            StringBuffer xmlBuffer = new StringBuffer();
            xmlBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<templateStyles>");
            int index = 0;
            for (TemplateStyle style : styles) {
                if (!resourcesToExportSet.contains(style)) continue;
                xmlBuffer.append(style.getXMLData());
                props.put((Object)index, style.getDescription());
                ++index;
            }
            xmlBuffer.append("</templateStyles>");
            try {
                FileOutputStream file = new FileOutputStream(new File(destDir, STYLE_FILE_NAME));
                String xml = xmlBuffer.toString();
                ((OutputStream)file).write(xml.getBytes("UTF-8"));
                file.flush();
                ((OutputStream)file).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(new File(destDir, INDEX_FILE_NAME));
                    props.store(out, "Exported Text Styles Index");
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                    FileUtils.closeStream(out);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(out);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)out);
        }
        return destDir;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        HashSet<Integer> stylesToImport = new HashSet<Integer>();
        for (IResourceDefinition resourceToImport : resourcesToImport) {
            stylesToImport.add((Integer)resourceToImport.getData());
        }
        ArrayList<TemplateStyle> loadedStyles = new ArrayList<TemplateStyle>();
        File exportedFolder = new File(exportedContainer, TEMPLATE_TYPE);
        File exportedFile = new File(exportedFolder, STYLE_FILE_NAME);
        try {
            String xml = FileUtils.readFileAsAString((File)exportedFile);
            List<TemplateStyle> fileStyles = TemplateStyleView.getTemplateStylesStorage().readTemplateFromFile(xml);
            boolean bl = false;
            for (TemplateStyle templateStyle : fileStyles) {
                void var9_11;
                if (stylesToImport.contains((int)var9_11)) {
                    loadedStyles.add(templateStyle);
                }
                ++var9_11;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HashMap<String, TemplateStyle> existingStyles = this.getExistingStyles(TEMPLATE_TYPE);
        ArrayList<String> duplicatedStyles = new ArrayList<String>();
        for (TemplateStyle templateStyle : loadedStyles) {
            if (!existingStyles.containsKey(templateStyle.getDescription())) continue;
            duplicatedStyles.add(templateStyle.getDescription());
        }
        RunnableOverwriteQuestion.RESPONSE_TYPE rESPONSE_TYPE = RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH;
        if (duplicatedStyles.size() > 0) {
            RunnableOverwriteQuestion.RESPONSE_TYPE rESPONSE_TYPE2 = this.askOverwrite(duplicatedStyles);
        }
        for (TemplateStyle templateStyle : loadedStyles) {
            String name = templateStyle.getDescription();
            if (existingStyles.containsKey(name)) {
                void var9_15;
                if (var9_15 == RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH) {
                    templateStyle.setDescription(this.getName(existingStyles, name));
                    TemplateStyleView.getTemplateStylesStorage().addStyle(templateStyle);
                    continue;
                }
                if (var9_15 != RunnableOverwriteQuestion.RESPONSE_TYPE.OVERWRITE) continue;
                TemplateStyleView.getTemplateStylesStorage().removeStyle(existingStyles.get(name));
                TemplateStyleView.getTemplateStylesStorage().addStyle(templateStyle);
                continue;
            }
            TemplateStyleView.getTemplateStylesStorage().addStyle(templateStyle);
        }
    }

    @Override
    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        block9: {
            String containerPath = exportedContainer.getAbsolutePath();
            if (this.cachedImportableResources == null || !((String)this.cachedImportableResources.getKey()).equals(containerPath)) {
                File exportedFolder = new File(exportedContainer, TEMPLATE_TYPE);
                File indexFile = new File(exportedFolder, INDEX_FILE_NAME);
                if (indexFile.exists()) {
                    FileInputStream is = null;
                    try {
                        try {
                            ArrayList<BaseResource> result = new ArrayList<BaseResource>();
                            is = new FileInputStream(indexFile);
                            Properties loadedProperties = new Properties();
                            loadedProperties.load(is);
                            for (Map.Entry<Object, Object> entry : loadedProperties.entrySet()) {
                                BaseResource resource = new BaseResource(entry.getValue().toString());
                                resource.setData(entry.getKey());
                                result.add(resource);
                            }
                            this.cachedImportableResources = new Pair((Object)containerPath, result);
                        }
                        catch (Exception ex) {
                            JaspersoftStudioPlugin.getInstance().logError(ex);
                            this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                            FileUtils.closeStream((Closeable)is);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(is);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)is);
                } else {
                    this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                }
            }
        }
        return (List)this.cachedImportableResources.getValue();
    }

    @Override
    public List<IResourceDefinition> getExportableResources() {
        if (this.cachedExportableResources == null) {
            Collection<TemplateStyle> styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors(TEMPLATE_TYPE);
            this.cachedExportableResources = new ArrayList<IResourceDefinition>();
            for (TemplateStyle style : styles) {
                BaseResource resource = new BaseResource(style.getDescription());
                resource.setData(style);
                this.cachedExportableResources.add(resource);
            }
        }
        return this.cachedExportableResources;
    }

    private RunnableOverwriteQuestion.RESPONSE_TYPE askOverwrite(List<String> stylesName) {
        String baseMessage = Messages.TextStyle_overlappingMEssage;
        StringBuilder message = new StringBuilder("\n");
        int index = 1;
        for (String adapter : stylesName) {
            message.append(adapter);
            message.append(index == stylesName.size() ? ".\n" : ",\n");
            ++index;
        }
        String composedMessage = MessageFormat.format(baseMessage, message.toString());
        return RunnableOverwriteQuestion.showQuestion((String)Messages.TextStyle_overlappingTitle, (String)composedMessage);
    }

    private String getName(HashMap<String, TemplateStyle> existingStyles, String baseName) {
        int index = 1;
        String newName = String.valueOf(baseName) + "_" + index;
        while (existingStyles.containsKey(newName)) {
            newName = String.valueOf(baseName) + "_" + ++index;
        }
        return newName;
    }
}

