/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view.text;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.style.view.TemplateStyleView;
import com.jaspersoft.studio.style.view.TemplateViewProvider;
import com.jaspersoft.studio.style.view.text.PreviewGenerator;
import com.jaspersoft.studio.style.view.text.TextRestrictedTransferType;
import com.jaspersoft.studio.style.view.text.TextStyle;
import com.jaspersoft.studio.style.view.text.TextStyleTransferDropListener;
import com.jaspersoft.studio.style.view.text.TextStyleWizard;
import com.jaspersoft.studio.utils.IOUtils;
import com.jaspersoft.studio.wizards.JSSWizard;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationWizardDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceCache;
import org.eclipse.wb.swt.ResourceManager;

public class TextStyleView
implements TemplateViewProvider {
    private Composite sampleComposite = null;
    private ResourceCache resourceCache = new ResourceCache();
    private ToolItem createStyle = null;

    @Override
    public void createControls(Composite parent) {
        Composite firstLine = new Composite(parent, 0);
        GridLayout firstLineLayout = new GridLayout(2, false);
        firstLineLayout.verticalSpacing = 0;
        firstLineLayout.marginHeight = 0;
        firstLine.setLayout((Layout)firstLineLayout);
        GridData firstLineData = new GridData();
        firstLineData.grabExcessHorizontalSpace = true;
        firstLineData.horizontalAlignment = 4;
        firstLine.setLayoutData((Object)firstLineData);
        Label dragLabel = new Label(firstLine, 0);
        dragLabel.setText(Messages.TextStyleView_dragMessage);
        GridData labelData = new GridData();
        labelData.grabExcessHorizontalSpace = true;
        labelData.horizontalAlignment = 4;
        dragLabel.setLayoutData((Object)labelData);
        this.sampleComposite = new Composite(parent, 0);
        this.sampleComposite.setBackground(ResourceManager.getColor((int)255, (int)255, (int)255));
        GridLayout sampleLayout = new GridLayout(1, false);
        sampleLayout.verticalSpacing = 0;
        this.sampleComposite.setLayout((Layout)sampleLayout);
        GridData galleryData = new GridData();
        galleryData.grabExcessHorizontalSpace = true;
        galleryData.grabExcessVerticalSpace = true;
        galleryData.horizontalAlignment = 4;
        galleryData.verticalAlignment = 4;
        this.sampleComposite.setLayoutData((Object)galleryData);
        this.sampleComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextStyleView.this.resourceCache.dispose();
            }
        });
        this.createToolBar(firstLine);
        this.sampleComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TextStyleView.this.refreshStyles();
            }
        });
        Menu popupMenu = new Menu((Control)this.sampleComposite);
        MenuItem createAction = new MenuItem(popupMenu, 0);
        createAction.setText(Messages.TextStyleView_createLabel);
        createAction.setImage(JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/create-style.png"));
        createAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextStyleView.this.doCreate();
            }
        });
        this.sampleComposite.setMenu(popupMenu);
        this.createDropTarget(this.sampleComposite);
    }

    private void addDragSupport(Control control) {
        int operations = 2;
        Transfer[] types = new Transfer[]{TextRestrictedTransferType.getInstance()};
        DragSource source = new DragSource(control, operations);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new StyleDragListener(control));
    }

    private void createDropTarget(Composite targetText) {
        Transfer[] types = new Transfer[]{TemplateTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)targetText, 2);
        dropTarget.setTransfer(types);
        dropTarget.addDropListener(new DropTargetListener(){
            private List<MStyle> cachedStyles = null;

            private List<MStyle> getDraggedStyles(DropTargetEvent event) {
                ArrayList<MStyle> result = new ArrayList<MStyle>();
                if (event.widget instanceof DropTarget) {
                    DropTarget dropTarget = (DropTarget)event.widget;
                    Transfer[] transferArray = dropTarget.getTransfer();
                    int n = transferArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object droppedObject;
                        Transfer transfer = transferArray[n2];
                        if (transfer instanceof TemplateTransfer && (droppedObject = ((TemplateTransfer)((DropTarget)event.widget).getTransfer()[0]).getTemplate()) instanceof List) {
                            for (Object item : (List)droppedObject) {
                                if (!(item instanceof MStyle)) continue;
                                result.add((MStyle)item);
                            }
                        }
                        ++n2;
                    }
                }
                return result;
            }

            public void dragEnter(DropTargetEvent event) {
                this.cachedStyles = null;
                List<MStyle> draggedStyles = this.getDraggedStyles(event);
                if (draggedStyles.size() == 1) {
                    this.cachedStyles = draggedStyles;
                } else {
                    event.detail = 0;
                    event.feedback = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                if (this.cachedStyles != null) {
                    for (MStyle style : this.cachedStyles) {
                        TextStyle newStyle = new TextStyle(style.getValue());
                        TextStyleWizard wizard = new TextStyleWizard(true, newStyle);
                        WizardDialog dialog = TextStyleView.this.getEditorDialog(wizard);
                        if (dialog.open() != 0) continue;
                        newStyle = wizard.getTableStyle();
                        TemplateStyleView.getTemplateStylesStorage().addStyle(newStyle);
                    }
                }
                this.cachedStyles = null;
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }
        });
    }

    private void doEdit(TextStyle style) {
        TextStyleWizard wizard = new TextStyleWizard(true, style);
        WizardDialog dialog = this.getEditorDialog(wizard);
        if (dialog.open() == 0) {
            TextStyle newStyle = wizard.getTableStyle();
            TemplateStyleView.getTemplateStylesStorage().editStyle(style, newStyle);
        }
    }

    private void doCreate() {
        TextStyleWizard wizard = new TextStyleWizard(true, null);
        WizardDialog dialog = this.getEditorDialog(wizard);
        if (dialog.open() == 0) {
            TextStyle newStyle = wizard.getTableStyle();
            TemplateStyleView.getTemplateStylesStorage().addStyle(newStyle);
        }
    }

    private Menu createPopupMenu(final Control container) {
        Menu popupMenu = new Menu(container);
        MenuItem createAction = new MenuItem(popupMenu, 0);
        createAction.setText(Messages.TextStyleView_createLabel);
        createAction.setImage(JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/create-style.png"));
        createAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextStyleView.this.doCreate();
            }
        });
        MenuItem editAction = new MenuItem(popupMenu, 0);
        editAction.setText(Messages.TextStyleView_editLabel);
        editAction.setImage(JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/edit-style.png"));
        editAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextStyle style = (TextStyle)container.getData();
                TextStyleView.this.doEdit(style);
            }
        });
        MenuItem deleteAction = new MenuItem(popupMenu, 0);
        deleteAction.setText(Messages.TextStyleView_deleteLabel);
        deleteAction.setImage(JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/delete_style.gif"));
        deleteAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateStyleView.getTemplateStylesStorage().removeStyle((TemplateStyle)container.getData());
            }
        });
        return popupMenu;
    }

    protected WizardDialog getEditorDialog(JSSWizard wizardPage) {
        PersistentLocationWizardDialog dialog = new PersistentLocationWizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizardPage){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                Button button = super.createButton(parent, id, label, defaultButton);
                if (id == 16) {
                    button.setText("Finish");
                }
                return button;
            }
        };
        return dialog;
    }

    protected void createToolBar(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        this.createStyle = new ToolItem(toolBar, 8);
        this.createStyle.setImage(this.getTabImage());
        this.createStyle.setToolTipText(Messages.TextStyleView_createToolTip);
        this.createStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextStyleView.this.doCreate();
            }
        });
        GridData toolButtonData = new GridData();
        toolButtonData.horizontalAlignment = 0x1000008;
        toolBar.setLayoutData((Object)toolButtonData);
    }

    @Override
    public AbstractTransferDropTargetListener getDropListener(EditPartViewer viewer) {
        return new TextStyleTransferDropListener(viewer);
    }

    @Override
    public Image getTabImage() {
        return JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/text-style.png");
    }

    @Override
    public TemplateStyle getBuilder() {
        return new TextStyle();
    }

    private void clearContent() {
        Control[] controlArray = this.sampleComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control label = controlArray[n2];
            label.dispose();
            ++n2;
        }
    }

    @Override
    public void refreshStyles() {
        if (this.sampleComposite != null) {
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TextStyleView.this.clearContent();
                    TextStyleView.this.fillStyles();
                }
            });
        }
    }

    @Override
    public void notifyChange(PropertyChangeEvent e) {
        if (e.getNewValue() instanceof TextStyle) {
            this.refreshStyles();
        }
    }

    @Override
    public void fillStyles() {
        this.sampleComposite.setRedraw(false);
        Collection<TemplateStyle> styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors("textStyle");
        if (styles != null) {
            for (TemplateStyle style : styles) {
                final Composite sampleArea = new Composite(this.sampleComposite, 2048);
                sampleArea.setData((Object)style);
                this.addDragSupport((Control)sampleArea);
                GridData sampleData = new GridData();
                sampleData.heightHint = 40;
                sampleData.grabExcessHorizontalSpace = true;
                sampleData.grabExcessVerticalSpace = false;
                sampleData.horizontalAlignment = 4;
                sampleData.verticalAlignment = 128;
                sampleArea.setLayoutData((Object)sampleData);
                sampleArea.setMenu(this.createPopupMenu((Control)sampleArea));
                sampleArea.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        Rectangle bounds = sampleArea.getBounds();
                        int width = bounds.width - 4;
                        int height = 40;
                        if (width < 1 && (width = TextStyleView.this.sampleComposite.getBounds().x - 4) <= 0) {
                            width = 100;
                        }
                        TextStyle originalStyle = (TextStyle)e.widget.getData();
                        TextStyle normalized = originalStyle.clone();
                        String text = originalStyle.getDescription();
                        if (text == null || text.isEmpty()) {
                            text = Messages.TextStyleView_sampleText;
                        }
                        normalized.setDescription(text);
                        normalized.setBorders(null);
                        normalized.setHorizontalAlignmen(HorizontalTextAlignEnum.LEFT);
                        normalized.setVerticalAlignmen(VerticalTextAlignEnum.TOP);
                        int fontSize = 8;
                        Float ownFontsize = normalized.getFont().getOwnFontsize();
                        if (ownFontsize != null) {
                            fontSize = ownFontsize.intValue();
                        }
                        ImageData previewData = PreviewGenerator.generatePreview(normalized, fontSize * text.length() + width, fontSize + height, TextStyleView.this.sampleComposite.getBackground().getRGB());
                        if (ownFontsize != null && ownFontsize.floatValue() > (float)height) {
                            previewData = TextStyleView.cropImage(previewData, 0, 0, height, width);
                        }
                        sampleArea.setBackgroundImage(TextStyleView.this.resourceCache.getImage(previewData));
                    }
                });
                sampleArea.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent e) {
                        TextStyle style = (TextStyle)e.widget.getData();
                        TextStyleView.this.doEdit(style);
                    }
                });
            }
        }
        this.sampleComposite.setRedraw(true);
        this.sampleComposite.layout(true, true);
    }

    private static ImageData cropImage(ImageData sourceImageData, int x, int y, int height, int width) {
        Image sourceImage = new Image((Device)Display.getCurrent(), sourceImageData);
        Image croppedImage = new Image((Device)Display.getCurrent(), width, height);
        GC gc = new GC((Drawable)sourceImage);
        gc.copyArea(croppedImage, x, y);
        gc.dispose();
        ImageData croppedImageData = croppedImage.getImageData();
        croppedImage.dispose();
        sourceImage.dispose();
        return croppedImageData;
    }

    @Override
    public String getTabName() {
        return Messages.TextStyleView_tabTitle;
    }

    protected class StyleDragListener
    implements DragSourceListener {
        private Control draggedElement;

        public StyleDragListener(Control draggedElement) {
            this.draggedElement = draggedElement;
        }

        public void dragStart(DragSourceEvent event) {
            this.dragSetData(event);
        }

        public void dragSetData(DragSourceEvent event) {
            if (this.draggedElement.getData() != null) {
                Object data = this.draggedElement.getData();
                byte[] serializedData = IOUtils.writeToByteArray(data);
                event.data = serializedData;
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }
    }
}

