/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.style.view.text;

import com.jaspersoft.studio.model.style.command.CreateStyleCommand;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.style.view.text.TextStyle;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.eclipse.gef.commands.Command;

public class UpdateStyleCommand
extends Command {
    private JRDesignTextElement jrElement;
    private MTextElement elementModel = null;
    private String oldStyle;
    private TextStyle newStyleTemplate;
    private boolean styleCreted = false;

    public UpdateStyleCommand(MTextElement element, TextStyle newStyle) {
        this.jrElement = (JRDesignTextElement)element.getValue();
        this.newStyleTemplate = newStyle;
        this.elementModel = element;
        this.oldStyle = null;
    }

    private JRStyle checkIfExist(String styleName) {
        JRStyle[] jRStyleArray = this.elementModel.getJasperDesign().getStyles();
        int n = jRStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextStyle compareStyle;
            JRStyle style = jRStyleArray[n2];
            if (style.getName().contains(styleName) && (compareStyle = new TextStyle(style)).equals(this.newStyleTemplate)) {
                return style;
            }
            ++n2;
        }
        return null;
    }

    private String createStyleName(String baseName) {
        JasperDesign design = this.elementModel.getJasperDesign();
        if (!design.getStylesMap().containsKey(baseName)) {
            return baseName;
        }
        int i = 1;
        String newName = String.valueOf(baseName) + " " + i;
        while (design.getStylesMap().containsKey(newName)) {
            newName = String.valueOf(baseName) + " " + ++i;
        }
        return newName;
    }

    private void copyTextStyleToStyle(JRDesignStyle style) {
        style.setHorizontalTextAlign(this.newStyleTemplate.getHorizontalAlignmen());
        style.setVerticalTextAlign(this.newStyleTemplate.getVerticalAlignmen());
        style.setRotation(this.newStyleTemplate.getRotation());
        style.setBackcolor(this.newStyleTemplate.getBackGroundColor());
        style.setForecolor(this.newStyleTemplate.getForeGroundColor());
        style.setMode(this.newStyleTemplate.isTransparent() != false ? ModeEnum.TRANSPARENT : ModeEnum.OPAQUE);
        JRFont font = this.newStyleTemplate.getFont();
        style.setFontName(font.getOwnFontName());
        style.setFontSize(font.getOwnFontsize());
        style.setBold(font.isOwnBold());
        style.setItalic(font.isOwnItalic());
        style.setUnderline(font.isOwnUnderline());
        style.setStrikeThrough(font.isOwnStrikeThrough());
        JRLineBox sourceLineBox = this.newStyleTemplate.getBorders();
        JRLineBox destLineBox = style.getLineBox();
        destLineBox.setPadding(sourceLineBox.getOwnPadding());
        destLineBox.setLeftPadding(sourceLineBox.getOwnLeftPadding());
        destLineBox.setRightPadding(sourceLineBox.getOwnRightPadding());
        destLineBox.setTopPadding(sourceLineBox.getOwnTopPadding());
        destLineBox.setBottomPadding(sourceLineBox.getOwnBottomPadding());
        UpdateStyleCommand.setPenValues(sourceLineBox.getPen(), destLineBox.getPen());
        UpdateStyleCommand.setPenValues(sourceLineBox.getLeftPen(), destLineBox.getLeftPen());
        UpdateStyleCommand.setPenValues(sourceLineBox.getRightPen(), destLineBox.getRightPen());
        UpdateStyleCommand.setPenValues(sourceLineBox.getBottomPen(), destLineBox.getBottomPen());
        UpdateStyleCommand.setPenValues(sourceLineBox.getTopPen(), destLineBox.getTopPen());
    }

    public void execute() {
        this.oldStyle = this.jrElement.getStyle() != null ? this.jrElement.getStyle().getName() : null;
        String styleName = this.newStyleTemplate.getDescription();
        JRStyle previousStyle = this.checkIfExist(styleName);
        if (previousStyle == null) {
            JRDesignStyle previousDesignStyle = new JRDesignStyle();
            previousDesignStyle.setName(this.createStyleName(styleName));
            this.copyTextStyleToStyle(previousDesignStyle);
            CreateStyleCommand command = new CreateStyleCommand(this.elementModel.getJasperDesign(), previousDesignStyle);
            this.styleCreted = true;
            command.execute();
            previousStyle = previousDesignStyle;
        }
        this.elementModel.setPropertyValue("parentStyle", previousStyle.getName());
    }

    private static void setPenValues(JRBoxPen source, JRBoxPen dest) {
        dest.setLineColor(source.getOwnLineColor());
        dest.setLineStyle(source.getOwnLineStyleValue());
        dest.setLineWidth(source.getOwnLineWidth());
    }

    public static void applayStyleToTextElement(TextStyle style, JRDesignTextElement element) {
        element.setHorizontalTextAlign(style.getHorizontalAlignmen());
        element.setVerticalTextAlign(style.getVerticalAlignmen());
        element.setRotation(style.getRotation());
        element.setBackcolor(style.getBackGroundColor());
        element.setForecolor(style.getForeGroundColor());
        element.setMode(style.isTransparent() != false ? ModeEnum.TRANSPARENT : ModeEnum.OPAQUE);
        JRFont font = style.getFont();
        element.setFontName(font.getOwnFontName());
        element.setFontSize(font.getOwnFontsize());
        element.setBold(font.isOwnBold());
        element.setItalic(font.isOwnItalic());
        element.setUnderline(font.isOwnUnderline());
        element.setStrikeThrough(font.isOwnStrikeThrough());
        JRLineBox sourceLineBox = style.getBorders();
        if (sourceLineBox != null) {
            JRLineBox destLineBox = element.getLineBox();
            destLineBox.setPadding(sourceLineBox.getOwnPadding());
            destLineBox.setLeftPadding(sourceLineBox.getOwnLeftPadding());
            destLineBox.setRightPadding(sourceLineBox.getOwnRightPadding());
            destLineBox.setTopPadding(sourceLineBox.getOwnTopPadding());
            destLineBox.setBottomPadding(sourceLineBox.getOwnBottomPadding());
            UpdateStyleCommand.setPenValues(sourceLineBox.getPen(), destLineBox.getPen());
            UpdateStyleCommand.setPenValues(sourceLineBox.getLeftPen(), destLineBox.getLeftPen());
            UpdateStyleCommand.setPenValues(sourceLineBox.getRightPen(), destLineBox.getRightPen());
            UpdateStyleCommand.setPenValues(sourceLineBox.getBottomPen(), destLineBox.getBottomPen());
            UpdateStyleCommand.setPenValues(sourceLineBox.getTopPen(), destLineBox.getTopPen());
        }
    }

    public void undo() {
        if (this.styleCreted) {
            JRStyle style = this.jrElement.getStyle();
            this.elementModel.getJasperDesign().removeStyle(style);
        }
        this.elementModel.setPropertyValue("parentStyle", this.oldStyle);
    }

    public boolean canUndo() {
        return this.jrElement != null;
    }
}

