/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.ValidatedDecimalFormat;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.JSSTableCombo;
import net.sf.jasperreports.eclipse.ui.ValueChangedEvent;
import net.sf.jasperreports.eclipse.ui.ValueChangedListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NumericTableCombo
extends Composite {
    private String[] items = new String[0];
    private JSSTableCombo controlCombo = null;
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private Double minimum = 0.0;
    private Double maximum = Double.MAX_VALUE;
    private boolean isNullable = true;
    private boolean removeTrailZeroes = false;
    private NumberFormat formatter;
    private Number storedValue;
    private int increamentStep = 1;
    private boolean changedAfterFocus = false;
    private Number defaultValue = null;
    private static Point defaultSize = null;
    private Color defaultBackgroundColor;
    private VALIDATION_RESULT currentState = VALIDATION_RESULT.VALID;
    private String longestName = null;
    private Layout mainLayout = new Layout(){

        protected void layout(Composite parent, boolean flushCache) {
            Control[] children = parent.getChildren();
            Rectangle carea = parent.getClientArea();
            children[0].setBounds(0, 0, carea.width, carea.height);
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return NumericTableCombo.this.computeSize(composite, wHint, hHint);
        }
    };
    private VerifyListener inputVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            NumericTableCombo.this.currentState = NumericTableCombo.this.verifyEntryAndStoreValue(e.text, e.start, e.end);
            e.doit = NumericTableCombo.this.currentState != VALIDATION_RESULT.NOT_VALID;
        }
    };
    private ValueChangedListener inputNotifier = new ValueChangedListener(){

        public void valueChanged(ValueChangedEvent e) {
            if (NumericTableCombo.this.currentState == VALIDATION_RESULT.VALID) {
                NumericTableCombo.this.fireListeners();
            }
            NumericTableCombo.this.changedAfterFocus = true;
        }
    };

    public NumericTableCombo(Composite parent, int style, int decimalDigitsShown, int decimalDigitsAccepted) {
        super(parent, style);
        this.createControls();
        this.formatter = new ValidatedDecimalFormat(decimalDigitsShown, decimalDigitsAccepted);
        this.addListeners();
    }

    public NumericTableCombo(Composite parent, NumberFormat formatter, int style) {
        super(parent, style);
        this.createControls();
        this.addListeners();
        this.formatter = formatter;
        Assert.isTrue((formatter != null ? 1 : 0) != 0, (String)"The formatter can't be null");
    }

    protected void createControls() {
        this.setLayout(this.mainLayout);
        if (defaultSize == null) {
            Combo tempCombo = new Combo((Composite)this, 4);
            defaultSize = tempCombo.computeSize(-1, -1);
            tempCombo.dispose();
        }
        this.controlCombo = new JSSTableCombo(this, this.getStyle()){

            protected void setTableData(Table table) {
                NumericTableCombo.this.refreshTableItems(table);
            }

            protected String getLongestText() {
                return NumericTableCombo.this.computeLongestName();
            }
        };
        this.defaultBackgroundColor = UIUtil.getColor("CONTENT_ASSIST_BACKGROUND_COLOR");
        this.controlCombo.defineColumns(1);
        this.controlCombo.setDisplayColumnIndex(0);
        this.controlCombo.setShowTableHeader(false);
        this.controlCombo.setShowColorWithinSelection(false);
        this.layout();
    }

    protected void addListeners() {
        this.addVerifyListener(this.inputVerifier);
        this.addModifyListener(this.inputNotifier);
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                NumericTableCombo.this.setValue(NumericTableCombo.this.storedValue, true);
                if (NumericTableCombo.this.changedAfterFocus) {
                    NumericTableCombo.this.fireListeners();
                }
                NumericTableCombo.this.changedAfterFocus = false;
            }

            public void focusGained(FocusEvent e) {
                NumericTableCombo.this.changedAfterFocus = false;
            }
        });
    }

    public void setMinimum(Double min) {
        if (min == null || this.maximum == null || min < this.maximum) {
            this.minimum = min;
        }
    }

    public void setMaximum(Double max) {
        if (max == null || this.minimum == null || max > this.minimum) {
            this.maximum = max;
        }
    }

    public void setInherited(boolean value) {
        this.controlCombo.setInherithed(value);
    }

    public void setForeground(Color color) {
        this.controlCombo.setForeground(color);
    }

    public Color getForeground() {
        return this.controlCombo.getForeground();
    }

    public void setValues(Number selection, Number minimum, Number maximum) {
        this.setMinimum(minimum != null ? Double.valueOf(minimum.doubleValue()) : null);
        this.setMaximum(maximum != null ? Double.valueOf(maximum.doubleValue()) : null);
        this.setValue(selection);
    }

    protected boolean hasSameValue(Number newValue, Number storedValue) {
        if (ModelUtils.safeEquals(newValue, storedValue)) {
            return true;
        }
        String newFormat = null;
        if (newValue != null) {
            newFormat = this.formatNumber(newValue);
        }
        String storedFormat = null;
        if (storedValue != null) {
            storedFormat = this.formatNumber(storedValue);
        }
        return ModelUtils.safeEquals(newFormat, storedFormat);
    }

    protected String formatNumber(Number value) {
        String result = value instanceof Float ? this.formatter.format(Double.parseDouble(value.toString())) : this.formatter.format(value);
        if (this.removeTrailZeroes && result.indexOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR) != -1) {
            result = result.replaceAll("0*$", "").replaceAll(String.valueOf(ValidatedDecimalFormat.PATTERN_DECIMAL_SEPARATOR) + "$", "");
        }
        return result;
    }

    public void setValue(Number selection) {
        if (selection != null) {
            this.setInherited(false);
            if (!this.hasSameValue(selection, this.storedValue)) {
                this.setValue(selection, true);
            }
        } else if (this.defaultValue != null) {
            this.setInherited(true);
            if (!this.hasSameValue(this.defaultValue, this.storedValue)) {
                this.setValue(null, true);
            }
        } else if (this.storedValue != null) {
            this.setInherited(false);
            this.setValue(null, false);
        }
    }

    protected void setValue(Number selection, boolean formatText) {
        this.checkWidget();
        if (selection != null) {
            if (this.minimum != null && selection.doubleValue() < this.minimum || this.maximum != null && selection.doubleValue() > this.maximum) {
                this.updateBackground(ColorConstants.red);
                this.currentState = VALIDATION_RESULT.OUT_OF_BOUNDS;
            } else {
                this.updateBackground(this.defaultBackgroundColor);
                this.currentState = VALIDATION_RESULT.VALID;
                this.storedValue = selection;
            }
            if (formatText) {
                this.setText(this.formatNumber(selection));
            } else {
                this.setText(selection.toString());
            }
        } else if (this.isNullable) {
            this.updateBackground(this.defaultBackgroundColor);
            this.currentState = VALIDATION_RESULT.VALID;
            this.storedValue = null;
            if (this.defaultValue != null) {
                if (formatText) {
                    this.setText(this.formatNumber(this.defaultValue));
                } else {
                    this.setText(this.defaultValue.toString());
                }
            } else {
                this.setText("");
            }
        } else {
            throw new IllegalArgumentException("The widget can not accept null values when the isNullable property is false");
        }
    }

    protected String updateString(String entry, String text, int start, int end) {
        String work = String.valueOf(text.substring(0, start)) + entry + text.substring(end);
        return work;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VALIDATION_RESULT verifyEntryAndStoreValue(String entry, int start, int end) {
        String text = this.getText();
        String work = this.updateString(entry, text, start, end);
        if (work.isEmpty()) {
            if (!this.isNullable) return VALIDATION_RESULT.NOT_VALID;
            this.storedValue = null;
        } else {
            try {
                Number newValue = this.formatter.parse(work);
                if (this.minimum != null && newValue.doubleValue() < this.minimum || this.maximum != null && newValue.doubleValue() > this.maximum) {
                    this.updateBackground(ColorConstants.red);
                    return VALIDATION_RESULT.OUT_OF_BOUNDS;
                }
                this.storedValue = newValue;
            }
            catch (ParseException parseException) {
                return VALIDATION_RESULT.NOT_VALID;
            }
        }
        this.updateBackground(this.defaultBackgroundColor);
        return VALIDATION_RESULT.VALID;
    }

    protected void updateBackground(Color color) {
        this.controlCombo.setBackground(color);
    }

    public Integer getValueAsInteger() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.intValue();
    }

    public Long getValueAsLong() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.longValue();
    }

    public BigDecimal getValueAsBigDecimal() {
        if (this.storedValue == null) {
            return null;
        }
        return new BigDecimal(this.storedValue.toString());
    }

    public Double getValueAsDouble() {
        if (this.storedValue == null) {
            return null;
        }
        return this.storedValue.doubleValue();
    }

    public Float getValueAsFloat() {
        if (this.storedValue == null) {
            return null;
        }
        return Float.valueOf(this.storedValue.floatValue());
    }

    public Number getValue() {
        return this.storedValue;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.selectionListeners.add(listener);
    }

    public void setNullable(boolean value) {
        this.isNullable = value;
    }

    public void setIncrementStep(int step) {
        Assert.isTrue((step >= 0 ? 1 : 0) != 0, (String)"The step can't be negative");
        this.increamentStep = step;
    }

    public void increment() {
        if (this.storedValue == null) {
            double defaultMin = 0.0;
            if (this.defaultValue != null) {
                defaultMin = this.defaultValue.intValue();
            }
            if (this.minimum != null && this.minimum > defaultMin) {
                defaultMin = this.minimum;
            }
            this.storedValue = new Double(defaultMin);
        }
        double newValue = this.storedValue.doubleValue() + (double)this.increamentStep;
        this.setValue(newValue, true);
        this.fireListeners();
    }

    public void decrement() {
        if (this.storedValue == null) {
            double defaultMin = 0.0;
            if (this.defaultValue != null) {
                defaultMin = this.defaultValue.intValue();
            }
            if (this.minimum != null && this.minimum > defaultMin) {
                defaultMin = this.minimum;
            }
            this.storedValue = new Double(defaultMin);
            this.setValue(this.storedValue, true);
        } else {
            double newValue = this.storedValue.doubleValue() - (double)this.increamentStep;
            this.setValue(newValue, true);
        }
        this.fireListeners();
    }

    protected Point computeSize(Composite composite, int wHint, int hHint) {
        Control[] children = composite.getChildren();
        Point size = children[0].computeSize(wHint, hHint, true);
        return size;
    }

    protected Point getDefaultComboSize() {
        if (defaultSize != null) {
            return new Point(NumericTableCombo.defaultSize.x, NumericTableCombo.defaultSize.y);
        }
        return null;
    }

    protected void checkSubclass() {
    }

    public void cut() {
        this.comboCut();
        this.setValue(null);
        this.fireListeners();
    }

    public void paste() {
        this.comboPaste();
        String work = this.getText().trim();
        if (work.isEmpty()) {
            this.setValue(null);
        } else {
            try {
                Number newValue = this.formatter.parse(work);
                this.setValue(newValue, true);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.fireListeners();
    }

    public void setFormat(NumberFormat formatter) {
        Assert.isTrue((formatter != null ? 1 : 0) != 0, (String)"The formatter can't be null");
        this.formatter = formatter;
        String work = this.getText().trim();
        if (work.isEmpty()) {
            this.setValue(null);
        } else {
            try {
                Number newValue = formatter.parse(work);
                this.setValue(newValue);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void setText(String string) {
        this.removeVerifyListener(this.inputVerifier);
        this.removeModifyListener(this.inputNotifier);
        this.setComboText(string);
        this.addVerifyListener(this.inputVerifier);
        this.addModifyListener(this.inputNotifier);
    }

    protected void fireListeners() {
        Event e = new Event();
        e.widget = this;
        e.time = (int)System.currentTimeMillis();
        SelectionEvent selectionEvent = new SelectionEvent(e);
        for (SelectionListener s : this.selectionListeners) {
            s.widgetSelected(selectionEvent);
        }
    }

    public void setDefaultValue(Number value) {
        this.defaultValue = value;
    }

    public void select(int index) {
        this.comboSelect(index);
        int count = this.getItemCount();
        if (index >= 0 && index < count) {
            if (index == this.getSelectionIndex()) {
                return;
            }
            this.setValue(Double.parseDouble(this.getItem(index)));
        }
    }

    public void setRemoveTrailZeroes(boolean value) {
        this.removeTrailZeroes = value;
    }

    protected void comboSelect(int index) {
        this.controlCombo.select(index);
    }

    public int getItemCount() {
        return this.controlCombo.getItemCount();
    }

    public int getSelectionIndex() {
        return this.controlCombo.getSelectionIndex();
    }

    public String getItem(int index) {
        return this.controlCombo.getItem(index);
    }

    public void setItems(String[] items) {
        this.removeVerifyListener(this.inputVerifier);
        this.removeModifyListener(this.inputNotifier);
        this.setComboItems(items);
        this.addVerifyListener(this.inputVerifier);
        this.addModifyListener(this.inputNotifier);
    }

    private void refreshTableItems(Table table) {
        table.clearAll();
        String[] stringArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(0, item);
            ++n2;
        }
    }

    private String computeLongestName() {
        if (this.longestName == null) {
            this.longestName = "";
            String[] stringArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                String currentText = stringArray[n2];
                if (this.longestName.length() < currentText.length()) {
                    this.longestName = currentText;
                }
                ++n2;
            }
        }
        if (this.longestName == null || this.getText().length() > this.longestName.length()) {
            this.longestName = this.getText();
        }
        return this.longestName;
    }

    protected void setComboItems(String[] items) {
        this.items = items;
        this.refreshTableItems(this.controlCombo.getTable());
    }

    public int getCaretPosition() {
        return this.controlCombo.getCaretPosition();
    }

    protected void addVerifyListener(VerifyListener listener) {
        this.controlCombo.addVerifyListener(listener);
    }

    protected void removeVerifyListener(VerifyListener listener) {
        this.controlCombo.removeVerifyListener(listener);
    }

    public String getText() {
        return this.controlCombo.getText();
    }

    public void setMenu(Menu menu) {
        this.controlCombo.setMenu(menu);
    }

    public Menu getMenu() {
        return this.controlCombo.getMenu();
    }

    protected void addModifyListener(ValueChangedListener listener) {
        this.controlCombo.addModifyListener(listener);
    }

    protected void removeModifyListener(ValueChangedListener listener) {
        this.controlCombo.removeModifyListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.controlCombo.addFocusListener(listener);
    }

    protected void setComboText(String text) {
        this.controlCombo.setText(text);
    }

    protected void comboCut() {
        this.controlCombo.cut();
    }

    protected void comboPaste() {
        this.controlCombo.paste();
    }

    public void setSelection(Point selection) {
        this.controlCombo.setSelection(selection);
    }

    public void setBackground(Color color) {
        if (this.currentState != VALIDATION_RESULT.OUT_OF_BOUNDS) {
            this.controlCombo.setBackground(color);
        }
        this.defaultBackgroundColor = color;
    }

    protected void setComboForeground(Color color) {
        this.controlCombo.setForeground(color);
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        return this.controlCombo.setFocus();
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        return this.controlCombo.forceFocus();
    }

    private static enum VALIDATION_RESULT {
        VALID,
        NOT_VALID,
        OUT_OF_BOUNDS;

    }
}

