/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.ResourceCache;
import org.eclipse.wb.swt.ResourceManager;

public class ResizableToolItem
extends ToolItem {
    private static HashMap<String, ImageData> iconImagesDataMap = new HashMap();
    private ResourceCache imagesResource = new ResourceCache();
    private IAction associatedAction;
    private int suggestedHeight = -1;
    private PaintListener paintListener = null;
    private RGB lastParentBackground = null;

    public ResizableToolItem(ToolBar parent, int style, IAction associtatedAction, int suggestedHeight) {
        super(parent, style);
        this.associatedAction = associtatedAction;
        this.suggestedHeight = suggestedHeight;
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                ResizableToolItem.this.updateImage();
            }
        };
        parent.addPaintListener(this.paintListener);
        this.updateImage();
    }

    private void updateImage() {
        RGB currentParentBackground = this.getParent().getBackground().getRGB();
        if (!ModelUtils.safeEquals(this.lastParentBackground, currentParentBackground)) {
            this.lastParentBackground = currentParentBackground;
            ImageData resizedData = this.getResizedImage(this.associatedAction);
            this.setImage(this.imagesResource.getImage(resizedData));
        }
    }

    protected void checkSubclass() {
    }

    private ImageData getResizedImage(IAction action) {
        RGB currentBackground = this.getParent().getBackground().getRGB();
        String toolbarBackgroundKey = this.getParent().getBackground().getRGB().toString();
        String dataKey = String.valueOf(action.getId()) + toolbarBackgroundKey;
        if (iconImagesDataMap.containsKey(dataKey)) {
            return iconImagesDataMap.get(dataKey);
        }
        Image loadedImage = ResourceManager.getImage((ImageDescriptor)action.getImageDescriptor());
        ImageData resultData = null;
        if (loadedImage != null) {
            int width = loadedImage.getImageData().width;
            int height = loadedImage.getImageData().height;
            if (height < this.suggestedHeight && this.suggestedHeight != -1) {
                height = this.suggestedHeight;
            }
            if (width != loadedImage.getImageData().width || height != loadedImage.getImageData().height) {
                Image resizedImage = ImageUtils.padImage(loadedImage, width, height, currentBackground);
                resultData = (ImageData)resizedImage.getImageData().clone();
                resizedImage.dispose();
                iconImagesDataMap.put(dataKey, resultData);
            }
        }
        return resultData;
    }

    public void dispose() {
        this.getParent().removePaintListener(this.paintListener);
        super.dispose();
        this.imagesResource.dispose();
    }
}

