/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.color.chooser.ColorDialog;
import com.jaspersoft.studio.swt.events.IRefreshableList;
import com.jaspersoft.studio.swt.events.PaletteListener;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WColorsPalette
extends Composite
implements IRefreshableList {
    private List<String> colors;
    private List<PaletteListener> paletteListeners;
    private static List<String> clipboardColors = new ArrayList<String>();
    private int minimumColors;
    private TableViewer tableViewerElements;
    private Button btnAddElement;
    private Button btnModifyElement;
    private Button btnRemoveElement;
    private Button btnMoveUp;
    private Button btnMoveDown;
    private Button btnCopyPalette;
    private Button btnPastePalette;

    public WColorsPalette(Composite parent, int style, int minimumColors) {
        super(parent, style);
        this.minimumColors = minimumColors;
        this.paletteListeners = new ArrayList<PaletteListener>();
        this.colors = new ArrayList<String>();
        GridLayout widgetGl = new GridLayout(2, false);
        widgetGl.verticalSpacing = 0;
        widgetGl.marginHeight = 0;
        this.setLayout((Layout)widgetGl);
        this.createWidgetContent();
    }

    private void createWidgetContent() {
        this.tableViewerElements = new TableViewer((Composite)this, 2562);
        this.tableViewerElements.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 7));
        this.tableViewerElements.setLabelProvider(this.getPaletteLabelProvider());
        this.tableViewerElements.setContentProvider(this.getPaletteContentProvider());
        this.tableViewerElements.setInput(this.colors);
        this.tableViewerElements.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WColorsPalette.this.modifyButtonPressed();
            }
        });
        this.tableViewerElements.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WColorsPalette.this.enableDefaultButtons();
            }
        });
        this.btnAddElement = new Button((Composite)this, 0);
        this.btnAddElement.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnAddElement.setText(Messages.WColorsPalette_Add);
        this.btnAddElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WColorsPalette.this.addButtonPressed();
            }
        });
        this.btnModifyElement = new Button((Composite)this, 0);
        this.btnModifyElement.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnModifyElement.setText(Messages.WColorsPalette_Modify);
        this.btnModifyElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WColorsPalette.this.modifyButtonPressed();
            }
        });
        this.btnRemoveElement = new Button((Composite)this, 0);
        this.btnRemoveElement.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnRemoveElement.setText(Messages.WColorsPalette_Remove);
        this.btnRemoveElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WColorsPalette.this.removeButtonPressed();
            }
        });
        this.btnMoveUp = new Button((Composite)this, 0);
        this.btnMoveUp.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnMoveUp.setText(Messages.WColorsPalette_Up);
        this.btnMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WColorsPalette.this.moveUpButtonPressed();
            }
        });
        this.btnMoveDown = new Button((Composite)this, 0);
        this.btnMoveDown.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnMoveDown.setText(Messages.WColorsPalette_Down);
        this.btnMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WColorsPalette.this.moveDownButtonPressed();
            }
        });
        this.btnCopyPalette = new Button((Composite)this, 0);
        this.btnCopyPalette.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnCopyPalette.setText(Messages.WColorsPalette_CopyColors);
        this.btnCopyPalette.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WColorsPalette.this.copyCurrentPalette();
            }
        });
        this.btnPastePalette = new Button((Composite)this, 0);
        this.btnPastePalette.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnPastePalette.setText(Messages.WColorsPalette_PasteColors);
        this.btnPastePalette.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WColorsPalette.this.pasteClipboardPalette();
            }
        });
        this.enableDefaultButtons();
    }

    protected IContentProvider getPaletteContentProvider() {
        return new ArrayContentProvider();
    }

    protected IBaseLabelProvider getPaletteLabelProvider() {
        return new LabelProvider(){
            private HashMap<RGB, Image> colorIcons = new HashMap();

            public Image getImage(Object element) {
                RGB rgb = Colors.decodeHexStringAsSWTRGB((String)element);
                Image image = this.colorIcons.get(rgb);
                if (image == null) {
                    image = Colors.getSWTColorPreview(Colors.getAWT4SWTRGBColor(AlfaRGB.getFullyOpaque(rgb)), 16, 16);
                }
                this.colorIcons.put(rgb, image);
                return image;
            }

            public void dispose() {
                for (Image img : this.colorIcons.values()) {
                    img.dispose();
                }
                this.colorIcons.clear();
                super.dispose();
            }
        };
    }

    protected void removeButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewerElements.getSelection();
        if (selection != null) {
            Object[] items;
            Object[] objectArray = items = selection.toArray();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                this.colors.remove(item);
                ++n2;
            }
            this.refreshList();
        }
        this.enableDefaultButtons();
    }

    protected void modifyButtonPressed() {
        Object selected = ((IStructuredSelection)this.tableViewerElements.getSelection()).getFirstElement();
        if (selected != null) {
            ColorDialog colorChooseDialog = new ColorDialog(this.getShell());
            colorChooseDialog.setText(Messages.WColorsPalette_PickNewColor);
            RGB decodedRGB = Colors.decodeHexStringAsSWTRGB((String)selected);
            colorChooseDialog.setRGB(decodedRGB);
            RGB newRGB = colorChooseDialog.openRGB();
            if (newRGB != null) {
                String hexEncodedRGBColor = Colors.getHexEncodedRGBColor(newRGB);
                int indexOfSelected = this.colors.indexOf(selected);
                this.colors.remove(indexOfSelected);
                this.colors.add(indexOfSelected, hexEncodedRGBColor);
                this.refreshList();
            }
        }
        this.enableDefaultButtons();
    }

    protected void addButtonPressed() {
        ColorDialog colorChooseDialog = new ColorDialog(this.getShell());
        colorChooseDialog.setText(Messages.WColorsPalette_PickNewColor);
        RGB newRGB = colorChooseDialog.openRGB();
        if (newRGB != null) {
            String hexEncodedRGBColor = Colors.getHexEncodedRGBColor(newRGB);
            this.colors.add(hexEncodedRGBColor);
            this.refreshList();
        }
        this.enableDefaultButtons();
    }

    protected void moveDownButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewerElements.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object[] items = selection.toArray();
            int i = items.length - 1;
            while (i >= 0) {
                int indexOf = this.colors.indexOf(items[i]);
                this.colors.remove(items[i]);
                this.colors.add(indexOf + 1, (String)items[i]);
                --i;
            }
            this.refreshList();
        }
        this.enableDefaultButtons();
    }

    protected void moveUpButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewerElements.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object[] items = selection.toArray();
            int i = 0;
            while (i < items.length) {
                int indexOf = this.colors.indexOf(items[i]);
                this.colors.remove(items[i]);
                this.colors.add(indexOf - 1, (String)items[i]);
                ++i;
            }
            this.refreshList();
        }
        this.enableDefaultButtons();
    }

    protected void enableDefaultButtons() {
        this.btnAddElement.setEnabled(true);
        this.btnPastePalette.setEnabled(!clipboardColors.isEmpty());
        int itemCount = this.tableViewerElements.getTable().getItemCount();
        int selectionCount = this.tableViewerElements.getTable().getSelectionCount();
        if (selectionCount == 0) {
            this.btnCopyPalette.setEnabled(false);
            this.btnModifyElement.setEnabled(false);
            this.btnRemoveElement.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
        } else {
            this.btnCopyPalette.setEnabled(true);
            boolean isMultipleSelection = selectionCount > 1;
            boolean allSelected = itemCount - selectionCount == 0;
            this.btnModifyElement.setEnabled(!isMultipleSelection);
            this.btnRemoveElement.setEnabled(itemCount > this.minimumColors && !allSelected);
            int colorsNum = this.colors.size();
            IStructuredSelection selection = (IStructuredSelection)this.tableViewerElements.getSelection();
            Object[] selectedItems = selection.toArray();
            int firstSelIndex = this.colors.indexOf(selectedItems[0]);
            int lastSelIndex = this.colors.indexOf(selectedItems[selectedItems.length - 1]);
            this.btnMoveDown.setEnabled(lastSelIndex != colorsNum - 1);
            this.btnMoveUp.setEnabled(firstSelIndex != 0);
        }
    }

    public String[] getColorsListAsArray() {
        return this.colors.toArray(new String[this.colors.size()]);
    }

    public String getColorsAsExpressionText(String language) {
        if (this.colors.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer("java.util.Arrays.asList(");
        for (String c : this.colors) {
            sb.append("\"").append(c).append("\",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private void notifyPaletteUpdate() {
        for (PaletteListener l : this.paletteListeners) {
            l.paletteModified(this.colors);
        }
    }

    @Override
    public void refreshList() {
        this.tableViewerElements.setInput(this.colors);
        this.notifyPaletteUpdate();
    }

    public void addPaletteListener(PaletteListener listener) {
        this.paletteListeners.add(listener);
    }

    public void removePaletteListener(PaletteListener listener) {
        this.paletteListeners.remove(listener);
    }

    public TableViewer getPaletteViewer() {
        return this.tableViewerElements;
    }

    public void dispose() {
        super.dispose();
        this.paletteListeners.clear();
        this.paletteListeners = null;
    }

    public void setColors(String[] decodeHexColorsArray) {
        Assert.isNotNull((Object)decodeHexColorsArray);
        this.colors.clear();
        this.colors.addAll(Arrays.asList(decodeHexColorsArray));
        this.refreshList();
    }

    private void copyCurrentPalette() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewerElements.getSelection();
        if (sel != null) {
            clipboardColors.clear();
            clipboardColors.addAll(sel.toList());
        }
        this.enableDefaultButtons();
    }

    private void pasteClipboardPalette() {
        this.colors.addAll(clipboardColors);
        this.refreshList();
        this.enableDefaultButtons();
    }
}

