/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.swt.events.ExpressionModifiedEvent;
import com.jaspersoft.studio.swt.events.ExpressionModifiedListener;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WTextExpression
extends Composite
implements IExpressionContextSetter {
    public static final int LABEL_NONE = 0;
    public static final int LABEL_ON_LEFT = 1;
    public static final int LABEL_ON_TOP = 2;
    public static final int TEXT_LINE_NUMBERS = 3;
    public static final String BUTTON_ICON_PATH = "icons/resources/expressionedit-16.png";
    private int customTextLinesNumber = -1;
    private ExpressionContext expContext;
    private int oldpos = 0;
    private boolean isRefreshing = false;
    protected JRDesignExpression expression;
    protected Text textExpression;
    protected Button btnEditExpression;
    protected Label label;
    private boolean traverseOnTab = false;
    private List<ExpressionModifiedListener> listeners = new ArrayList<ExpressionModifiedListener>();

    public WTextExpression(Composite parent, int style) {
        this(parent, style, null, 0, -1);
    }

    public WTextExpression(Composite parent, int style, int linesNum) {
        this(parent, style, null, 0, linesNum);
    }

    public WTextExpression(Composite parent, int style, String textLabel, int showMode) {
        this(parent, style, textLabel, showMode, -1);
    }

    public WTextExpression(Composite parent, int style, String textLabel, int showMode, int linesNum) {
        super(parent, style);
        this.customTextLinesNumber = linesNum;
        this.setLayout((Layout)new FormLayout());
        this.createLabelControl(textLabel, showMode);
        this.createTextControl();
        this.createButtonControl();
        this.configureWidgetsLayoutData(showMode);
    }

    protected void createTextControl() {
        this.textExpression = new Text((Composite)this, 2624);
        this.textExpression.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                boolean isShift;
                boolean bl = isShift = (e.stateMask & 0x20000) > 0;
                if (e.keyCode == 13 && !isShift) {
                    e.doit = false;
                }
            }
        });
        this.textExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WTextExpression.this.isRefreshing) {
                    String text = WTextExpression.this.textExpression.getText();
                    WTextExpression.this.oldpos = WTextExpression.this.textExpression.getCaretPosition();
                    if (text.isEmpty()) {
                        WTextExpression.this.setExpression(null);
                    } else {
                        WTextExpression.this.setExpression(new JRDesignExpression(text));
                    }
                }
            }
        });
        this.textExpression.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (WTextExpression.this.traverseOnTab && e.detail == 16 || e.detail == 8) {
                    boolean isCtrl;
                    boolean bl = isCtrl = e.stateMask == 262144;
                    if (!isCtrl) {
                        e.doit = true;
                    } else {
                        e.doit = false;
                        String currentValue = WTextExpression.this.textExpression.getText();
                        Point selection = WTextExpression.this.textExpression.getSelection();
                        String firstPart = currentValue.substring(0, selection.x);
                        String secondPart = currentValue.substring(selection.y);
                        currentValue = String.valueOf(firstPart) + '\t' + secondPart;
                        WTextExpression.this.textExpression.setText(currentValue);
                        WTextExpression.this.oldpos = selection.x;
                        WTextExpression.this.textExpression.setSelection(selection.x + 1);
                    }
                } else {
                    e.doit = false;
                }
            }
        });
    }

    protected void createLabelControl(String textLabel, int showMode) {
        if (textLabel != null && (showMode == 1 || showMode == 2)) {
            this.label = new Label((Composite)this, 0);
            this.label.setText(textLabel);
        } else {
            showMode = 0;
        }
    }

    protected void createButtonControl() {
        this.btnEditExpression = new Button((Composite)this, 0x800000);
        this.btnEditExpression.setImage(JaspersoftStudioPlugin.getInstance().getImage(BUTTON_ICON_PATH));
        this.btnEditExpression.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    wizard.setValue(WTextExpression.this.expression);
                    wizard.setExpressionContext(WTextExpression.this.expContext);
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(WTextExpression.this.getShell(), wizard);
                    if (dialog.open() == 0) {
                        JRDesignExpression value = wizard.getValue();
                        WTextExpression.this.setExpression(value);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void configureWidgetsLayoutData(int showMode) {
        int heightHint = UIUtil.getCharHeight((Drawable)this.textExpression);
        if (showMode == 1) {
            FormData fd_label = new FormData();
            fd_label.top = new FormAttachment(0, 3);
            fd_label.left = new FormAttachment(0);
            this.label.setLayoutData((Object)fd_label);
            FormData fd_btnEditExpression = new FormData();
            fd_btnEditExpression.top = new FormAttachment(0);
            fd_btnEditExpression.right = new FormAttachment(100);
            this.btnEditExpression.setLayoutData((Object)fd_btnEditExpression);
            FormData fd_textExpression = new FormData();
            fd_textExpression.bottom = new FormAttachment(100);
            fd_textExpression.top = new FormAttachment((Control)this.label, -3, 128);
            fd_textExpression.right = new FormAttachment((Control)this.btnEditExpression, -5, 16384);
            fd_textExpression.left = new FormAttachment((Control)this.label, 5);
            fd_textExpression.height = heightHint;
            this.textExpression.setLayoutData((Object)fd_textExpression);
        } else if (showMode == 2) {
            FormData fd_label = new FormData();
            fd_label.left = new FormAttachment(0);
            fd_label.right = new FormAttachment(100);
            fd_label.top = new FormAttachment(0);
            this.label.setLayoutData((Object)fd_label);
            FormData fd_btnEditExpression = new FormData();
            fd_btnEditExpression.top = new FormAttachment((Control)this.label, 5);
            fd_btnEditExpression.right = new FormAttachment((Control)this.label, 0, 131072);
            this.btnEditExpression.setLayoutData((Object)fd_btnEditExpression);
            FormData fd_textExpression = new FormData();
            fd_textExpression.top = new FormAttachment((Control)this.label, 5);
            fd_textExpression.right = new FormAttachment((Control)this.btnEditExpression, -5);
            fd_textExpression.bottom = new FormAttachment(100);
            fd_textExpression.left = new FormAttachment(0);
            fd_textExpression.height = heightHint;
            this.textExpression.setLayoutData((Object)fd_textExpression);
        } else {
            final FormData fd_textExpression = new FormData();
            fd_textExpression.bottom = new FormAttachment(100);
            fd_textExpression.top = new FormAttachment(0);
            fd_textExpression.left = new FormAttachment(0);
            fd_textExpression.right = new FormAttachment((Control)this.btnEditExpression, -5);
            fd_textExpression.height = heightHint;
            this.textExpression.setLayoutData((Object)fd_textExpression);
            FormData fd_btnEditExpression = new FormData();
            fd_btnEditExpression.right = new FormAttachment(100);
            fd_btnEditExpression.top = new FormAttachment(0);
            this.btnEditExpression.setLayoutData((Object)fd_btnEditExpression);
            fd_textExpression.width = this.textExpression.getBounds().width / 2;
            this.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    fd_textExpression.width = WTextExpression.this.textExpression.getBounds().width / 2;
                    WTextExpression.this.layout();
                }
            });
        }
    }

    public void setExpression(JRDesignExpression exp) {
        this.isRefreshing = true;
        this.expression = exp;
        if (exp != null && !exp.getText().equals(this.textExpression.getText())) {
            this.textExpression.setText(exp.getText());
            this.textExpression.setToolTipText(exp.getText());
            if (exp.getText().length() >= this.oldpos) {
                this.textExpression.setSelection(this.oldpos, this.oldpos);
            }
        } else if (exp == null && !this.textExpression.getText().isEmpty()) {
            this.textExpression.setText("");
            this.textExpression.setToolTipText("");
        }
        this.fireModifyEvent();
        this.isRefreshing = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textExpression.setEnabled(enabled);
        this.btnEditExpression.setEnabled(enabled);
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
    }

    public JRDesignExpression getExpression() {
        return this.expression;
    }

    protected int getTextLinesNumber() {
        if (this.customTextLinesNumber > 0) {
            return this.customTextLinesNumber;
        }
        return 3;
    }

    public String getText() {
        return this.expression == null ? "" : Misc.nvl((String)this.getExpression().getText());
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public ExpressionContext getExpressionContext() {
        return this.expContext;
    }

    public void addModifyListener(ExpressionModifiedListener ml) {
        this.listeners.add(ml);
    }

    public void removeModifyListener(ExpressionModifiedListener ml) {
        this.listeners.remove(ml);
    }

    public Text getTextControl() {
        return this.textExpression;
    }

    private void fireModifyEvent() {
        ExpressionModifiedEvent event = new ExpressionModifiedEvent((Widget)this);
        event.modifiedExpression = this.expression;
        for (ExpressionModifiedListener ml : this.listeners) {
            ml.expressionModified(event);
        }
    }

    public void dispose() {
        Object[] listenersArray;
        Object[] objectArray = listenersArray = this.listeners.toArray();
        int n = listenersArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            this.removeModifyListener((ExpressionModifiedListener)l);
            ++n2;
        }
        this.listeners.clear();
        this.listeners = null;
        super.dispose();
    }

    public void setTraverseOnTab(boolean value) {
        this.traverseOnTab = value;
    }

    public boolean isTraverseOnTab() {
        return this.traverseOnTab;
    }
}

