/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets.table;

import com.jaspersoft.studio.messages.Messages;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DeleteButton {
    private boolean confirm = false;
    private Button delB;
    private int minSize = 0;

    protected boolean confirmDelete(Object obj) {
        if (this.confirm && !UIUtils.showDeleteConfirmation((Shell)this.delB.getShell(), (String)net.sf.jasperreports.eclipse.messages.Messages.UIUtils_3)) {
            return false;
        }
        return this.canRemove(obj);
    }

    protected boolean canRemove(Object obj) {
        return true;
    }

    public void createDeleteButton(Composite composite, TableViewer tableViewer, boolean confirm) {
        this.confirm = confirm;
        this.createDeleteButton(composite, tableViewer);
    }

    public void createDeleteButton(Composite composite, final TableViewer tableViewer) {
        this.delB = new Button(composite, 8);
        this.delB.setText(Messages.common_delete);
        this.delB.setLayoutData((Object)new GridData(770));
        final DeleteListener listener = new DeleteListener(tableViewer);
        this.delB.addSelectionListener((SelectionListener)listener);
        this.setEnabledState(tableViewer);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DeleteButton.this.setEnabledState(tableViewer);
            }
        });
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (DeleteButton.this.delB.isEnabled() && (e.keyCode == 127 || e.keyCode == 8)) {
                    listener.widgetSelected(null);
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.delB.setEnabled(enabled);
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    private void setEnabledState(TableViewer tableViewer) {
        boolean enable = true;
        StructuredSelection s = (StructuredSelection)tableViewer.getSelection();
        List inlist = (List)tableViewer.getInput();
        if (inlist != null && inlist.size() > this.minSize && !s.isEmpty()) {
            Object[] objectArray = s.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (!this.canRemove(obj)) {
                    enable = false;
                    break;
                }
                ++n2;
            }
        } else {
            enable = false;
        }
        this.delB.setEnabled(enable);
    }

    protected void afterElementDeleted(Object element) {
    }

    private final class DeleteListener
    extends SelectionAdapter {
        private TableViewer tableViewer;

        private DeleteListener(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection s = (StructuredSelection)this.tableViewer.getSelection();
            Object selement = null;
            if (!s.isEmpty()) {
                List inlist = (List)this.tableViewer.getInput();
                boolean c = DeleteButton.this.confirm;
                try {
                    Object[] objectArray = s.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        boolean confirmDelete = DeleteButton.this.confirmDelete(obj);
                        DeleteButton.this.confirm = false;
                        if (!confirmDelete) {
                            return;
                        }
                        int ind = inlist.indexOf(obj);
                        inlist.remove(obj);
                        DeleteButton.this.afterElementDeleted(obj);
                        if (ind < inlist.size()) {
                            selement = inlist.get(ind);
                        }
                        ++n2;
                    }
                }
                finally {
                    DeleteButton.this.confirm = c;
                }
                this.tableViewer.refresh();
                if (selement != null) {
                    this.tableViewer.setSelection((ISelection)new StructuredSelection(selement));
                }
            }
        }
    }
}

