/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.swt.widgets.table;

import com.jaspersoft.studio.swt.events.ChangeEvent;
import com.jaspersoft.studio.swt.events.ChangeListener;
import com.jaspersoft.studio.utils.GridDataUtil;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class MoveT2TButtons {
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().changed(ev);
        }
    }

    protected void handleMove(ColumnViewer leftTView, ColumnViewer rightTView) {
        StructuredSelection s = (StructuredSelection)leftTView.getSelection();
        if (!s.isEmpty()) {
            List left = (List)leftTView.getInput();
            List right = (List)rightTView.getInput();
            if (left == null) {
                leftTView.setInput(new ArrayList());
            }
            if (right == null) {
                rightTView.setInput(new ArrayList());
            }
            Object[] objectArray = s.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                left.remove(obj);
                right.add(obj);
                ++n2;
            }
            leftTView.refresh();
            rightTView.refresh();
            this.fireChangeEvent();
        }
    }

    protected void handleMoveAll(ColumnViewer leftTView, ColumnViewer rightTView) {
        List left = (List)leftTView.getInput();
        List right = (List)rightTView.getInput();
        for (Object obj : left) {
            right.add(obj);
        }
        left.clear();
        leftTView.refresh();
        rightTView.refresh();
        this.fireChangeEvent();
    }

    public void createButtons(Composite composite, ColumnViewer leftTView, TableViewer rightTView) {
        Button addField = new Button(composite, 8);
        int chw = UIUtil.getCharWidth((Drawable)addField) * 7;
        addField.setText(" > ");
        GridData gd = new GridData(768);
        gd.widthHint = chw;
        addField.setLayoutData((Object)gd);
        addField.addSelectionListener((SelectionListener)new MoveListener(leftTView, (ColumnViewer)rightTView));
        Button addFields = new Button(composite, 8);
        addFields.setText(">>");
        addFields.setLayoutData((Object)GridDataUtil.clone(gd));
        addFields.addSelectionListener((SelectionListener)new MoveAllListener(leftTView, (ColumnViewer)rightTView));
        Button delField = new Button(composite, 8);
        delField.setText(" < ");
        delField.setLayoutData((Object)GridDataUtil.clone(gd));
        delField.addSelectionListener((SelectionListener)new MoveListener((ColumnViewer)rightTView, leftTView));
        Button delFields = new Button(composite, 8);
        delFields.setText("<<");
        delFields.setLayoutData((Object)GridDataUtil.clone(gd));
        delFields.addSelectionListener((SelectionListener)new MoveAllListener((ColumnViewer)rightTView, leftTView));
        leftTView.addDoubleClickListener((IDoubleClickListener)new MoveListener(leftTView, (ColumnViewer)rightTView));
        rightTView.addDoubleClickListener((IDoubleClickListener)new MoveListener((ColumnViewer)rightTView, leftTView));
    }

    public void createButtonsShort(Composite composite, ColumnViewer leftTView, TableViewer rightTView, boolean doubleClick) {
        Button addField = new Button(composite, 8);
        int chw = UIUtil.getCharWidth((Drawable)addField) * 7;
        addField.setText(">");
        GridData gd = new GridData(768);
        gd.widthHint = chw;
        addField.setLayoutData((Object)gd);
        addField.addSelectionListener((SelectionListener)new MoveListener(leftTView, (ColumnViewer)rightTView));
        Button delField = new Button(composite, 8);
        delField.setText("<");
        delField.setLayoutData((Object)GridDataUtil.clone(gd));
        delField.addSelectionListener((SelectionListener)new MoveListener((ColumnViewer)rightTView, leftTView));
        if (doubleClick) {
            leftTView.addDoubleClickListener((IDoubleClickListener)new MoveListener(leftTView, (ColumnViewer)rightTView));
            rightTView.addDoubleClickListener((IDoubleClickListener)new MoveListener((ColumnViewer)rightTView, leftTView));
        }
    }

    private final class MoveAllListener
    implements SelectionListener {
        private final ColumnViewer leftTView;
        private final ColumnViewer rightTView;

        private MoveAllListener(ColumnViewer leftTView, ColumnViewer rightTView) {
            this.leftTView = leftTView;
            this.rightTView = rightTView;
        }

        public void widgetSelected(SelectionEvent e) {
            MoveT2TButtons.this.handleMoveAll(this.leftTView, this.rightTView);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class MoveListener
    implements SelectionListener,
    IDoubleClickListener {
        private final ColumnViewer leftTView;
        private final ColumnViewer rightTView;

        private MoveListener(ColumnViewer leftTView, ColumnViewer rightTView) {
            this.leftTView = leftTView;
            this.rightTView = rightTView;
        }

        public void widgetSelected(SelectionEvent e) {
            MoveT2TButtons.this.handleMove(this.leftTView, this.rightTView);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            MoveT2TButtons.this.handleMove(this.leftTView, this.rightTView);
        }

        public void doubleClick(DoubleClickEvent event) {
            MoveT2TButtons.this.handleMove(this.leftTView, this.rightTView);
        }
    }
}

