/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.templates;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.templates.JrxmlTemplateBundle;
import com.jaspersoft.studio.templates.TemplateProvider;
import com.jaspersoft.studio.templates.engine.DefaultTemplateEngine;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.templates.TemplateBundle;
import com.jaspersoft.templates.TemplateLoadingException;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DefaultTemplateProvider
implements TemplateProvider {
    public static List<TemplateBundle> cache = null;
    public static final String defaultEngineKey = "default";

    @Override
    public List<TemplateBundle> getTemplateBundles() {
        ArrayList<TemplateBundle> templates = new ArrayList<TemplateBundle>();
        if (cache == null) {
            cache = new ArrayList<TemplateBundle>();
            Enumeration en = JaspersoftStudioPlugin.getInstance().getBundle().findEntries("templates", "*.jrxml", false);
            while (en.hasMoreElements()) {
                URL templateURL = (URL)en.nextElement();
                try {
                    JrxmlTemplateBundle bundle = new JrxmlTemplateBundle(templateURL, (JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
                    if (bundle == null) continue;
                    cache.add(bundle);
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.jaspersoft.studio", MessageFormat.format(Messages.DefaultTemplateProvider_TemplateLoadingErr, templateURL), (Throwable)ex));
                }
            }
        }
        templates.addAll(cache);
        this.loadAdditionalTemplateBundles(templates);
        return templates;
    }

    private void loadAdditionalTemplateBundles(List<TemplateBundle> templates) {
        String paths = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("TEMPLATES_LOCATIONS_LIST");
        StringTokenizer st = new StringTokenizer(paths, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<String> pathsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            pathsList.add(st.nextToken());
        }
        for (String dir : pathsList) {
            File[] files = new File(dir).listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(".jrxml");
                }
            });
            if (files == null) continue;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    JrxmlTemplateBundle bundle = new JrxmlTemplateBundle(f.toURI().toURL(), true, (JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
                    Object engine = bundle.getProperty("template.engine");
                    if (bundle != null && (engine == null || defaultEngineKey.equals(engine.toString().toLowerCase()))) {
                        templates.add(bundle);
                    }
                }
                catch (TemplateLoadingException ex) {
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.jaspersoft.studio", MessageFormat.format(Messages.DefaultTemplateProvider_TemplateLoadingErr, f.getAbsolutePath()), (Throwable)ex));
                }
                ++n2;
            }
        }
    }

    @Override
    public String getProviderKey() {
        return defaultEngineKey;
    }

    @Override
    public String getProviderName() {
        return "Standard Report";
    }

    @Override
    public List<String> validateTemplate(JasperReportsContext jrContext, JasperDesign design) {
        return DefaultTemplateEngine.validateJasperDesig(design);
    }
}

