/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.toolitems.ToolItemsSet;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubCoolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorPart;

public abstract class CommonToolbarHandler
extends ContributionItem {
    public static String WIDGET_DATA_KEY = "OPERATION";
    private static HashMap<String, CommonToolbarHandler> cachedContributionElements = new HashMap();
    @Deprecated
    private ToolItem mainControl = null;
    private List<ToolItem> toolItems = null;
    private IEditorPart workbenchPart = null;

    public static void updateSelection(IEditorPart activeEditor, IActionBars bars) {
        UIUtils.checkUIThread();
        if (UIUtil.shouldTrickToolbar()) {
            CommonToolbarHandler.clearToolbars(bars);
        }
        if (bars instanceof IActionBars2 && ((IActionBars2)bars).getCoolBarManager() instanceof SubCoolBarManager) {
            ICoolBarManager cbm = (ICoolBarManager)((SubCoolBarManager)((IActionBars2)bars).getCoolBarManager()).getParent();
            for (ToolItemsSet toolbar : JaspersoftStudioPlugin.getToolItemsManager().getSets()) {
                boolean isToolbarVisible = false;
                ArrayList<CommonToolbarHandler> visibleControls = new ArrayList<CommonToolbarHandler>();
                ArrayList<IContributionItem> notVisibleControls = new ArrayList<IContributionItem>();
                for (IConfigurationElement control : toolbar.getControlsConfiguration()) {
                    CommonToolbarHandler citem = CommonToolbarHandler.createContributionItem(control);
                    citem.setWorkbenchPart(activeEditor);
                    if (citem.isVisible()) {
                        visibleControls.add(citem);
                        isToolbarVisible = true;
                        continue;
                    }
                    notVisibleControls.add((IContributionItem)citem);
                }
                if (!isToolbarVisible) {
                    CommonToolbarHandler.removeToolbar(cbm, toolbar.getId());
                    continue;
                }
                CommonToolbarHandler.removeToolbarContribution(cbm, toolbar.getId(), notVisibleControls);
                CommonToolbarHandler.addContributionsToCoolbar(cbm, toolbar.getId(), visibleControls);
            }
            if (!UIUtil.shouldTrickToolbar()) {
                cbm.update(true);
                bars.updateActionBars();
            }
        }
    }

    public static void clearToolbars(IActionBars bars) {
        if (bars instanceof IActionBars2 && ((IActionBars2)bars).getCoolBarManager() instanceof SubCoolBarManager) {
            ICoolBarManager cbm = (ICoolBarManager)((SubCoolBarManager)((IActionBars2)bars).getCoolBarManager()).getParent();
            for (ToolItemsSet toolbar : JaspersoftStudioPlugin.getToolItemsManager().getSets()) {
                CommonToolbarHandler.removeToolbar(cbm, toolbar.getId());
            }
            cbm.update(true);
            bars.updateActionBars();
        }
    }

    protected CommandStack getCommandStack() {
        return (CommandStack)this.workbenchPart.getAdapter(CommandStack.class);
    }

    protected List<Object> getSelectionForType(Class<?> type) {
        if (this.workbenchPart instanceof CachedSelectionProvider) {
            return ((CachedSelectionProvider)this.workbenchPart).getSelectionCache().getSelectionModelForType(type);
        }
        return new ArrayList<Object>();
    }

    public ISelection getLastRawSelection() {
        return ((CachedSelectionProvider)this.workbenchPart).getSelectionCache().getLastRawSelection();
    }

    private static void addContributionsToCoolbar(ICoolBarManager cbm2, String toolBarID, List<CommonToolbarHandler> elementsToAdd) {
        IContributionItem item = CommonToolbarHandler.getToolbarContributionItem(cbm2, toolBarID);
        if (item != null) {
            ToolBarContributionItem tbitem = (ToolBarContributionItem)item;
            IToolBarManager tbmanager = tbitem.getToolBarManager();
            if (tbitem.getToolBarManager() != null) {
                for (CommonToolbarHandler elementToAdd : elementsToAdd) {
                    String id = elementToAdd.getId();
                    if (id == null || CommonToolbarHandler.isElementPresentInToolbar(tbitem, elementToAdd)) continue;
                    tbmanager.add((IContributionItem)elementToAdd);
                }
                tbmanager.update(true);
            }
        }
    }

    private static boolean isElementPresentInToolbar(ToolBarContributionItem toolbar, CommonToolbarHandler itemToCheck) {
        IContributionItem[] iContributionItemArray = toolbar.getToolBarManager().getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item.getId().equals(itemToCheck.getId())) {
                if (!item.getClass().equals(((Object)((Object)itemToCheck)).getClass())) {
                    toolbar.getToolBarManager().remove(item);
                    item.dispose();
                    return false;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static CommonToolbarHandler createContributionItem(IConfigurationElement element) {
        try {
            String id = element.getAttribute("id");
            CommonToolbarHandler handler = cachedContributionElements.get(id);
            if (handler == null && id != null) {
                Object newObject = element.createExecutableExtension("class");
                handler = (CommonToolbarHandler)((Object)newObject);
                handler.setId(id);
                cachedContributionElements.put(id, handler);
            }
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IContributionItem getToolbarContributionItem(ICoolBarManager coolbar, String toolbarId) {
        IContributionItem item = CommonToolbarHandler.findToolbar(coolbar, toolbarId);
        if (item == null) {
            item = new ToolBarContributionItem((IToolBarManager)new ToolBarManager(), toolbarId);
            coolbar.appendToGroup("group.editor", item);
        }
        return item;
    }

    public static IContributionItem findToolbar(ICoolBarManager cbm2, String tbarid) {
        if (tbarid != null) {
            IContributionItem[] iContributionItemArray = cbm2.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem ci = iContributionItemArray[n2];
                if (tbarid.equals(ci.getId())) {
                    return ci;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void removeToolbar(ICoolBarManager cbm2, String tbarid) {
        IToolBarManager tbmanager;
        IContributionItem ictb = CommonToolbarHandler.findToolbar(cbm2, tbarid);
        if (ictb instanceof ToolBarContributionItem && (tbmanager = ((ToolBarContributionItem)ictb).getToolBarManager()) != null) {
            IContributionItem[] iContributionItemArray = tbmanager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem ci = iContributionItemArray[n2];
                tbmanager.remove(ci);
                ci.dispose();
                ++n2;
            }
            tbmanager.update(true);
        }
    }

    public static void removeToolbarContribution(ICoolBarManager cbm, String toolbarId, List<IContributionItem> itemsToRemove) {
        IContributionItem ictb = CommonToolbarHandler.findToolbar(cbm, toolbarId);
        if (ictb instanceof ToolBarContributionItem) {
            HashSet<String> itemsToRemoveIds = new HashSet<String>();
            for (IContributionItem itemToRemove : itemsToRemove) {
                itemsToRemoveIds.add(itemToRemove.getId());
            }
            IToolBarManager tbmanager = ((ToolBarContributionItem)ictb).getToolBarManager();
            if (tbmanager != null) {
                IContributionItem[] iContributionItemArray = tbmanager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem ci = iContributionItemArray[n2];
                    if (itemsToRemove.isEmpty()) break;
                    if (itemsToRemoveIds.contains(ci.getId())) {
                        tbmanager.remove(ci);
                        ci.dispose();
                        itemsToRemoveIds.remove(ci.getId());
                    }
                    ++n2;
                }
                tbmanager.update(true);
            }
        }
    }

    public boolean isVisible() {
        return JaspersoftStudioPlugin.getToolItemsManager().isToolbarVisible(this.getId());
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    protected boolean fillWithToolItems(ToolBar parent) {
        return false;
    }

    protected void setWorkbenchPart(IEditorPart workbenchPart) {
        this.workbenchPart = workbenchPart;
    }

    public IEditorPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    public void dispose() {
        super.dispose();
        if (this.mainControl != null) {
            if (!this.mainControl.isDisposed()) {
                if (this.mainControl.getControl() != null) {
                    this.mainControl.getControl().dispose();
                }
                this.mainControl.dispose();
            }
            this.mainControl = null;
        }
        for (ToolItem ti : this.getToolItems()) {
            if (ti.isDisposed()) continue;
            if (ti.getControl() != null) {
                ti.getControl().dispose();
            }
            ti.dispose();
        }
        this.getToolItems().clear();
    }

    public final void fill(ToolBar parent, int index) {
        if (UIUtil.shouldTrickToolbar()) {
            this.fillWithToolItems(parent);
        } else {
            Control control = this.createControl((Composite)parent);
            if (control == null) {
                Policy.logException((Exception)new IllegalStateException("createControl(Composite) of " + ((Object)((Object)this)).getClass() + " returned null, cannot fill toolbar"));
            } else {
                ToolItem ti = new ToolItem(parent, 2, index);
                ti.setControl(control);
                ti.setWidth(this.computeWidth(control));
                this.mainControl = ti;
            }
        }
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    public List<ToolItem> getToolItems() {
        if (this.toolItems == null) {
            this.toolItems = new ArrayList<ToolItem>();
        }
        return this.toolItems;
    }
}

