/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars.alignment;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.commands.AlignCommand;
import com.jaspersoft.studio.formatting.actions.JoinLeftAction;
import com.jaspersoft.studio.formatting.actions.JoinRightAction;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

public abstract class AbstractAlignmentContributionItem
extends CommonToolbarHandler {
    protected SelectionAdapter alignButtonPressed = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            List selection = AbstractAlignmentContributionItem.this.getSelectionForType(MGraphicElement.class);
            if (selection.isEmpty()) {
                return;
            }
            Integer alignment = (Integer)e.widget.getData(WIDGET_DATA_KEY);
            JSSCompoundCommand command = new JSSCompoundCommand("Align Command", null);
            for (Object model : selection) {
                command.add(new AlignCommand((int)alignment, (MGraphicElement)model));
                command.setReferenceNodeIfNull(model);
            }
            AbstractAlignmentContributionItem.this.getCommandStack().execute((Command)command);
        }
    };
    protected SelectionAdapter joinButtonPressed = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            List selection = AbstractAlignmentContributionItem.this.getSelectionForType(MGraphicElement.class);
            if (selection.isEmpty()) {
                return;
            }
            JSSCompoundCommand command = null;
            List typedSelection = selection;
            if (JOIN_DIRECTION.LEFT.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                command = JoinLeftAction.generateCommand(typedSelection);
            } else if (JOIN_DIRECTION.RIGHT.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                command = JoinRightAction.generateCommand(typedSelection);
            }
            if (command != null) {
                AbstractAlignmentContributionItem.this.getCommandStack().execute((Command)command);
            }
        }
    };

    @Override
    protected abstract Control createControl(Composite var1);

    @Override
    protected abstract boolean fillWithToolItems(ToolBar var1);

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        List<Object> selection = this.getSelectionForType(MGraphicElement.class);
        return selection.size() > 0;
    }

    protected static enum JOIN_DIRECTION {
        LEFT,
        RIGHT;

    }
}

