/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars.order;

import com.ibm.icu.text.MessageFormat;
import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.selection.SelectElementsByValueCommand;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.editor.outline.actions.HideDefaultVariablesAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.model.variable.MVariableSystem;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

public abstract class AbstractOrderContributionItem
extends CommonToolbarHandler {
    protected SelectionAdapter pushButtonPressed = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean proceed;
            List selection = AbstractOrderContributionItem.this.getSelectionForType(ANode.class);
            if (selection.isEmpty()) {
                return;
            }
            CompoundCommand compoundCmd = null;
            if (ORDER_TYPE.FORWARD.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                compoundCmd = AbstractOrderContributionItem.this.generateBringForwardCommand(selection);
            } else if (ORDER_TYPE.BACKWARD.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                compoundCmd = AbstractOrderContributionItem.this.generateBringBackwardCommand(selection);
            } else if (ORDER_TYPE.TOP.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                compoundCmd = AbstractOrderContributionItem.this.generateBringTopCommand(selection);
            } else if (ORDER_TYPE.BOTTOM.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                compoundCmd = AbstractOrderContributionItem.this.generateBringBottomCommand(selection);
            } else if (ORDER_TYPE.BOTTOM.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                compoundCmd = AbstractOrderContributionItem.this.generateBringBottomCommand(selection);
            } else if (ORDER_TYPE.SORT_FIELDS.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                compoundCmd = AbstractOrderContributionItem.this.sortFieldsCommand(selection);
            } else if (ORDER_TYPE.SORT_PARAMETERS.equals(e.widget.getData(WIDGET_DATA_KEY))) {
                proceed = UIUtils.showConfirmation((String)Messages.OrderContributionItem_confTitle, (String)MessageFormat.format((String)Messages.OrderContributionItem_confMessage, (Object[])new Object[]{Messages.OrderContributionItem_paramName}));
                if (proceed) {
                    compoundCmd = AbstractOrderContributionItem.this.sortParametersCommand(selection);
                }
            } else if (ORDER_TYPE.SORT_VARIABLES.equals(e.widget.getData(WIDGET_DATA_KEY)) && (proceed = UIUtils.showConfirmation((String)Messages.OrderContributionItem_confTitle, (String)MessageFormat.format((String)Messages.OrderContributionItem_confMessage, (Object[])new Object[]{Messages.OrderContributionItem_varName})))) {
                compoundCmd = AbstractOrderContributionItem.this.sortVariablesCommand(selection);
            }
            if (compoundCmd != null && compoundCmd.canExecute()) {
                CommandStack cs = AbstractOrderContributionItem.this.getCommandStack();
                cs.execute((Command)compoundCmd);
            }
        }
    };

    @Override
    protected abstract Control createControl(Composite var1);

    @Override
    protected abstract boolean fillWithToolItems(ToolBar var1);

    private CompoundCommand generateBringForwardCommand(List<Object> selection) {
        CompoundCommand compoundCmd = new CompoundCommand("Move Elements");
        JSSCompoundCommand sortCommand = new JSSCompoundCommand("Move elements", null);
        Command cmd = null;
        ArrayList<Object> movedElements = new ArrayList<Object>();
        EditPartViewer viewer = null;
        for (Object model : selection) {
            ANode currentElement = (ANode)model;
            ANode parent = currentElement.getParent();
            sortCommand.setReferenceNodeIfNull(parent);
            if (parent == null || parent.getChildren() == null) continue;
            int newIndex = parent.getChildren().indexOf(model) + 1;
            if (newIndex < parent.getChildren().size()) {
                EditPart part;
                cmd = OutlineTreeEditPartFactory.getReorderCommand((ANode)model, parent, newIndex);
                if (cmd == null || !cmd.canExecute()) continue;
                movedElements.add(currentElement.getValue());
                if (viewer == null && (part = SelectionHelper.getEditPart(currentElement)) != null) {
                    viewer = part.getViewer();
                }
                sortCommand.add(cmd);
                continue;
            }
            return null;
        }
        compoundCmd.add((Command)sortCommand);
        compoundCmd.add((Command)new SelectElementsByValueCommand(movedElements, viewer));
        return compoundCmd;
    }

    private CompoundCommand generateBringBackwardCommand(List<Object> selection) {
        CompoundCommand compoundCmd = new CompoundCommand("Move Elements");
        JSSCompoundCommand sortCommand = new JSSCompoundCommand("Move elements", null);
        Command cmd = null;
        ArrayList<Object> movedElements = new ArrayList<Object>();
        EditPartViewer viewer = null;
        for (Object model : selection) {
            ANode currentElement = (ANode)model;
            ANode parent = currentElement.getParent();
            sortCommand.setReferenceNodeIfNull(parent);
            if (parent == null) {
                return null;
            }
            int newIndex = parent.getChildren().indexOf(model) - 1;
            if (newIndex >= 0) {
                EditPart part;
                cmd = OutlineTreeEditPartFactory.getReorderCommand((ANode)model, parent, newIndex);
                if (cmd == null || !cmd.canExecute()) continue;
                movedElements.add(currentElement.getValue());
                if (viewer == null && (part = SelectionHelper.getEditPart(currentElement)) != null) {
                    viewer = part.getViewer();
                }
                sortCommand.add(cmd);
                continue;
            }
            return null;
        }
        compoundCmd.add((Command)sortCommand);
        compoundCmd.add((Command)new SelectElementsByValueCommand(movedElements, viewer));
        return compoundCmd;
    }

    private CompoundCommand generateBringTopCommand(List<Object> selection) {
        CompoundCommand compoundCmd = new CompoundCommand("Move Elements");
        JSSCompoundCommand sortCommand = new JSSCompoundCommand("Move elements", null);
        Command cmd = null;
        int j = 0;
        ArrayList<Object> movedElements = new ArrayList<Object>();
        EditPartViewer viewer = null;
        for (Object model : selection) {
            ANode currentElement = (ANode)model;
            ANode parent = currentElement.getParent();
            sortCommand.setReferenceNodeIfNull(parent);
            if (parent == null) continue;
            int newIndex = parent.getChildren().size() - 1;
            if (parent.getChildren().indexOf(currentElement) < parent.getChildren().size() - 1) {
                EditPart part;
                cmd = OutlineTreeEditPartFactory.getReorderCommand(currentElement, parent, newIndex - j);
                ++j;
                if (cmd == null || !cmd.canExecute()) continue;
                movedElements.add(currentElement.getValue());
                if (viewer == null && (part = SelectionHelper.getEditPart(currentElement)) != null) {
                    viewer = part.getViewer();
                }
                sortCommand.add(cmd);
                continue;
            }
            return null;
        }
        compoundCmd.add((Command)sortCommand);
        compoundCmd.add((Command)new SelectElementsByValueCommand(movedElements, viewer));
        return compoundCmd;
    }

    protected boolean checkWidgetVisible() {
        return super.isVisible();
    }

    private boolean checkSelectedDatasetType() {
        return this.areParameters() || this.areVariables() || this.areFields();
    }

    @Override
    public boolean isVisible() {
        if (!this.checkWidgetVisible()) {
            return false;
        }
        List<Object> selection = this.getSelectionForType(MGraphicElement.class);
        if (selection.size() == 0) {
            return this.checkSelectedDatasetType();
        }
        return true;
    }

    private Command sortParametersCommand(List<Object> selection) {
        Object firstNode = selection.get(0);
        MParameters parameters = null;
        if (firstNode instanceof MParameters) {
            parameters = (MParameters)firstNode;
        } else if (firstNode instanceof MParameter) {
            parameters = (MParameters)((ANode)firstNode).getParent();
        }
        if (parameters != null) {
            EditPart part = SelectionHelper.getEditPart(parameters);
            EditPartViewer viewer = part.getViewer();
            ArrayList<INode> children = new ArrayList<INode>(parameters.getChildren());
            Collections.sort(children, new Comparator<INode>(){

                @Override
                public int compare(INode o1, INode o2) {
                    MParameterSystem var1 = (MParameterSystem)o1;
                    MParameterSystem var2 = (MParameterSystem)o2;
                    String nameVar1 = (String)var1.getPropertyActualValue("name");
                    String nameVar2 = (String)var2.getPropertyActualValue("name");
                    return nameVar1.toLowerCase().compareTo(nameVar2.toLowerCase());
                }
            });
            JSSCompoundCommand sortParametersCommand = new JSSCompoundCommand("Sort Parameters", (ANode)parameters);
            int systemOffset = 0;
            JasperReportsConfiguration jrContext = parameters.getJasperConfiguration();
            boolean showDefaults = jrContext != null ? jrContext.getPropertyBoolean("showVariablesDefault", Boolean.TRUE) : true;
            boolean bl = showDefaults = showDefaults && !HideDefaultVariablesAction.areDefaultVariablesHidden(jrContext);
            if (showDefaults) {
                JRDesignDataset jrDataset = ModelUtils.getDataset(parameters);
                for (JRParameter p : jrDataset.getParametersList()) {
                    if (!p.isSystemDefined()) break;
                    ++systemOffset;
                }
            }
            int j = 0;
            for (INode node : children) {
                Command sortCommand;
                if (node.getClass().equals(MParameterSystem.class) || (sortCommand = OutlineTreeEditPartFactory.getReorderCommand((ANode)node, parameters, j + systemOffset)) == null) continue;
                sortParametersCommand.add(sortCommand);
                ++j;
            }
            if (!sortParametersCommand.isEmpty()) {
                CompoundCommand cmd = new CompoundCommand("Sort Parameters");
                cmd.add((Command)sortParametersCommand);
                cmd.add((Command)new SelectElementsByValueCommand(selection, viewer));
                return cmd;
            }
        }
        return null;
    }

    private Command sortVariablesCommand(List<Object> selection) {
        Object firstNode = selection.get(0);
        MVariables variables = null;
        if (firstNode instanceof MVariables) {
            variables = (MVariables)firstNode;
        } else if (firstNode instanceof MVariable) {
            variables = (MVariables)((ANode)firstNode).getParent();
        }
        if (variables != null) {
            EditPart part = SelectionHelper.getEditPart(variables);
            EditPartViewer viewer = part.getViewer();
            ArrayList<INode> children = new ArrayList<INode>(variables.getChildren());
            Collections.sort(children, new Comparator<INode>(){

                @Override
                public int compare(INode o1, INode o2) {
                    MVariableSystem var1 = (MVariableSystem)o1;
                    MVariableSystem var2 = (MVariableSystem)o2;
                    String nameVar1 = (String)var1.getPropertyActualValue("name");
                    String nameVar2 = (String)var2.getPropertyActualValue("name");
                    return nameVar1.toLowerCase().compareTo(nameVar2.toLowerCase());
                }
            });
            JSSCompoundCommand sortParametersCommand = new JSSCompoundCommand("Sort Variables", (ANode)variables);
            int systemOffset = 0;
            JasperReportsConfiguration jrContext = variables.getJasperConfiguration();
            boolean showDefaults = jrContext != null ? jrContext.getPropertyBoolean("showVariablesDefault", Boolean.TRUE) : true;
            boolean bl = showDefaults = showDefaults && !HideDefaultVariablesAction.areDefaultVariablesHidden(jrContext);
            if (showDefaults) {
                JRDesignDataset jrDataset = ModelUtils.getDataset(variables);
                for (JRVariable v : jrDataset.getVariablesList()) {
                    if (!v.isSystemDefined()) break;
                    ++systemOffset;
                }
            }
            int j = 0;
            for (INode node : children) {
                Command sortCommand;
                if (node.getClass().equals(MVariableSystem.class) || (sortCommand = OutlineTreeEditPartFactory.getReorderCommand((ANode)node, variables, j + systemOffset)) == null) continue;
                sortParametersCommand.add(sortCommand);
                ++j;
            }
            if (!sortParametersCommand.isEmpty()) {
                CompoundCommand cmd = new CompoundCommand("Sort Variables");
                cmd.add((Command)sortParametersCommand);
                cmd.add((Command)new SelectElementsByValueCommand(selection, viewer));
                return cmd;
            }
        }
        return null;
    }

    private Command sortFieldsCommand(List<Object> selection) {
        Object firstNode = selection.get(0);
        MFields fields = null;
        if (firstNode instanceof MFields) {
            fields = (MFields)firstNode;
        } else if (firstNode instanceof MField) {
            fields = (MFields)((ANode)firstNode).getParent();
        }
        if (fields != null) {
            EditPart part = SelectionHelper.getEditPart(fields);
            EditPartViewer viewer = part.getViewer();
            ArrayList<INode> children = new ArrayList<INode>(fields.getChildren());
            Collections.sort(children, new Comparator<INode>(){

                @Override
                public int compare(INode o1, INode o2) {
                    MField var1 = (MField)o1;
                    MField var2 = (MField)o2;
                    String nameVar1 = (String)var1.getPropertyActualValue("name");
                    String nameVar2 = (String)var2.getPropertyActualValue("name");
                    return nameVar1.toLowerCase().compareTo(nameVar2.toLowerCase());
                }
            });
            JSSCompoundCommand sortParametersCommand = new JSSCompoundCommand("Sort Fields", (ANode)fields);
            int j = 0;
            for (INode node : children) {
                Command sortCommand = OutlineTreeEditPartFactory.getReorderCommand((ANode)node, fields, j);
                if (sortCommand == null) continue;
                sortParametersCommand.add(sortCommand);
                ++j;
            }
            if (!sortParametersCommand.isEmpty()) {
                CompoundCommand cmd = new CompoundCommand("Sort Fields");
                cmd.add((Command)sortParametersCommand);
                cmd.add((Command)new SelectElementsByValueCommand(selection, viewer));
                return cmd;
            }
        }
        return null;
    }

    private CompoundCommand generateBringBottomCommand(List<Object> selection) {
        CompoundCommand compoundCmd = new CompoundCommand("Move Elements");
        JSSCompoundCommand sortCommand = new JSSCompoundCommand("Move elements", null);
        Command cmd = null;
        int j = 0;
        ArrayList<Object> movedElements = new ArrayList<Object>();
        EditPartViewer viewer = null;
        for (Object model : selection) {
            ANode currentElement = (ANode)model;
            ANode parent = currentElement.getParent();
            sortCommand.setReferenceNodeIfNull(parent);
            if (parent != null && parent.getChildren().indexOf(model) > 0) {
                EditPart part;
                cmd = OutlineTreeEditPartFactory.getReorderCommand((ANode)model, parent, j);
                ++j;
                if (cmd == null || !cmd.canExecute()) continue;
                movedElements.add(currentElement.getValue());
                if (viewer == null && (part = SelectionHelper.getEditPart(currentElement)) != null) {
                    viewer = part.getViewer();
                }
                sortCommand.add(cmd);
                continue;
            }
            return null;
        }
        compoundCmd.add((Command)sortCommand);
        compoundCmd.add((Command)new SelectElementsByValueCommand(movedElements, viewer));
        return compoundCmd;
    }

    protected boolean areParameters() {
        List<Object> selection = this.getSelectionForType(MParameter.class);
        if (selection.size() == 0) {
            selection = this.getSelectionForType(MParameters.class);
        }
        return !selection.isEmpty();
    }

    protected boolean areVariables() {
        List<Object> selection = this.getSelectionForType(MVariable.class);
        if (selection.size() == 0) {
            selection = this.getSelectionForType(MVariables.class);
        }
        return !selection.isEmpty();
    }

    protected boolean areFields() {
        List<Object> selection = this.getSelectionForType(MField.class);
        if (selection.size() == 0) {
            selection = this.getSelectionForType(MFields.class);
        }
        return !selection.isEmpty();
    }

    protected static enum ORDER_TYPE {
        FORWARD,
        BACKWARD,
        TOP,
        BOTTOM,
        SORT_VARIABLES,
        SORT_FIELDS,
        SORT_PARAMETERS;

    }
}

