/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars.order;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.toolbars.order.AbstractOrderContributionItem;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SortOrderContributionItem
extends AbstractOrderContributionItem {
    private ToolItem sortElement;

    @Override
    protected Control createControl(Composite parent) {
        ToolBar buttons = new ToolBar(parent, 0x800040);
        this.sortElement = new ToolItem(buttons, 8);
        this.sortElement.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/eclipseapps/elcl16/sort-alpha-asc.png"));
        this.sortElement.addSelectionListener((SelectionListener)this.pushButtonPressed);
        this.setSortButtonEnablement();
        return buttons;
    }

    @Override
    protected boolean fillWithToolItems(ToolBar parent) {
        this.sortElement = new ToolItem(parent, 8);
        this.sortElement.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/eclipseapps/elcl16/sort-alpha-asc.png"));
        this.sortElement.addSelectionListener((SelectionListener)this.pushButtonPressed);
        this.setSortButtonEnablement();
        return true;
    }

    private boolean setSortButtonEnablement() {
        this.setSortElementStatus(false, Messages.OrderContributionItem_disabledtooltip, null);
        if (this.areParameters()) {
            this.setSortElementStatus(true, Messages.OrderContributionItem_paramTooltip, AbstractOrderContributionItem.ORDER_TYPE.SORT_PARAMETERS);
        } else if (this.areVariables()) {
            this.setSortElementStatus(true, Messages.OrderContributionItem_varTooltip, AbstractOrderContributionItem.ORDER_TYPE.SORT_VARIABLES);
        } else if (this.areFields()) {
            this.setSortElementStatus(true, Messages.OrderContributionItem_fieldstooltip, AbstractOrderContributionItem.ORDER_TYPE.SORT_FIELDS);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean isVisible() {
        if (!this.checkWidgetVisible()) {
            return false;
        }
        List<Object> selection = this.getSelectionForType(MGraphicElement.class);
        if (selection.size() == 0) {
            return this.setSortButtonEnablement();
        }
        this.setSortElementStatus(false, Messages.OrderContributionItem_disabledtooltip, null);
        return true;
    }

    private void setSortElementStatus(boolean enablement, String tooltip, AbstractOrderContributionItem.ORDER_TYPE type) {
        if (this.sortElement != null && !this.sortElement.isDisposed()) {
            this.sortElement.setEnabled(enablement);
            this.sortElement.setData(WIDGET_DATA_KEY, (Object)type);
            this.sortElement.setToolTipText(tooltip);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.sortElement != null) {
            this.sortElement.dispose();
            this.sortElement = null;
        }
    }
}

