/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars.text;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AbstractFontSizeButtonsContributionItem
extends CommonToolbarHandler {
    private Composite controlsArea;
    public static Integer factor = 10;
    private SelectionAdapter fontSizeButtonSelect = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            List selection = AbstractFontSizeButtonsContributionItem.this.getSelectionForType(MTextElement.class);
            if (selection.isEmpty()) {
                return;
            }
            JSSCompoundCommand cc = null;
            cc = AbstractFontSizeButtonsContributionItem.this.isIncrement() ? AbstractFontSizeButtonsContributionItem.this.createIncremenrtsCommand(true, selection) : AbstractFontSizeButtonsContributionItem.this.createIncremenrtsCommand(false, selection);
            AbstractFontSizeButtonsContributionItem.this.getCommandStack().execute((Command)cc);
        }
    };

    @Override
    protected Control createControl(Composite parent) {
        this.controlsArea = new Composite(parent, 0);
        RowLayout layout = new RowLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.controlsArea.setLayout((Layout)layout);
        ToolBar sizeButtons = new ToolBar(this.controlsArea, 0x800040);
        if (this.isIncrement()) {
            this.createFontSizeButton(true, sizeButtons);
        } else {
            this.createFontSizeButton(false, sizeButtons);
        }
        return this.controlsArea;
    }

    @Override
    protected boolean fillWithToolItems(ToolBar parent) {
        if (this.isIncrement()) {
            ToolItem item = this.createFontSizeButton(true, parent);
            this.getToolItems().add(item);
        } else {
            ToolItem item = this.createFontSizeButton(false, parent);
            this.getToolItems().add(item);
        }
        return true;
    }

    protected ToolItem createFontSizeButton(boolean increment, ToolBar buttons) {
        String message;
        Image imageValue;
        if (increment) {
            imageValue = JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/edit-size-up.png");
            message = MessageFormat.format(Messages.SPButon_Size_Increment, factor.toString());
        } else {
            imageValue = JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/edit-size-down.png");
            message = MessageFormat.format(Messages.SPButon_Size_Decrement, factor.toString());
        }
        ToolItem button = new ToolItem(buttons, 8);
        button.setImage(imageValue);
        button.setToolTipText(message);
        button.setData(WIDGET_DATA_KEY, (Object)"fontSize");
        button.setWidth(25);
        button.addSelectionListener((SelectionListener)this.fontSizeButtonSelect);
        return button;
    }

    protected Command createCommand(Object model, Object value, Object property) {
        if (!(model instanceof IPropertySource)) {
            return null;
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget((IPropertySource)model);
        cmd.setPropertyId(property);
        cmd.setPropertyValue(value);
        return cmd;
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        List<Object> selection = this.getSelectionForType(MTextElement.class);
        return selection.size() > 0;
    }

    protected JSSCompoundCommand createIncremenrtsCommand(boolean increment, List<Object> models) {
        JSSCompoundCommand changeSizeCommands = new JSSCompoundCommand(null);
        for (Object model : models) {
            Object fontSize = ((APropertyNode)model).getPropertyActualValue("fontSize");
            Float newValue = Float.valueOf(2.0f);
            if (fontSize == null || fontSize.toString().length() <= 0) continue;
            newValue = Float.valueOf(fontSize.toString());
            Integer plus = null;
            plus = increment ? Integer.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)factor.intValue()) + 1) : Integer.valueOf(Math.round(new Float(newValue.floatValue()).floatValue() / 100.0f * (float)(-factor.intValue())) - 1);
            if (newValue.floatValue() + (float)plus.intValue() > 99.0f) {
                newValue = Float.valueOf(99.0f);
            } else if (newValue.floatValue() + (float)plus.intValue() > 0.0f) {
                newValue = Float.valueOf(newValue.floatValue() + (float)plus.intValue());
            }
            Command c = this.createCommand(model, newValue, "fontSize");
            changeSizeCommands.setReferenceNodeIfNull(model);
            if (c == null) continue;
            changeSizeCommands.add(c);
        }
        return changeSizeCommands;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.controlsArea != null) {
            this.controlsArea.dispose();
            this.controlsArea = null;
        }
        factor = 10;
    }

    protected abstract boolean isIncrement();
}

