/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.toolbars.text;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.property.ResetValueCommand;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.swt.widgets.NumericTableCombo;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.views.properties.IPropertySource;

public class TextualFontSizeContributionItem
extends CommonToolbarHandler {
    protected static MouseAdapter macComboMenuOpener = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            Menu menu;
            if (e.button == 3 && ((Control)e.widget).getMenu() != null && !(menu = ((Control)e.widget).getMenu()).isDisposed() && !menu.isVisible()) {
                Point location = e.widget.getDisplay().getCursorLocation();
                menu.setLocation(location.x, location.y);
                menu.setVisible(true);
            }
        }
    };
    private APropertyNode showedNode = null;
    private Composite controlsArea;
    private NumericTableCombo fontSize;
    private boolean refreshing = false;
    private PropertyChangeListener nodeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TextualFontSizeContributionItem.this.fontSize == null || TextualFontSizeContributionItem.this.fontSize.isDisposed()) {
                return;
            }
            TextualFontSizeContributionItem.this.refreshing = true;
            List selection = TextualFontSizeContributionItem.this.getSelectionForType(MTextElement.class);
            if (selection.size() == 1) {
                APropertyNode node = (APropertyNode)selection.get(0);
                Object actaulValue = node.getPropertyActualValue("fontSize");
                Object ownValue = node.getPropertyValue("fontSize");
                TextualFontSizeContributionItem.this.setFontSizeComboText(actaulValue, ownValue);
            } else {
                TextualFontSizeContributionItem.this.setFontSizeComboText(null, null);
                if (TextualFontSizeContributionItem.this.showedNode != null) {
                    TextualFontSizeContributionItem.this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(TextualFontSizeContributionItem.this.nodeChangeListener);
                    TextualFontSizeContributionItem.this.showedNode = null;
                }
            }
            TextualFontSizeContributionItem.this.refreshing = false;
        }
    };
    private SelectionAdapter fontSizeComboModify = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!TextualFontSizeContributionItem.this.refreshing) {
                List selection = TextualFontSizeContributionItem.this.getSelectionForType(MTextElement.class);
                if (selection.isEmpty()) {
                    return;
                }
                JSSCompoundCommand cc = new JSSCompoundCommand(null);
                Float value = TextualFontSizeContributionItem.this.fontSize.getValueAsFloat();
                for (Object obj : selection) {
                    Command changeValueCmd = TextualFontSizeContributionItem.this.createCommand(obj, value, "fontSize");
                    if (changeValueCmd == null) continue;
                    cc.add(changeValueCmd);
                    cc.setReferenceNodeIfNull(obj);
                }
                CommandStack cs = TextualFontSizeContributionItem.this.getCommandStack();
                if (cs != null) {
                    TextualFontSizeContributionItem.this.getCommandStack().execute((Command)cc);
                }
            }
        }
    };

    protected NumericTableCombo getFontSizeCombo(Composite parent) {
        NumericTableCombo result = new NumericTableCombo(parent, 4, 0, 6){

            @Override
            protected Point computeSize(Composite container, int wHint, int hHint) {
                int width = wHint;
                int height = hHint;
                Point defaultSize = this.getDefaultComboSize();
                if (wHint == -1) {
                    int n = width = defaultSize != null ? defaultSize.x : 50;
                }
                if (hHint == -1) {
                    height = defaultSize != null ? defaultSize.y : 23;
                }
                return new Point(width, height);
            }
        };
        result.setMaximum(new Double(3.4028234663852886E38));
        result.setData(WIDGET_DATA_KEY, "fontSize");
        result.setItems(ModelUtils.FONT_SIZES);
        return result;
    }

    @Override
    protected Control createControl(Composite parent) {
        this.controlsArea = new Composite(parent, 0);
        RowLayout layout = new RowLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.controlsArea.setLayout((Layout)layout);
        this.fontSize = this.getFontSizeCombo(this.controlsArea);
        this.fontSize.addSelectionListener((SelectionListener)this.fontSizeComboModify);
        RowData data = new RowData();
        data.width = 80;
        this.fontSize.setLayoutData(data);
        this.setAllControlsData();
        return this.controlsArea;
    }

    @Override
    protected boolean fillWithToolItems(ToolBar parent) {
        ToolItem tiFontSizeCombo = new ToolItem(parent, 2);
        this.fontSize = this.getFontSizeCombo((Composite)parent);
        this.fontSize.addSelectionListener((SelectionListener)this.fontSizeComboModify);
        this.fontSize.pack();
        tiFontSizeCombo.setWidth(65);
        tiFontSizeCombo.setControl((Control)this.fontSize);
        this.getToolItems().add(tiFontSizeCombo);
        this.setAllControlsData();
        return true;
    }

    protected Command createCommand(Object model, Object value, Object property) {
        if (!(model instanceof IPropertySource)) {
            return null;
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget((IPropertySource)model);
        cmd.setPropertyId(property);
        cmd.setPropertyValue(value);
        return cmd;
    }

    @Override
    public boolean isVisible() {
        boolean selectionValid;
        if (!super.isVisible()) {
            return false;
        }
        List<Object> selection = this.getSelectionForType(MTextElement.class);
        boolean bl = selectionValid = selection.size() > 0;
        if (selectionValid) {
            this.setAllControlsData();
        } else if (this.showedNode != null) {
            this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            this.showedNode = null;
        }
        return selectionValid;
    }

    protected void setFontSizeComboText(Object resolvedValue, Object elementValue) {
        if (this.fontSize == null || this.fontSize.isDisposed()) {
            return;
        }
        if (resolvedValue != null) {
            int oldpos = this.fontSize.getCaretPosition();
            if (elementValue == null) {
                this.fontSize.setDefaultValue((Number)resolvedValue);
            }
            this.fontSize.setValue((Number)elementValue);
            if (this.fontSize.getText().length() >= oldpos) {
                this.fontSize.setSelection(new Point(oldpos, oldpos));
            }
        } else if (elementValue != null) {
            int oldpos = this.fontSize.getCaretPosition();
            this.fontSize.setValue((Number)elementValue);
            if (this.fontSize.getText().length() >= oldpos) {
                this.fontSize.setSelection(new Point(oldpos, oldpos));
            }
        } else {
            this.fontSize.setValue(null);
        }
    }

    protected void setAllControlsData() {
        if (this.fontSize == null || this.fontSize.isDisposed()) {
            return;
        }
        this.refreshing = true;
        List<Object> selection = this.getSelectionForType(MTextElement.class);
        if (selection.size() == 1) {
            APropertyNode node = (APropertyNode)selection.get(0);
            Object actaulSizeValue = node.getPropertyActualValue("fontSize");
            Object ownSizeValue = node.getPropertyValue("fontSize");
            this.setFontSizeComboText(actaulSizeValue, ownSizeValue);
            this.createContextualMenu(node, (Control)this.fontSize, "fontSize");
            if (this.showedNode != null) {
                this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            }
            this.showedNode = node;
            this.showedNode.getPropertyChangeSupport().addPropertyChangeListener(this.nodeChangeListener);
        } else {
            this.setFontSizeComboText(null, null);
            if (this.showedNode != null) {
                this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
                this.showedNode = null;
            }
        }
        this.refreshing = false;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.showedNode != null) {
            this.showedNode.getPropertyChangeSupport().removePropertyChangeListener(this.nodeChangeListener);
            this.showedNode = null;
        }
        if (this.controlsArea != null) {
            this.controlsArea.dispose();
            this.controlsArea = null;
        }
        this.fontSize = null;
        this.refreshing = false;
    }

    protected void createContextualMenu(final APropertyNode node, final Control control, final String propertyID) {
        if (node != null && control != null && !control.isDisposed()) {
            DefaultValue defaultEntry;
            boolean handleComboListener;
            boolean bl = handleComboListener = Util.isMac() && control.getClass() == Combo.class;
            if (handleComboListener) {
                control.removeMouseListener((MouseListener)macComboMenuOpener);
            }
            boolean entryCreated = false;
            Map<String, DefaultValue> defaultMap = node.getDefaultsPropertiesMap();
            if (defaultMap != null && (defaultEntry = defaultMap.get(propertyID)) != null && (defaultEntry.isNullable() || defaultEntry.hasDefault())) {
                Menu controlMenu = new Menu(control);
                if (defaultEntry.hasDefault()) {
                    MenuItem resetItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    resetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResetValueCommand cmd = new ResetValueCommand();
                            cmd.setPropertyId(propertyID);
                            cmd.setTarget(node);
                            CommandStack cs = TextualFontSizeContributionItem.this.getCommandStack();
                            cs.execute((Command)cmd);
                            control.setFocus();
                        }
                    });
                    resetItem.setText(Messages.ASPropertyWidget_0);
                }
                if (defaultEntry.isNullable()) {
                    MenuItem nullItem = new MenuItem(controlMenu, 0);
                    entryCreated = true;
                    nullItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SetValueCommand cmd = new SetValueCommand();
                            cmd.setPropertyId(propertyID);
                            cmd.setTarget(node);
                            cmd.setPropertyValue(null);
                            CommandStack cs = TextualFontSizeContributionItem.this.getCommandStack();
                            cs.execute((Command)cmd);
                            control.setFocus();
                        }
                    });
                    nullItem.setText(Messages.ASPropertyWidget_1);
                }
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(controlMenu);
                if (handleComboListener) {
                    control.addMouseListener((MouseListener)macComboMenuOpener);
                }
            }
            if (!entryCreated) {
                if (control.getMenu() != null) {
                    control.getMenu().dispose();
                }
                control.setMenu(null);
            }
        }
    }
}

