/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.utils.ModelUtils;
import java.io.Serializable;
import org.eclipse.swt.graphics.RGB;

public class AlfaRGB
implements Serializable {
    private static final long serialVersionUID = 1283053372093648788L;
    private RGB rgb;
    private int alfa;

    public AlfaRGB(RGB rgb, int alfa) {
        this.rgb = rgb;
        this.alfa = alfa;
    }

    public RGB getRgb() {
        return this.rgb;
    }

    public int getAlfa() {
        return this.alfa;
    }

    public static AlfaRGB getFullyOpaque(RGB rgb) {
        return rgb != null ? new AlfaRGB(rgb, 255) : null;
    }

    public static AlfaRGB getFullyTransparent(RGB rgb) {
        return rgb != null ? new AlfaRGB(rgb, 0) : null;
    }

    public static RGB safeGetRGB(AlfaRGB argb) {
        return argb != null ? argb.getRgb() : null;
    }

    public void setAlfa(int alfa) {
        if (alfa >= 0 && alfa <= 255) {
            this.alfa = alfa;
        }
    }

    public void setAlfa(double alfa) {
        int value = new Long(Math.round(255.0 * alfa)).intValue();
        if (value < 0) {
            value = 0;
        }
        if (value > 255) {
            value = 255;
        }
        this.alfa = value;
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && arg0 instanceof AlfaRGB) {
            AlfaRGB color = (AlfaRGB)arg0;
            return color.getAlfa() == this.alfa && ModelUtils.safeEquals(this.getRgb(), color.getRgb());
        }
        return false;
    }

    public AlfaRGB clone() {
        RGB newRGB = null;
        if (this.rgb != null) {
            newRGB = new RGB(this.rgb.red, this.rgb.green, this.rgb.blue);
        }
        return new AlfaRGB(newRGB, this.alfa);
    }
}

