/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public class GridDataUtil {
    public static GridData createFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    public static GridData createHorizontalFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    public static GridData createVerticalFill() {
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    public static int getStyle(GridData gridData) {
        if (gridData == null) {
            return 0;
        }
        int style = 0;
        switch (gridData.verticalAlignment) {
            case 1: {
                style |= 2;
                break;
            }
            case 2: {
                style |= 4;
                break;
            }
            case 4: {
                style |= 0x10;
                break;
            }
            case 3: {
                style |= 8;
            }
        }
        switch (gridData.horizontalAlignment) {
            case 1: {
                style |= 0x20;
                break;
            }
            case 2: {
                style |= 0x40;
                break;
            }
            case 4: {
                style |= 0x100;
                break;
            }
            case 3: {
                style |= 0x80;
            }
        }
        if (gridData.grabExcessVerticalSpace) {
            style |= 0x400;
        }
        if (gridData.grabExcessHorizontalSpace) {
            style |= 0x200;
        }
        return style;
    }

    public static GridData clone(GridData gridData) {
        GridData clone = new GridData(GridDataUtil.getStyle(gridData));
        clone.heightHint = gridData.heightHint;
        clone.horizontalIndent = gridData.horizontalIndent;
        clone.horizontalSpan = gridData.horizontalSpan;
        clone.verticalSpan = gridData.verticalSpan;
        clone.widthHint = gridData.widthHint;
        return clone;
    }

    public static void gridDataExclude(Control control, boolean exclude) {
        Assert.isNotNull((Object)control);
        if (control.getLayoutData() == null) {
            return;
        }
        Assert.isTrue((boolean)(control.getLayoutData() instanceof GridData));
        ((GridData)control.getLayoutData()).exclude = exclude;
    }

    public static void setLayoutDataForItem(ActionContributionItem actionItem, GridData gd) {
        Assert.isNotNull((Object)actionItem);
        Assert.isNotNull((Object)gd);
        if (actionItem.getWidget() instanceof Control) {
            ((Control)actionItem.getWidget()).setLayoutData((Object)gd);
        }
    }

    public static void setGridDataExcludeAndVisibility(Control control, boolean exclude) {
        Assert.isNotNull((Object)control);
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            control.setEnabled(!exclude);
            control.setVisible(!exclude);
            ((GridData)control.getLayoutData()).exclude = exclude;
        }
    }
}

