/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.BigIntegerValidator;
import org.apache.commons.validator.routines.ByteValidator;
import org.apache.commons.validator.routines.DoubleValidator;
import org.apache.commons.validator.routines.FloatValidator;
import org.apache.commons.validator.routines.IntegerValidator;
import org.apache.commons.validator.routines.LongValidator;
import org.apache.commons.validator.routines.ShortValidator;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class NumberValidator
implements VerifyListener {
    private Number min;
    private Number max;
    private Class<?> type;

    public NumberValidator(Number min, Number max, Class<?> type) {
        this.min = min;
        this.max = max;
        this.type = type;
    }

    public void verifyText(VerifyEvent e) {
        switch (e.keyCode) {
            case 4: 
            case 8: 
            case 127: 
            case 0x1000007: 
            case 0x1000008: {
                return;
            }
        }
        if (Misc.isNullOrEmpty((String)e.text)) {
            e.doit = false;
            return;
        }
        String number = e.text;
        String oldText = ((Text)e.widget).getText();
        if (e.start != e.end) {
            number = String.valueOf(oldText.substring(0, e.start)) + e.text;
            if (oldText.length() - 1 > e.start) {
                number = String.valueOf(number) + oldText.substring(e.end);
            }
        } else {
            number = String.valueOf(oldText.substring(0, e.start)) + e.text;
            if (oldText.length() - 1 > e.start) {
                number = String.valueOf(number) + oldText.substring(e.end);
            }
        }
        if (number.equals("-")) {
            number = "-0";
        }
        if (number.equals(".")) {
            number = "0.";
        }
        if (number.isEmpty()) {
            e.doit = true;
            return;
        }
        e.doit = this.type.equals(Long.class) ? LongValidator.getInstance().isValid(number, Locale.US) : (this.type.equals(BigInteger.class) ? BigIntegerValidator.getInstance().isValid(number, Locale.US) : (this.type.equals(Float.class) ? FloatValidator.getInstance().isValid(number, Locale.US) : (this.type.equals(Double.class) ? DoubleValidator.getInstance().isValid(number, Locale.US) : (this.type.equals(Integer.class) ? IntegerValidator.getInstance().isValid(number, Locale.US) : (this.type.equals(Short.class) ? ShortValidator.getInstance().isValid(number, Locale.US) : (this.type.equals(Byte.class) ? ByteValidator.getInstance().isValid(number, Locale.US) : BigDecimalValidator.getInstance().isValid(number, Locale.US)))))));
        try {
            Number n = this.getNumber(number, this.type);
            if (n != null) {
                if (e.doit && this.min != null && this.min instanceof Comparable) {
                    boolean bl = e.doit = ((Comparable)((Object)this.min)).compareTo(n) <= 0;
                }
                if (e.doit && this.max != null && this.max instanceof Comparable) {
                    e.doit = ((Comparable)((Object)this.max)).compareTo(n) >= 0;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }

    protected Number getNumber(String number, Class<?> typ) {
        if (typ.equals(Long.class)) {
            return new Long(number);
        }
        if (typ.equals(BigInteger.class)) {
            return new BigInteger(number);
        }
        if (typ.equals(Float.class)) {
            return new Float(number);
        }
        if (typ.equals(Double.class)) {
            return new Double(number);
        }
        if (typ.equals(Integer.class)) {
            return new Integer(number);
        }
        if (typ.equals(Short.class)) {
            return new Short(number);
        }
        if (typ.equals(Byte.class)) {
            return new Byte(number);
        }
        if (typ.equals(BigDecimal.class)) {
            return new BigDecimal(number);
        }
        return null;
    }
}

