/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.JRXMLUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SubreportsUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.parts.subreport.StandardSubreportPartComponent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class PartUtils {
    private PartUtils() {
    }

    public static Map<File, IFile> getSubreportsFromParts(JasperReportsConfiguration jConfig, JasperDesign jd, boolean isRecursive, IProgressMonitor monitor) {
        IFile mainFile = (IFile)jConfig.get("ifile");
        List<JRPart> elements = ModelUtils.getAllPartElements(jd);
        HashMap<File, IFile> result = new HashMap<File, IFile>();
        for (JRPart part : elements) {
            if (!(part.getComponent() instanceof StandardSubreportPartComponent)) continue;
            StandardSubreportPartComponent component = (StandardSubreportPartComponent)part.getComponent();
            PartUtils.findSubreport(jConfig, result, monitor, mainFile, jd, isRecursive, component);
        }
        return result;
    }

    protected static void findSubreport(JasperReportsConfiguration jConfig, Map<File, IFile> fmap, IProgressMonitor monitor, IFile file, JasperDesign parent, boolean isRecursive, StandardSubreportPartComponent ele) {
        block14: {
            File f;
            jConfig.init(file);
            String expr = ExpressionUtil.eval(ele.getExpression(), jConfig, parent);
            if (expr == null || expr.isEmpty()) {
                return;
            }
            if (expr.endsWith(".jasper")) {
                expr = StringUtils.replaceAllIns((String)expr, (String)".jasper$", (String)".jrxml");
            }
            if ((f = FileUtils.findFile((IFile)file, (String)(expr = expr.replaceFirst("repo:", "")))) == null) {
                try {
                    f = PartUtils.fallbackFindFile(file, expr);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (fmap.containsKey(f)) {
                return;
            }
            if (f != null && f.exists()) {
                IFile[] fs = JDTUtils.WS_ROOT.findFilesForLocationURI(f.toURI());
                if (fs != null && fs.length > 0) {
                    IFile ifile = fs[0];
                    fmap.put(f, ifile);
                    try {
                        JasperDesign jd = JRXMLUtils.getJasperDesign(jConfig, ifile.getContents(), ifile.getFileExtension());
                        if (jd == null || !isRecursive) break block14;
                        for (JRDesignElement el : ModelUtils.getAllElements(jd)) {
                            if (el instanceof JRDesignSubreport) {
                                Map<File, IFile> partial = SubreportsUtil.getSubreportFiles(jConfig, ifile, jd, monitor);
                                fmap.putAll(partial);
                            }
                            if (!monitor.isCanceled()) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    fmap.put(f, null);
                }
            }
        }
    }

    private static File fallbackFindFile(IFile file, String expression) {
        File f;
        try {
            f = new File(expression);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            f = new File(file.getRawLocationURI().getPath(), expression);
        }
        return f;
    }
}

