/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.background.MBackgrounImage;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.IMultiEditor;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.ReportContainer;
import com.jaspersoft.studio.editor.util.StringInput;
import com.jaspersoft.studio.editor.util.StringStorage;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.MRoot;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.classpath.ClassLoaderUtil;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class SelectionHelper {
    private static Map<String, IStorageEditorInput> streditors = new HashMap<String, IStorageEditorInput>();

    private SelectionHelper() {
    }

    public static EditPart getEditPart(JRChild jrElement) {
        ANode node = SelectionHelper.getNode(jrElement);
        return SelectionHelper.getEditPart(node);
    }

    public static EditPart getEditPart(ANode node) {
        if (node != null) {
            EditPart figure = node.getFigureEditPart();
            if (figure != null) {
                return figure;
            }
            return node.getTreeEditPart();
        }
        return null;
    }

    public static ANode getNode(Object jrElement) {
        AbstractJRXMLEditor jrxmlEditor;
        IEditorPart designEditor;
        IEditorPart activeEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeEditor != null && activeEditor instanceof AbstractJRXMLEditor && (designEditor = (jrxmlEditor = (AbstractJRXMLEditor)activeEditor).getActiveInnerEditor()) instanceof AbstractVisualEditor) {
            AbstractVisualEditor visualEditor = (AbstractVisualEditor)designEditor;
            INode model = visualEditor.getModel();
            if (model instanceof MRoot) {
                model = model.getChildren().get(0);
            }
            if (model instanceof MReport) {
                return ((MReport)model).getNode(jrElement);
            }
            if (model instanceof MPage) {
                return ((MPage)model).getNode(jrElement);
            }
        }
        return null;
    }

    public static EditPart getBackgroundEditPart() {
        IEditorPart editorpart = SelectionHelper.getActiveJRXMLEditor();
        if (editorpart instanceof JrxmlEditor) {
            MRoot root = (MRoot)((JrxmlEditor)editorpart).getModel();
            for (INode node : ((MReport)root.getChildren().get(0)).getChildren()) {
                if (!(node instanceof MBackgrounImage)) continue;
                return ((MBackgrounImage)node).getFigureEditPart();
            }
        }
        return null;
    }

    public static ANode getOpenedRoot() {
        IEditorPart editPart = SelectionHelper.getActiveJRXMLEditor();
        if (editPart instanceof IMultiEditor) {
            return (ANode)((IMultiEditor)editPart).getModel();
        }
        return null;
    }

    public static IEditorPart getActiveJRXMLEditor() {
        IWorkbenchWindow activeWorkbenchWindow = JaspersoftStudioPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null) {
            IWorkbenchPart part;
            IEditorReference[] editorReferences;
            IEditorPart p = activeWorkbenchWindow.getActivePage().getActiveEditor();
            if (p == null && (editorReferences = activeWorkbenchWindow.getActivePage().getEditorReferences()).length == 1 && (part = editorReferences[0].getPart(false)) instanceof IEditorPart) {
                p = (IEditorPart)part;
            }
            return p;
        }
        return null;
    }

    public static boolean isSelected(JRDesignElement jrElement) {
        ISelection sel;
        EditPart ep = SelectionHelper.getEditPart((JRChild)jrElement);
        if (ep != null && (sel = ep.getViewer().getSelection()) instanceof StructuredSelection) {
            for (Object o : ((StructuredSelection)sel).toList()) {
                if (!(o instanceof EditPart) || (EditPart)o != ep) continue;
                return true;
            }
        }
        return false;
    }

    public static void setSelection(JRChild jrElement, boolean add) {
        ANode mainNode;
        EditPart ep = SelectionHelper.getEditPart(jrElement);
        if (ep != null && !JSSCompoundCommand.isRefreshEventsIgnored(mainNode = JSSCompoundCommand.getMainNode((ANode)ep.getModel()))) {
            ISelection sel = ep.getViewer().getSelection();
            ArrayList<Object> s = new ArrayList<Object>();
            s.add(ep);
            if (add && sel instanceof StructuredSelection) {
                for (Object o : ((StructuredSelection)sel).toList()) {
                    s.add(o);
                }
            }
            ep.getViewer().setSelection((ISelection)new StructuredSelection(s));
            ep.getViewer().reveal(ep);
        }
    }

    public static void setOutlineSelection(Object jrElement) {
        EditPart part;
        ANode node = SelectionHelper.getNode(jrElement);
        if (node != null && (part = node.getTreeEditPart()) != null) {
            part.getViewer().setSelection((ISelection)new StructuredSelection((Object)part));
        }
    }

    public static Pair<ISelection, EditPartViewer> setSelection(List<JRChild> jrElements, boolean add) {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        for (JRChild jrElement : jrElements) {
            EditPart ep = SelectionHelper.getEditPart(jrElement);
            if (ep == null) continue;
            editParts.add(ep);
        }
        return SelectionHelper.setEditPartsSelection(editParts, add);
    }

    public static Pair<ISelection, EditPartViewer> setNodeSelection(List<ANode> elements, boolean add) {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        for (ANode element : elements) {
            EditPart ep = SelectionHelper.getEditPart(element);
            if (ep == null) continue;
            editParts.add(ep);
        }
        return SelectionHelper.setEditPartsSelection(editParts, add);
    }

    public static Pair<ISelection, EditPartViewer> setEditPartsSelection(List<EditPart> editParts, boolean add) {
        EditPart firstPart;
        ANode mainNode;
        if (!editParts.isEmpty() && !JSSCompoundCommand.isRefreshEventsIgnored(mainNode = JSSCompoundCommand.getMainNode((ANode)(firstPart = editParts.get(0)).getModel()))) {
            ISelection oldSelection = firstPart.getViewer().getSelection();
            ArrayList<Object> s = new ArrayList<Object>();
            s.addAll(editParts);
            if (add && oldSelection instanceof StructuredSelection) {
                for (Object o : ((StructuredSelection)oldSelection).toList()) {
                    s.add(o);
                }
            }
            firstPart.getViewer().setSelection((ISelection)new StructuredSelection(s));
            firstPart.getViewer().reveal(firstPart);
            return new Pair((Object)oldSelection, (Object)firstPart.getViewer());
        }
        return null;
    }

    public static EditPart getEditPartByValue(Object jrValue, EditPartViewer viewer) {
        for (Map.Entry entry : viewer.getEditPartRegistry().entrySet()) {
            INode node;
            Object value;
            Map.Entry typedEntry = entry;
            if (!(typedEntry.getKey() instanceof INode) || (value = (node = (INode)typedEntry.getKey()).getValue()) != jrValue) continue;
            return (EditPart)typedEntry.getValue();
        }
        return null;
    }

    public static void deselectAll() {
        ReportContainer reportEditor;
        IEditorPart activeReportEditor;
        IEditorPart editor;
        AbstractJRXMLEditor jrxmlEditor = (AbstractJRXMLEditor)SelectionHelper.getActiveJRXMLEditor();
        if (jrxmlEditor != null && (editor = jrxmlEditor.getActiveEditor()) instanceof ReportContainer && (activeReportEditor = (reportEditor = (ReportContainer)editor).getActiveEditor()) instanceof AbstractVisualEditor) {
            GraphicalViewer viewer = ((AbstractVisualEditor)activeReportEditor).getGraphicalViewer();
            viewer.deselectAll();
        }
    }

    public static void setBackgroundSelected() {
        EditPart ep = SelectionHelper.getBackgroundEditPart();
        if (ep != null && ((GraphicalEditPart)ep).getFigure().isVisible()) {
            ep.getViewer().deselectAll();
            ep.getViewer().select(ep);
        }
    }

    public static void deselectBackground() {
        EditPart ep = SelectionHelper.getBackgroundEditPart();
        if (ep != null) {
            ep.getViewer().deselect(ep);
        }
    }

    public static boolean isBackgroundEditable() {
        IEditorPart currentEditor = SelectionHelper.getActiveJRXMLEditor();
        if (currentEditor instanceof JrxmlEditor) {
            JrxmlEditor jrxmlEditor = (JrxmlEditor)currentEditor;
            return jrxmlEditor.getReportContainer().isBackgroundImageEditable();
        }
        return false;
    }

    public static final void openEditor(File file) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            }
            IWorkbenchPage page = window.getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }

    public static final void openEditor(String content, String name) {
        IStorageEditorInput input = streditors.computeIfAbsent(content, c -> {
            StringStorage storage = new StringStorage((String)c);
            return new StringInput(storage);
        });
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = window.getActivePage();
        try {
            IEditorReference[] er = page.findEditors((IEditorInput)input, name, 1);
            if (er != null) {
                page.closeEditors(er, false);
            }
            page.openEditor((IEditorInput)input, name);
        }
        catch (PartInitException e) {
            UIUtils.showError((Throwable)e);
        }
    }

    public static final boolean openEditor(FileEditorInput editorInput, String path) {
        return SelectionHelper.openEditor(editorInput.getFile(), path);
    }

    public static final boolean openEditor(IFile file) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (PartInitException e) {
            UIUtils.showError((Throwable)e);
        }
        return true;
    }

    public static final boolean openEditorType(IFile file, String editorID) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.setDefaultEditor((IFile)file, (String)editorID);
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorID);
        }
        catch (PartInitException e) {
            UIUtils.showError((Throwable)e);
        }
        return true;
    }

    public static final void openEditorFile(IFile file) {
        UIUtils.getDisplay().asyncExec(() -> {
            boolean bl = SelectionHelper.openEditor(file);
        });
    }

    public static final boolean openEditor(IFile file, String path) {
        try {
            File fileToBeOpened;
            if (file != null && path != null && (fileToBeOpened = SelectionHelper.resolveFile(path)) != null && fileToBeOpened.exists() && fileToBeOpened.isFile()) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToBeOpened.toURI());
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                return true;
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static File resolveFile(String path) {
        return FileUtils.resolveFileUrl((String)path, SelectionHelper.getRoots(), (boolean)true);
    }

    public static File resolveFile(IFile file, String location) {
        return FileUtils.resolveFileUrl((String)location, SelectionHelper.getRoots(file), (boolean)true);
    }

    private static List<File> getRoots() {
        IEditorPart ep = SelectionHelper.getActiveJRXMLEditor();
        if (ep != null && ep.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput fe = (IFileEditorInput)ep.getEditorInput();
            return SelectionHelper.getRoots(fe.getFile());
        }
        return Arrays.asList(new File("."));
    }

    private static List<File> getRoots(IFile file) {
        return file == null ? Arrays.asList(new File(".")) : Arrays.asList(new File(file.getParent().getLocationURI()), new File(file.getProject().getLocationURI()));
    }

    public static void setClassLoader(IFile file, IProgressMonitor monitor) {
        try {
            Thread.currentThread().setContextClassLoader(ClassLoaderUtil.getClassLoader4Project((IProgressMonitor)monitor, (IProject)file.getProject()));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IJavaProject getJavaProjectFromCurrentJRXMLEditor() {
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor.getEditorInput() instanceof IFileEditorInput) {
            IProject prj = ((IFileEditorInput)activeJRXMLEditor.getEditorInput()).getFile().getProject();
            return JavaCore.create((IProject)prj);
        }
        return null;
    }

    public static boolean isMainEditorOpened() {
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor instanceof JrxmlEditor) {
            return ((JrxmlEditor)activeJRXMLEditor).getReportContainer().getActivePage() == 0;
        }
        return false;
    }

    public static boolean isCurrentSelectionVirtualResource() {
        Object firstElement;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        return selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource && ((IResource)firstElement).isVirtual();
    }

    public static List<JrxmlEditor> getOpenedEditors() {
        ArrayList<JrxmlEditor> editors = new ArrayList<JrxmlEditor>();
        IWorkbenchWindow activeWorkbenchWindow = JaspersoftStudioPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null) {
            IEditorReference[] editorRefs;
            IEditorReference[] iEditorReferenceArray = editorRefs = activeWorkbenchWindow.getActivePage().getEditorReferences();
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editor = editorRef.getEditor(false);
                if (editor instanceof JrxmlEditor) {
                    editors.add((JrxmlEditor)editor);
                }
                ++n2;
            }
        }
        return editors;
    }

    private static EditPart getMainEditPart() {
        ReportContainer reportEditor;
        IEditorPart activeReportEditor;
        IEditorPart editor;
        AbstractJRXMLEditor jrxmlEditor = (AbstractJRXMLEditor)SelectionHelper.getActiveJRXMLEditor();
        if (jrxmlEditor != null && (editor = jrxmlEditor.getActiveEditor()) instanceof ReportContainer && (activeReportEditor = (reportEditor = (ReportContainer)editor).getActiveEditor()) instanceof AbstractVisualEditor) {
            GraphicalViewer viewer = ((AbstractVisualEditor)activeReportEditor).getGraphicalViewer();
            return (EditPart)viewer.getRootEditPart().getChildren().get(0);
        }
        return null;
    }

    public static Point getCursorCurrentRelativePosition() {
        GraphicalEditPart part = (GraphicalEditPart)SelectionHelper.getMainEditPart();
        if (part != null) {
            Display display = Display.getDefault();
            Point point = part.getViewer().getControl().toControl(display.getCursorLocation());
            IFigure figure = part.getFigure();
            PrecisionRectangle t = new PrecisionRectangle((double)point.x, (double)point.y, 0.0, 0.0);
            figure.translateToRelative((Translatable)t);
            figure.translateFromParent((Translatable)t);
            Rectangle result = t.getTranslated(-ReportPageFigure.PAGE_BORDER.left, -ReportPageFigure.PAGE_BORDER.right);
            return new Point(result.x, result.y);
        }
        return null;
    }

    public static Point getCursorRelativePositionOnClick(int mouseButton) {
        GraphicalEditPart part;
        Point cursorPosition = JasperReportsPlugin.getLastClickLocation((int)mouseButton);
        if (cursorPosition != null && (part = (GraphicalEditPart)SelectionHelper.getMainEditPart()) != null) {
            Point point = part.getViewer().getControl().toControl(cursorPosition);
            IFigure figure = part.getFigure();
            PrecisionRectangle t = new PrecisionRectangle((double)point.x, (double)point.y, 0.0, 0.0);
            figure.translateToRelative((Translatable)t);
            figure.translateFromParent((Translatable)t);
            Rectangle result = t.getTranslated(-ReportPageFigure.PAGE_BORDER.left, -ReportPageFigure.PAGE_BORDER.right);
            return new Point(result.x, result.y);
        }
        return null;
    }
}

